/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.stackwalker.BaseStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm29.j9.stackwalker.TerseStackWalkerCallbacks;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMEntryLocalStoragePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import java.io.PrintStream;

public class StackWalkCommand
extends Command {
    public StackWalkCommand() {
        this.addCommand("stack", "<thread>", "Walks the Java stack for <thread>");
        this.addCommand("stackslots", "<thread>", "Walks the Java stack (including objects) for <thread>");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            UDATAPointer sp = UDATAPointer.NULL;
            UDATAPointer arg0EA = UDATAPointer.NULL;
            U8Pointer pc = U8Pointer.NULL;
            J9MethodPointer literals = J9MethodPointer.NULL;
            J9VMEntryLocalStoragePointer entryLocalStorage = J9VMEntryLocalStoragePointer.NULL;
            String[] realArgs = null;
            if (args.length != 0) {
                realArgs = args[0].split(",");
            }
            if (args.length == 0 || realArgs.length != 1 && realArgs.length != 5 && realArgs.length != 6) {
                CommandUtils.dbgPrint(out, "Usage:\n");
                CommandUtils.dbgPrint(out, "\t!stack thread\n");
                CommandUtils.dbgPrint(out, "\t!stack thread,sp,a0,pc,literals\n");
                CommandUtils.dbgPrint(out, "\t!stack thread,sp,a0,pc,literals,els\n");
                CommandUtils.dbgPrint(out, "\tUse !stackslots instead of !stack to see slot values\n");
                if (J9BuildFlags.J9VM_INTERP_NATIVE_SUPPORT) {
                    CommandUtils.dbgPrint(out, "\tUse !jitstack or !jitstackslots to start the walk at a JIT frame\n");
                }
                return;
            }
            long address = CommandUtils.parsePointer(realArgs[0], J9BuildFlags.J9VM_ENV_DATA64);
            if (0L == address) {
                return;
            }
            J9VMThreadPointer thread = J9VMThreadPointer.cast(address);
            StackWalkerUtils.enableVerboseLogging(3, out);
            WalkState walkState = new WalkState();
            walkState.flags = J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET;
            if (realArgs.length >= 5) {
                address = CommandUtils.parsePointer(realArgs[1], J9BuildFlags.J9VM_ENV_DATA64);
                sp = UDATAPointer.cast(address);
                address = CommandUtils.parsePointer(realArgs[2], J9BuildFlags.J9VM_ENV_DATA64);
                arg0EA = UDATAPointer.cast(address);
                address = CommandUtils.parsePointer(realArgs[3], J9BuildFlags.J9VM_ENV_DATA64);
                pc = U8Pointer.cast(address);
                address = CommandUtils.parsePointer(realArgs[4], J9BuildFlags.J9VM_ENV_DATA64);
                literals = J9MethodPointer.cast(address);
            } else {
                sp = thread.sp();
                arg0EA = thread.arg0EA();
                pc = thread.pc();
                literals = thread.literals();
            }
            if (realArgs.length >= 6) {
                address = CommandUtils.parsePointer(realArgs[5], J9BuildFlags.J9VM_ENV_DATA64);
                entryLocalStorage = J9VMEntryLocalStoragePointer.cast(address);
            } else if (J9BuildFlags.J9VM_INTERP_NATIVE_SUPPORT) {
                entryLocalStorage = thread.entryLocalStorage();
            }
            if (command.equalsIgnoreCase("!stackslots")) {
                walkState.flags |= J9Consts.J9_STACKWALK_ITERATE_O_SLOTS;
                StackWalkerUtils.enableVerboseLogging(100, out);
                walkState.callBacks = new BaseStackWalkerCallbacks();
            } else {
                StackWalkerUtils.enableVerboseLogging(0, out);
                walkState.callBacks = new TerseStackWalkerCallbacks();
                walkState.flags |= J9Consts.J9_STACKWALK_ITERATE_FRAMES;
            }
            walkState.walkThread = thread;
            walkState.walkSP = sp;
            walkState.arg0EA = arg0EA;
            walkState.pc = pc;
            walkState.literals = literals;
            walkState.fillElsFields(entryLocalStorage);
            StackWalkResult result = StackWalker.walkStackFrames(walkState);
            if (result != StackWalkResult.NONE) {
                out.println("Stack walk result: " + (Object)((Object)result));
            }
            StackWalkerUtils.disableVerboseLogging();
            out.flush();
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

