/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VTableHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Class;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9Method;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.structure.J9VTableHeader;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class J9ClassHelper {
    private static HashMap<Long, HashMap<String, J9ObjectFieldOffset>> classToFieldOffsetCacheMap = new HashMap();
    private static final Map<String, Character> TYPE_MAP = new HashMap<String, Character>();
    private static final int MAXIMUM_ARRAY_ARITY = 100;
    private static final int SYNTHETIC = 4096;
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;

    public static boolean isArrayClass(J9ClassPointer clazz) throws CorruptDataException {
        return J9ClassHelper.classDepthAndFlags(clazz).anyBitsIn(J9JavaAccessFlags.J9AccClassRAMArray);
    }

    public static String getName(J9ClassPointer clazz) throws CorruptDataException {
        return J9UTF8Helper.stringValue(clazz.romClass().className());
    }

    public static String getSignature(J9ClassPointer clazz) throws CorruptDataException {
        String className;
        Character type2;
        String result = J9ClassHelper.isArrayClass(clazz) ? J9ClassHelper.getArrayName(clazz) : ((type2 = TYPE_MAP.get(className = J9ClassHelper.getName(clazz))) != null ? type2.toString() : 'L' + className + ';');
        return result;
    }

    public static String getArrayName(J9ClassPointer clazz) throws CorruptDataException {
        J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(clazz);
        StringBuilder name = new StringBuilder();
        int arity = 0;
        try {
            arity = arrayClass.arity().intValue();
        }
        catch (InvalidDataTypeException e) {
            throw new AddressedCorruptDataException(arrayClass.getAddress(), "Array arity larger than MAXINT");
        }
        if (arity > 100) {
            throw new AddressedCorruptDataException(arrayClass.getAddress(), "Very high arity " + arity + " from array class 0x" + Long.toHexString(arrayClass.getAddress()));
        }
        for (int i = 0; i < arity; ++i) {
            name.append('[');
        }
        String elementClassName = J9ClassHelper.getName(arrayClass.leafComponentType());
        Character type2 = TYPE_MAP.get(elementClassName);
        if (type2 != null) {
            name.append(type2);
        } else {
            name.append('L');
            name.append(elementClassName);
            name.append(";");
        }
        return name.toString();
    }

    public static String getJavaName(J9ClassPointer clazz) throws CorruptDataException {
        String baseName = J9ClassHelper.getName(clazz);
        char ch = baseName.charAt(0);
        if (ch != '[') {
            return baseName;
        }
        J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(clazz);
        int arity = arrayClass.arity().intValue();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < arity; ++i) {
            buf.append("[]");
        }
        String aritySuffix = buf.toString();
        ch = baseName.charAt(1);
        switch (ch) {
            case 'B': {
                return "byte" + aritySuffix;
            }
            case 'C': {
                return "char" + aritySuffix;
            }
            case 'D': {
                return "double" + aritySuffix;
            }
            case 'F': {
                return "float" + aritySuffix;
            }
            case 'I': {
                return "int" + aritySuffix;
            }
            case 'J': {
                return "long" + aritySuffix;
            }
            case 'S': {
                return "void" + aritySuffix;
            }
            case 'V': {
                return "void" + aritySuffix;
            }
            case 'Z': {
                return "boolean" + aritySuffix;
            }
            case 'L': 
            case 'Q': {
                return J9ClassHelper.getName(arrayClass.leafComponentType()) + aritySuffix;
            }
        }
        return baseName;
    }

    public static String formatFullInteractive(J9ClassPointer clazz) {
        String suffix;
        String prefix = clazz.formatFullInteractive();
        try {
            suffix = String.format("\nClass name: %s\nTo view instance shape, use !j9classshape %s", J9ClassHelper.getName(clazz), clazz.getHexAddress());
        }
        catch (CorruptDataException e) {
            suffix = String.format("\nClass name: <ERROR>\n To view instance shape, use !j9classshape %s", clazz.getHexAddress());
        }
        return prefix + suffix;
    }

    public static Iterator<J9ObjectFieldOffset> getFieldOffsets(J9ClassPointer clazz) throws CorruptDataException {
        U32 flags = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE);
        return J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(clazz, J9ClassHelper.superclass(clazz), flags);
    }

    public static J9ClassPointer superclass(J9ClassPointer clazz) throws CorruptDataException {
        long index = J9ClassHelper.classDepth(clazz).longValue() - 1L;
        if (index < 0L) {
            return J9ClassPointer.NULL;
        }
        VoidPointer j9ClassInstancePointer = clazz.superclasses().at(index);
        return J9ClassPointer.cast(j9ClassInstancePointer);
    }

    private static HashMap<String, J9ObjectFieldOffset> getFieldOffsetCache(J9ClassPointer clazz) {
        Long classAddr = clazz.getAddress();
        HashMap<String, J9ObjectFieldOffset> fieldOffsetCache = classToFieldOffsetCacheMap.get(classAddr);
        if (null != fieldOffsetCache) {
            return fieldOffsetCache;
        }
        fieldOffsetCache = new HashMap();
        classToFieldOffsetCacheMap.put(classAddr, fieldOffsetCache);
        return fieldOffsetCache;
    }

    public static J9ObjectFieldOffset checkFieldOffsetCache(J9ClassPointer clazz, String fieldName, String signature) {
        HashMap<String, J9ObjectFieldOffset> fieldOffsetCache = J9ClassHelper.getFieldOffsetCache(clazz);
        return fieldOffsetCache.get(fieldName + "." + signature);
    }

    public static void setFieldOffsetCache(J9ClassPointer clazz, J9ObjectFieldOffset offset, String fieldName, String signature) {
        HashMap<String, J9ObjectFieldOffset> fieldOffsetCache = J9ClassHelper.getFieldOffsetCache(clazz);
        fieldOffsetCache.put(fieldName + "." + signature, offset);
    }

    public static boolean isSameOrSuperClassOf(J9ClassPointer superClazz, J9ClassPointer clazz) throws CorruptDataException {
        long superClassDepth = J9ClassHelper.classDepth(superClazz).longValue();
        if (superClazz.eq(clazz)) {
            return true;
        }
        if (J9ClassHelper.classDepth(clazz).longValue() > superClassDepth) {
            return superClazz.eq(clazz.superclasses().at(superClassDepth));
        }
        return false;
    }

    public static J9VTableHeaderPointer vTableHeader(J9ClassPointer clazz) {
        J9VTableHeaderPointer pointer = J9VTableHeaderPointer.cast(clazz.add(1L));
        return pointer;
    }

    public static UDATAPointer vTable(J9VTableHeaderPointer vTableHeader) {
        UDATAPointer pointer = UDATAPointer.cast(vTableHeader.add(1L));
        return pointer;
    }

    public static UDATAPointer oldVTable(J9ClassPointer clazz) {
        UDATAPointer pointer = UDATAPointer.cast(clazz.add(1L));
        return pointer;
    }

    public static UDATA size(J9ClassPointer clazz, J9JavaVMPointer vm) throws CorruptDataException {
        J9ClassPointer superclass;
        UDATA classDepth;
        UDATA vTableSlotCount;
        UDATA size = new UDATA(J9Class.SIZEOF);
        if (AlgorithmVersion.getVersionOf("ALG_VM_VTABLE_VERSION").getAlgorithmVersion() < 1) {
            vTableSlotCount = J9ClassHelper.oldVTable(clazz).at(0L);
        } else {
            try {
                vTableSlotCount = J9ClassHelper.vTableHeader(clazz).size().add(J9VTableHeader.SIZEOF / (long)UDATA.SIZEOF);
            }
            catch (NoSuchFieldException e) {
                throw new CorruptDataException(e);
            }
        }
        size = size.add(Scalar.convertSlotsToBytes(vTableSlotCount));
        if (vm.jitConfig().notNull()) {
            UDATA jitVTableSlotCount = vTableSlotCount.sub(1L);
            size = size.add(Scalar.convertSlotsToBytes(jitVTableSlotCount));
        }
        if (!J9ROMClassHelper.isArray(clazz.romClass())) {
            UDATA ramMethodsSize = clazz.romClass().romMethodCount().mult((int)J9Method.SIZEOF);
            size = size.add(ramMethodsSize);
            if (vm.runtimeFlags().allBitsIn(J9Consts.J9_RUNTIME_EXTENDED_METHOD_BLOCK)) {
                UDATA extendedMethodBlockSize = Scalar.roundToSizeofUDATA(new UDATA(clazz.romClass().romMethodCount()));
                size = size.add(extendedMethodBlockSize);
            }
            if (!clazz.instanceDescription().anyBitsIn(1L)) {
                UDATA highestBitInSlot = new UDATA(UDATA.SIZEOF * 8 - 1);
                UDATA instanceDescriptionSize = clazz.totalInstanceSize().rightShift((int)(ObjectReferencePointer.SIZEOF >> 2) + 1);
                instanceDescriptionSize = instanceDescriptionSize.add(highestBitInSlot).bitAnd(highestBitInSlot.bitNot());
                if (J9BuildFlags.J9VM_GC_LEAF_BITS) {
                    instanceDescriptionSize = instanceDescriptionSize.mult(2);
                }
                size = size.add(instanceDescriptionSize);
            }
            UDATA staticSlotCount = clazz.romClass().objectStaticCount().add(clazz.romClass().singleScalarStaticCount());
            staticSlotCount = J9BuildFlags.J9VM_ENV_DATA64 ? staticSlotCount.add(clazz.romClass().doubleScalarStaticCount()) : staticSlotCount.add(1L).bitAnd(-2L).add(clazz.romClass().doubleScalarStaticCount().mult(2));
            size = size.add(Scalar.convertSlotsToBytes(new UDATA(staticSlotCount)));
            UDATA constantPoolSlotCount = clazz.romClass().ramConstantPoolCount().mult(2);
            size = size.add(Scalar.convertSlotsToBytes(new UDATA(constantPoolSlotCount)));
        }
        size = (classDepth = J9ClassHelper.classDepthAndFlags(clazz).bitAnd(J9JavaAccessFlags.J9AccClassDepthMask)).eq(0L) ? size.add(UDATA.SIZEOF) : size.add(Scalar.convertSlotsToBytes(classDepth));
        if (clazz.iTable().notNull() && ((superclass = J9ClassPointer.cast(clazz.superclasses().at(classDepth.sub(1L)))).isNull() || !superclass.iTable().eq(clazz.iTable()))) {
            J9ITablePointer iTable = J9ITablePointer.cast(clazz.iTable());
            if (superclass.isNull()) {
                while (iTable.next().notNull()) {
                    iTable = iTable.next();
                }
            } else {
                while (iTable.next().notNull() && !iTable.next().eq(superclass.iTable())) {
                    iTable = iTable.next();
                }
            }
            iTable = clazz.romClass().modifiers().allBitsIn(J9JavaAccessFlags.J9AccInterface) ? iTable.add(1L) : iTable.add(1L).addOffset(iTable.interfaceClass().romClass().romMethodCount().mult(UDATA.SIZEOF));
            size = size.add(iTable.getAddress() - clazz.iTable().getAddress());
        }
        return size;
    }

    public static int getJavaLangClassModifiers(J9ClassPointer j9class) throws CorruptDataException {
        int rawModifiers = J9ClassHelper.getRawModifiers(j9class);
        rawModifiers = J9ClassHelper.isArrayClass(j9class) ? (rawModifiers &= 0x417) : (rawModifiers &= 0x761F);
        return rawModifiers;
    }

    public static int getRawModifiers(J9ClassPointer j9class) throws CorruptDataException {
        if (J9ClassHelper.isArrayClass(j9class)) {
            J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(j9class);
            UDATA modifiers = arrayClass.leafComponentType().romClass().modifiers();
            modifiers = modifiers.bitOr(J9JavaAccessFlags.J9AccAbstract);
            modifiers = modifiers.bitOr(J9JavaAccessFlags.J9AccFinal);
            return modifiers.intValue();
        }
        UDATA modifiers = j9class.romClass().modifiers();
        if (j9class.romClass().outerClassName().notNull()) {
            modifiers = j9class.romClass().memberAccessFlags();
        }
        return modifiers.intValue();
    }

    public static UDATA classDepthAndFlags(J9ClassPointer j9class) throws CorruptDataException {
        return j9class.classDepthAndFlags();
    }

    public static UDATA classDepth(J9ClassPointer j9class) throws CorruptDataException {
        return J9ClassHelper.classDepthAndFlags(j9class).bitAnd(J9JavaAccessFlags.J9AccClassDepthMask);
    }

    public static U32 extendedClassFlags(J9ClassPointer j9class) throws CorruptDataException {
        return new U32(j9class.classFlags());
    }

    public static UDATA classFlags(J9ClassPointer j9class) throws CorruptDataException {
        return J9ClassHelper.classDepthAndFlags(j9class);
    }

    public static boolean isObsolete(J9ClassPointer j9class) throws CorruptDataException {
        return J9ClassHelper.classDepthAndFlags(j9class).allBitsIn(J9JavaAccessFlags.J9AccClassHotSwappedOut);
    }

    public static J9ClassPointer currentClass(J9ClassPointer j9class) throws CorruptDataException {
        return J9ClassHelper.isObsolete(j9class) ? j9class.arrayClass() : j9class;
    }

    public static J9MethodPointer getMethodFromPCAndClass(J9ClassPointer localClass, U8Pointer pc) throws CorruptDataException {
        J9ROMClassPointer localROMClass = localClass.romClass();
        int i = 0;
        while ((long)i < localROMClass.romMethodCount().longValue()) {
            J9MethodPointer localMethod = localClass.ramMethods().add(i);
            J9ROMMethodPointer romMethod = J9MethodHelper.romMethod(localMethod);
            boolean a = pc.gte(U8Pointer.cast(romMethod));
            boolean b = pc.lte(J9ROMMethodHelper.bytecodeEnd(romMethod).subOffset(1L));
            if (a && b) {
                return localMethod;
            }
            ++i;
        }
        return J9MethodPointer.NULL;
    }

    public static boolean isSwappedOut(J9ClassPointer clazz) throws CorruptDataException {
        return J9ClassHelper.classDepthAndFlags(clazz).allBitsIn(J9JavaAccessFlags.J9AccClassHotSwappedOut);
    }

    public static boolean hasValidEyeCatcher(J9ClassPointer clazz) throws CorruptDataException {
        return clazz.eyecatcher().eq(0x99669966L);
    }

    public static boolean areExtensionsEnabled() throws CorruptDataException {
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (vm.runtimeFlags().allBitsIn(J9Consts.J9_RUNTIME_XFUTURE)) {
            return false;
        }
        if (J9BuildFlags.J9VM_INTERP_NATIVE_SUPPORT) {
            if (J9BuildFlags.J9VM_JIT_FULL_SPEED_DEBUG) {
                if (vm.jitConfig().notNull()) {
                    return !vm.jitConfig().fsdEnabled().eq(0L);
                }
                return true;
            }
            if (vm.jitConfig().notNull()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isAnonymousClass(J9ClassPointer clazz) throws CorruptDataException {
        return J9ROMClassHelper.isAnonymousClass(clazz.romClass());
    }

    public static boolean isRefOrValSignature(char firstChar) {
        return firstChar == 'L' || firstChar == 'Q';
    }

    static {
        TYPE_MAP.put("void", Character.valueOf('V'));
        TYPE_MAP.put("boolean", Character.valueOf('Z'));
        TYPE_MAP.put("byte", Character.valueOf('B'));
        TYPE_MAP.put("char", Character.valueOf('C'));
        TYPE_MAP.put("short", Character.valueOf('S'));
        TYPE_MAP.put("int", Character.valueOf('I'));
        TYPE_MAP.put("long", Character.valueOf('J'));
        TYPE_MAP.put("float", Character.valueOf('F'));
        TYPE_MAP.put("double", Character.valueOf('D'));
    }
}

