/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.OptInfo;
import com.ibm.j9ddr.vm29.j9.walkers.LocalVariableTable;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.structure.J9NonbuilderConstants;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U8;
import java.util.Iterator;

public abstract class LocalVariableTableIterator
implements Iterator<LocalVariableTable> {
    public static void checkVariableTableVersion() throws CorruptDataException {
        int version = AlgorithmVersion.getVersionOf("VM_LOCAL_VARIABLE_TABLE_VERSION").getAlgorithmVersion();
        if (version < 1) {
            throw new CorruptDataException("Unexpected local variable table version " + version);
        }
    }

    public static LocalVariableTableIterator localVariableTableIteratorFor(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        LocalVariableTableIterator.checkVariableTableVersion();
        return new LocalVariableTableIterator_V1(methodInfo);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public abstract U8Pointer getLocalVariableTablePtr();

    private static class LocalVariableTableIterator_V1
    extends LocalVariableTableIterator {
        private J9MethodDebugInfoPointer methodInfo;
        private U32 count = new U32(0L);
        private U8Pointer localVariableTablePtr;
        private U32 slotNumber = new U32(0L);
        private U32 startVisibility = new U32(0L);
        private U32 visibilityLength = new U32(0L);

        public LocalVariableTableIterator_V1(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
            this.methodInfo = methodInfo;
            this.localVariableTablePtr = OptInfo.getV1VariableTableForMethodDebugInfo(methodInfo);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.count.lt(this.methodInfo.varInfoCount());
            }
            catch (CorruptDataException e) {
                return false;
            }
        }

        @Override
        public LocalVariableTable next() {
            J9UTF8Pointer genericSignature;
            SelfRelativePointer genericSignatureSrp;
            J9UTF8Pointer signature;
            SelfRelativePointer signatureSrp;
            J9UTF8Pointer name;
            SelfRelativePointer nameSrp;
            this.count = this.count.add(1);
            try {
                U8 firstByte = this.localVariableTablePtr.at(0L);
                if (firstByte.bitAnd(128).eq(0L)) {
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                    this.slotNumber = this.slotNumber.add(firstByte.rightShift(6));
                    this.visibilityLength = this.visibilityLength.add(LocalVariableTableIterator_V1.signExtend(new I32(firstByte.bitAnd(63)), 6));
                } else if (firstByte.bitAnd(192).eq(128L)) {
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                    this.slotNumber = this.slotNumber.add(firstByte.rightShift(5).bitAnd(1));
                    this.startVisibility = this.startVisibility.add(LocalVariableTableIterator_V1.signExtend(new I32(firstByte.bitAnd(31)), 5));
                    this.visibilityLength = this.visibilityLength.add(LocalVariableTableIterator_V1.signExtend(new I32(this.localVariableTablePtr.at(0L)), 8));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                } else if (firstByte.bitAnd(224).eq(192L)) {
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                    this.slotNumber = this.slotNumber.add(firstByte.rightShift(4).bitAnd(1));
                    U32 result = new U32(firstByte).leftShift(16);
                    result = result.bitOr(U16Pointer.cast(this.localVariableTablePtr).at(0L));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(2L);
                    this.startVisibility = this.startVisibility.add(LocalVariableTableIterator_V1.signExtend(new I32(result.rightShift(11).bitAnd(511)), 9));
                    this.visibilityLength = this.visibilityLength.add(LocalVariableTableIterator_V1.signExtend(new I32(result.bitAnd(2047)), 11));
                } else if (firstByte.bitAnd(240).eq(224L)) {
                    U32 result = new U32(firstByte);
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                    this.slotNumber = this.slotNumber.add(result.rightShift(2).bitAnd(3));
                    U32 visibilityLengthUnsigned = result.bitAnd(3).leftShift(16);
                    visibilityLengthUnsigned = visibilityLengthUnsigned.bitOr(U16Pointer.cast(this.localVariableTablePtr).at(0L));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(2L);
                    this.visibilityLength = this.visibilityLength.add(LocalVariableTableIterator_V1.signExtend(new I32(visibilityLengthUnsigned), 18));
                    this.startVisibility = this.startVisibility.add(LocalVariableTableIterator_V1.signExtend(new I32(U16Pointer.cast(this.localVariableTablePtr).at(0L)), 16));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(2L);
                } else if (firstByte.eq(240L)) {
                    this.localVariableTablePtr = this.localVariableTablePtr.add(1L);
                    this.slotNumber = this.slotNumber.add(I32Pointer.cast(this.localVariableTablePtr).at(0L));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                    this.startVisibility = this.startVisibility.add(I32Pointer.cast(this.localVariableTablePtr).at(0L));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                    this.visibilityLength = this.visibilityLength.add(I32Pointer.cast(this.localVariableTablePtr).at(0L));
                    this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                } else {
                    return null;
                }
                nameSrp = SelfRelativePointer.cast(this.localVariableTablePtr);
                name = J9UTF8Pointer.cast(nameSrp.get());
                this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                signatureSrp = SelfRelativePointer.cast(this.localVariableTablePtr);
                signature = J9UTF8Pointer.cast(signatureSrp.get());
                this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                if (this.visibilityLength.anyBitsIn(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_VARIABLE_TABLE_HAS_GENERIC)) {
                    genericSignatureSrp = SelfRelativePointer.cast(this.localVariableTablePtr);
                    genericSignature = J9UTF8Pointer.cast(genericSignatureSrp.get());
                    this.localVariableTablePtr = this.localVariableTablePtr.add(4L);
                } else {
                    genericSignatureSrp = SelfRelativePointer.NULL;
                    genericSignature = J9UTF8Pointer.NULL;
                }
                this.visibilityLength = this.visibilityLength.bitAnd(J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_VARIABLE_TABLE_HAS_GENERIC ^ 0xFFFFFFFFFFFFFFFFL);
            }
            catch (CorruptDataException ex) {
                EventManager.raiseCorruptDataEvent("CorruptData encountered walking local variable table.", ex, false);
                return null;
            }
            return new LocalVariableTable(this.slotNumber, this.startVisibility, this.visibilityLength, genericSignatureSrp, genericSignature, nameSrp, name, signatureSrp, signature);
        }

        private static I32 signExtend(I32 i32, int numberBits) {
            int shiftAmount = 32 - numberBits;
            return i32.leftShift(shiftAmount).rightShift(shiftAmount);
        }

        @Override
        public U8Pointer getLocalVariableTablePtr() {
            return this.localVariableTablePtr;
        }
    }
}

