/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.walkers.MemorySegmentIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassSegmentIterator
implements Iterator {
    private static final AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_POOL_VERSION");
    private final Logger log = Logger.getLogger("j9ddr.walkers");
    private final Iterator segments;
    private J9MemorySegmentPointer segment;
    private boolean EOS = false;
    private boolean hasNextClass = false;
    private J9ClassPointer clazzPtr = J9ClassPointer.NULL;

    public ClassSegmentIterator(J9MemorySegmentListPointer source) throws CorruptDataException {
        this.segments = new MemorySegmentIterator(source.nextSegment(), 65536, false);
        this.EOS = !this.segments.hasNext();
    }

    public ClassSegmentIterator(J9MemorySegmentPointer source) throws CorruptDataException {
        this.segments = new MemorySegmentIterator(source, 65536, true);
        this.EOS = !this.segments.hasNext();
    }

    @Override
    public boolean hasNext() {
        if (this.hasNextClass) {
            return true;
        }
        if (this.EOS) {
            return false;
        }
        while (!this.hasNextClass) {
            try {
                if (this.clazzPtr.notNull()) {
                    this.clazzPtr = this.clazzPtr.nextClassInSegment();
                }
                while (this.clazzPtr.isNull()) {
                    boolean bl = this.EOS = !this.segments.hasNext();
                    if (this.EOS) {
                        return false;
                    }
                    this.segment = (J9MemorySegmentPointer)this.segments.next();
                    this.clazzPtr = J9ClassPointer.cast(PointerPointer.cast(this.segment.heapBase()).at(0L));
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(String.format("Class found : SEG=0x%016x : PTR=0x%016x", this.segment.getAddress(), this.clazzPtr.getAddress()));
                }
                this.hasNextClass = true;
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Problem locating the next class", e, false);
                this.EOS = this.segments.hasNext();
                if (this.EOS) {
                    return false;
                }
                this.clazzPtr = J9ClassPointer.NULL;
            }
        }
        return this.hasNextClass;
    }

    public Object next() {
        if (this.hasNext()) {
            this.hasNextClass = false;
            return this.clazzPtr;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator is read only");
    }
}

