/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.gc.GCArrayletObjectModel_V1;
import com.ibm.j9ddr.vm29.j9.gc.GCArrayletObjectModel_V2;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

abstract class GCArrayObjectModel
extends GCBase {
    GCArrayObjectModel() {
    }

    public static GCArrayObjectModel from() throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_ARRAYLET_OBJECT_MODEL_VERSION");
        switch (version.getAlgorithmVersion()) {
            case 0: 
            case 1: {
                return new GCArrayletObjectModel_V1();
            }
        }
        return new GCArrayletObjectModel_V2();
    }

    public abstract UDATA getSizeInBytesWithHeader(J9IndexableObjectPointer var1) throws CorruptDataException;

    public UDATA getSizeInSlotsWithHeader(J9IndexableObjectPointer array) throws CorruptDataException {
        return UDATA.convertBytesToSlots(this.getSizeInBytesWithHeader(array));
    }

    public UDATA getSizeInElements(J9IndexableObjectPointer array) throws CorruptDataException {
        U32 size = J9IndexableObjectHelper.size(array);
        if (size.anyBitsIn(Integer.MIN_VALUE)) {
            throw new CorruptDataException("java array size with sign bit set");
        }
        return new UDATA(size);
    }

    public abstract UDATA getHashcodeOffset(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getHeaderSize(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getDataSizeInBytes(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract VoidPointer getElementAddress(J9IndexableObjectPointer var1, int var2, int var3) throws CorruptDataException;

    public abstract VoidPointer getDataPointerForContiguous(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract ObjectReferencePointer getArrayoidPointer(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract boolean isInlineContiguousArraylet(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getTotalFootprintInBytesWithHeader(J9IndexableObjectPointer var1) throws CorruptDataException;
}

