/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm29.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm29.j9.IAlgorithm;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.walkers.LineNumber;
import com.ibm.j9ddr.vm29.j9.walkers.LineNumberIterator;
import com.ibm.j9ddr.vm29.j9.walkers.LocalVariableTableIterator;
import com.ibm.j9ddr.vm29.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9EnclosingObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SourceDebugExtensionPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MethodDebugInfoHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9MethodDebugInfo;
import com.ibm.j9ddr.vm29.structure.J9NonbuilderConstants;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.LinkedList;

public class OptInfo {
    private static IOptInfoImpl impl;
    private static final AlgorithmPicker<IOptInfoImpl> picker;

    private static IOptInfoImpl getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    public static int getLineNumberForROMClass(J9MethodPointer method, UDATA relativePC) throws CorruptDataException {
        return OptInfo.getImpl().getLineNumberForROMClass(method, relativePC);
    }

    public static J9MethodDebugInfoPointer getMethodDebugInfoForROMClass(J9MethodPointer method) throws CorruptDataException {
        return ROMHelp.getMethodDebugInfoFromROMMethod(ROMHelp.getOriginalROMMethod(method));
    }

    private static SelfRelativePointer getSRPPtr(U32Pointer ptr, UDATA flags, long option) {
        if (!flags.anyBitsIn(option) || ptr.isNull()) {
            return SelfRelativePointer.NULL;
        }
        return SelfRelativePointer.cast(ptr.add(OptInfo.countBits(OptInfo.COUNT_MASK(new U32(flags), option)) - 1));
    }

    public static int countBits(U32 word) {
        return Long.bitCount(word.longValue());
    }

    public static U8Pointer getV1VariableTableForMethodDebugInfo(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        LocalVariableTableIterator.checkVariableTableVersion();
        return U8Pointer.cast(OptInfo._getVariableTableForMethodDebugInfo(methodInfo));
    }

    private static VoidPointer _getVariableTableForMethodDebugInfo(J9MethodDebugInfoPointer methodInfo) throws CorruptDataException {
        if (!methodInfo.varInfoCount().eq(0L)) {
            U32 taggedSizeOrSRP = U32Pointer.cast(methodInfo).at(0L);
            if (taggedSizeOrSRP.allBitsIn(1L)) {
                U32 lineNumberTableSize = J9MethodDebugInfoHelper.getLineNumberCompressedSize(methodInfo);
                return VoidPointer.cast(U8Pointer.cast(methodInfo).addOffset(J9MethodDebugInfo.SIZEOF).addOffset(lineNumberTableSize));
            }
            return VoidPointer.cast(methodInfo.srpToVarInfo());
        }
        return VoidPointer.NULL;
    }

    public static U32 COUNT_MASK(U32 value, long mask) {
        return value.bitAnd((mask << 1) - 1L);
    }

    public static String getSourceFileNameForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        return OptInfo.getOption(romClass, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_SOURCE_FILE_NAME);
    }

    public static String getSimpleNameForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        return OptInfo.getOption(romClass, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_SIMPLE_NAME);
    }

    public static U32Pointer getClassAnnotationsDataForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        VoidPointer structure = OptInfo.getStructure(romClass, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_CLASS_ANNOTATION_INFO);
        return U32Pointer.cast(structure);
    }

    public static U32Pointer getClassTypeAnnotationsDataForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        VoidPointer structure = OptInfo.getStructure(romClass, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_TYPE_ANNOTATION_INFO);
        return U32Pointer.cast(structure);
    }

    public static String getGenericSignatureForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        return OptInfo.getOption(romClass, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_GENERIC_SIGNATURE);
    }

    public static J9EnclosingObjectPointer getEnclosingMethodForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        VoidPointer structure = OptInfo.getStructure(romClass, J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_ENCLOSING_METHOD);
        if (!structure.isNull()) {
            return J9EnclosingObjectPointer.cast(structure);
        }
        return J9EnclosingObjectPointer.NULL;
    }

    private static String getOption(J9ROMClassPointer romClass, long option) throws CorruptDataException {
        VoidPointer structure = OptInfo.getStructure(romClass, option);
        if (structure != VoidPointer.NULL) {
            return J9UTF8Helper.stringValue(J9UTF8Pointer.cast(structure));
        }
        return null;
    }

    private static VoidPointer getStructure(J9ROMClassPointer romClass, long option) throws CorruptDataException {
        SelfRelativePointer ptr = OptInfo.getSRPPtr(J9ROMClassHelper.optionalInfo(romClass), romClass.optionalFlags(), option);
        if (!ptr.isNull()) {
            return VoidPointer.cast(ptr.get());
        }
        return VoidPointer.NULL;
    }

    public static J9SourceDebugExtensionPointer getSourceDebugExtensionForROMClass(J9ROMClassPointer romClass) throws CorruptDataException {
        SelfRelativePointer srpPtr = OptInfo.getSRPPtr(J9ROMClassHelper.optionalInfo(romClass), romClass.optionalFlags(), J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_SOURCE_DEBUG_EXTENSION);
        if (!srpPtr.isNull()) {
            return J9SourceDebugExtensionPointer.cast(srpPtr.get());
        }
        return J9SourceDebugExtensionPointer.NULL;
    }

    private static U32Pointer getPermittedSubclassPointer(J9ROMClassPointer romClass) throws CorruptDataException {
        SelfRelativePointer srpPtr = OptInfo.getSRPPtr(J9ROMClassHelper.optionalInfo(romClass), romClass.optionalFlags(), J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_PERMITTEDSUBCLASSES_ATTRIBUTE);
        if (srpPtr.notNull()) {
            return U32Pointer.cast(srpPtr.get());
        }
        return U32Pointer.NULL;
    }

    public static int getPermittedSubclassCount(J9ROMClassPointer romClass) throws CorruptDataException {
        U32Pointer permittedSubclassPointer = OptInfo.getPermittedSubclassPointer(romClass);
        if (permittedSubclassPointer.notNull()) {
            return permittedSubclassPointer.at(0L).intValue();
        }
        return 0;
    }

    public static J9UTF8Pointer getPermittedSubclassNameAtIndex(J9ROMClassPointer romClass, int index) throws CorruptDataException {
        U32Pointer permittedSubclassPointer = OptInfo.getPermittedSubclassPointer(romClass);
        if (permittedSubclassPointer.notNull()) {
            permittedSubclassPointer = permittedSubclassPointer.add(index + 1);
            SelfRelativePointer nameSrp = SelfRelativePointer.cast(permittedSubclassPointer);
            return J9UTF8Pointer.cast(nameSrp.get());
        }
        return J9UTF8Pointer.NULL;
    }

    public static int getPreloadClassCount(J9ROMClassPointer romClass) throws CorruptDataException {
        U32Pointer preloadClassInfoPointer = OptInfo.getPreloadClassInfoPointer(romClass);
        if (preloadClassInfoPointer.notNull()) {
            return preloadClassInfoPointer.at(0L).intValue();
        }
        return 0;
    }

    private static U32Pointer getPreloadClassInfoPointer(J9ROMClassPointer romClass) throws CorruptDataException {
        SelfRelativePointer srpPtr = OptInfo.getSRPPtr(J9ROMClassHelper.optionalInfo(romClass), romClass.optionalFlags(), J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_PRELOAD_ATTRIBUTE);
        if (srpPtr.notNull()) {
            return U32Pointer.cast(srpPtr.get());
        }
        return U32Pointer.NULL;
    }

    public static J9UTF8Pointer getPreloadClassNameAtIndex(J9ROMClassPointer romClass, int index) throws CorruptDataException {
        U32Pointer preloadClassInfoPointer = OptInfo.getPreloadClassInfoPointer(romClass);
        if (preloadClassInfoPointer.notNull()) {
            SelfRelativePointer nameSrp = SelfRelativePointer.cast(preloadClassInfoPointer.add(index + 1));
            return J9UTF8Pointer.cast(nameSrp.get());
        }
        return J9UTF8Pointer.NULL;
    }

    public static U32 getImplicitCreationFlags(J9ROMClassPointer romClass) throws CorruptDataException {
        SelfRelativePointer srpPtr = OptInfo.getSRPPtr(J9ROMClassHelper.optionalInfo(romClass), romClass.optionalFlags(), J9NonbuilderConstants.J9_ROMCLASS_OPTINFO_IMPLICITCREATION_ATTRIBUTE);
        if (srpPtr.notNull()) {
            U32Pointer u32Ptr = U32Pointer.cast(srpPtr.get());
            return u32Ptr.at(0L);
        }
        return U32.MIN;
    }

    static {
        picker = new AlgorithmPicker<IOptInfoImpl>("OPT_INFO_VERSION"){

            @Override
            protected Iterable<? extends IOptInfoImpl> allAlgorithms() {
                LinkedList<OptInfo_29_V0> list = new LinkedList<OptInfo_29_V0>();
                list.add(new OptInfo_29_V0());
                return list;
            }
        };
    }

    private static class OptInfo_29_V0
    extends BaseAlgorithm
    implements IOptInfoImpl {
        protected OptInfo_29_V0() {
            super(90, 0);
        }

        @Override
        public int getLineNumberForROMClass(J9MethodPointer method, UDATA relativePC) throws CorruptDataException {
            J9MethodDebugInfoPointer methodInfo;
            UDATA bytecodeSize = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(method));
            int number = -1;
            if ((relativePC.lt(bytecodeSize) || bytecodeSize.eq(0L)) && (methodInfo = OptInfo.getMethodDebugInfoForROMClass(method)).notNull()) {
                LineNumber lineNumber;
                LineNumberIterator lineNumberIterator = LineNumberIterator.lineNumberIteratorFor(methodInfo);
                while (lineNumberIterator.hasNext() && !relativePC.lt((lineNumber = (LineNumber)lineNumberIterator.next()).getLocation())) {
                    number = lineNumber.getLineNumber().intValue();
                }
            }
            return number;
        }
    }

    private static interface IOptInfoImpl
    extends IAlgorithm {
        public int getLineNumberForROMClass(J9MethodPointer var1, UDATA var2) throws CorruptDataException;
    }
}

