/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm28.pointer.AbstractPointer;
import com.ibm.j9ddr.vm28.pointer.I16Pointer;
import com.ibm.j9ddr.vm28.pointer.I32Pointer;
import com.ibm.j9ddr.vm28.pointer.I64Pointer;
import com.ibm.j9ddr.vm28.pointer.I8Pointer;
import com.ibm.j9ddr.vm28.pointer.IDATAPointer;
import com.ibm.j9ddr.vm28.pointer.PointerPointer;
import com.ibm.j9ddr.vm28.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm28.pointer.StructurePointer;
import com.ibm.j9ddr.vm28.pointer.U16Pointer;
import com.ibm.j9ddr.vm28.pointer.U32Pointer;
import com.ibm.j9ddr.vm28.pointer.U64Pointer;
import com.ibm.j9ddr.vm28.pointer.U8Pointer;
import com.ibm.j9ddr.vm28.pointer.UDATAPointer;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.WideSelfRelativePointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm28.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm28.structure.J9UTF8;
import com.ibm.j9ddr.vm28.tools.ddrinteractive.ClassWalker;
import com.ibm.j9ddr.vm28.tools.ddrinteractive.IClassWalkCallbacks;
import com.ibm.j9ddr.vm28.types.UDATA;
import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class LinearDumper
implements IClassWalkCallbacks {
    private List<J9ClassRegion> classRegions = new LinkedList<J9ClassRegion>();
    private long firstJ9_ROM_UTF8 = Long.MAX_VALUE;
    private long lastJ9_ROM_UTF8 = Long.MIN_VALUE;

    @Override
    public void addSlot(StructurePointer clazz, IClassWalkCallbacks.SlotType type2, AbstractPointer slotPtr, String slotName) throws CorruptDataException {
        this.addSlot(clazz, type2, slotPtr, slotName, "");
    }

    @Override
    public void addSlot(StructurePointer clazz, IClassWalkCallbacks.SlotType type2, AbstractPointer slotPtr, String slotName, String additionalInfo) throws CorruptDataException {
        try {
            switch (type2) {
                case J9_ROM_UTF8: {
                    long offset = slotPtr.getAddress() - clazz.getAddress();
                    this.classRegions.add(new J9ClassRegion(slotPtr, IClassWalkCallbacks.SlotType.J9_SRP_TO_STRING, slotName, additionalInfo, type2.getSize(), offset, true));
                    VoidPointer srp = SelfRelativePointer.cast(slotPtr).get();
                    this.addUTF8Region(clazz, slotName, additionalInfo, srp);
                    break;
                }
                case J9_UTF8: {
                    this.addUTF8Region(clazz, slotName, additionalInfo, slotPtr);
                    break;
                }
                case J9_SRPNAS: {
                    J9ROMNameAndSignaturePointer nas = J9ROMNameAndSignaturePointer.cast(SelfRelativePointer.cast(slotPtr).get());
                    if (nas.notNull()) {
                        this.addSlot(clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, nas.nameEA(), "name");
                        this.addSlot(clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, nas.signatureEA(), "signature");
                    }
                    this.addSlot(clazz, IClassWalkCallbacks.SlotType.J9_SRP, slotPtr, "cpFieldNAS");
                    break;
                }
                case J9_NAS: {
                    J9ROMNameAndSignaturePointer nas = J9ROMNameAndSignaturePointer.cast(slotPtr);
                    this.addSlot(clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, nas.nameEA(), "name");
                    this.addSlot(clazz, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, nas.signatureEA(), "signature");
                    break;
                }
                case J9_IntermediateClassData: {
                    long offset = slotPtr.getAddress() - clazz.getAddress();
                    this.classRegions.add(new J9ClassRegion(slotPtr, type2, slotName, additionalInfo, ((J9ROMClassPointer)clazz).intermediateClassDataLength().longValue(), offset, true));
                    break;
                }
                default: {
                    long offset = slotPtr.getAddress() - clazz.getAddress();
                    this.classRegions.add(new J9ClassRegion(slotPtr, type2, slotName, additionalInfo, type2.getSize(), offset, true));
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addUTF8Region(StructurePointer clazz, String slotName, String additionalInfo, AbstractPointer utf8String) throws CorruptDataException {
        long offset = utf8String.getAddress() - clazz.getAddress();
        long clazzSize = ((J9ROMClassPointer)clazz).romSize().longValue();
        if (offset > 0L && offset < clazzSize && utf8String.notNull()) {
            long UTF8Length = this.getUTF8Length(J9UTF8Pointer.cast(utf8String));
            if (utf8String.getAddress() < this.firstJ9_ROM_UTF8) {
                this.firstJ9_ROM_UTF8 = utf8String.getAddress();
            }
            if (utf8String.getAddress() + UTF8Length > this.lastJ9_ROM_UTF8) {
                this.lastJ9_ROM_UTF8 = utf8String.getAddress() + UTF8Length;
            }
            this.classRegions.add(new J9ClassRegion(utf8String, IClassWalkCallbacks.SlotType.J9_ROM_UTF8, slotName, additionalInfo, UTF8Length, offset, true));
        }
    }

    public void addRegion(StructurePointer clazz, IClassWalkCallbacks.SlotType type2, AbstractPointer slotPtr, String slotName, long length, boolean computePadding) throws CorruptDataException {
        this.classRegions.add(new J9ClassRegion(slotPtr, type2, slotName, "", length, slotPtr.getAddress() - clazz.getAddress(), computePadding));
    }

    @Override
    public void addSection(StructurePointer clazz, AbstractPointer address, long length, String name, boolean computePadding) throws CorruptDataException {
        if (0L != length) {
            this.addRegion(clazz, IClassWalkCallbacks.SlotType.J9_SECTION_START, address, name, length, computePadding);
            this.addRegion(clazz, IClassWalkCallbacks.SlotType.J9_SECTION_END, address.addOffset(length), name, length, computePadding);
        }
    }

    public J9ClassRegionNode getAllRegions(ClassWalker classWalker) throws CorruptDataException {
        classWalker.allSlotsInObjectDo(this);
        StructurePointer clazz = classWalker.getClazz();
        if (this.firstJ9_ROM_UTF8 != Long.MAX_VALUE) {
            this.addSection(clazz, PointerPointer.cast(this.firstJ9_ROM_UTF8), this.lastJ9_ROM_UTF8 - this.firstJ9_ROM_UTF8, "UTF8", true);
        }
        this.groupSectionByName(clazz, "methodDebugInfo", false);
        this.groupSectionByName(clazz, "variableInfo", false);
        AbstractPointer offset = PointerPointer.NULL;
        J9ClassRegionNode currentNode = new J9ClassRegionNode(null);
        Stack<J9ClassRegionNode> parentStack = new Stack<J9ClassRegionNode>();
        J9ClassRegion previousRegion = null;
        Collections.sort(this.classRegions);
        for (J9ClassRegion region : this.classRegions) {
            if (this.isSameRegion(previousRegion, region)) {
                previousRegion = region;
                continue;
            }
            previousRegion = region;
            if (IClassWalkCallbacks.SlotType.J9_SECTION_START == region.getType()) {
                if (region.getComputePadding() && offset.notNull() && !offset.eq(region.getSlotPtr())) {
                    currentNode.addChild(new J9ClassRegionNode(new J9ClassRegion(offset, IClassWalkCallbacks.SlotType.J9_Padding, "Padding", "", region.getSlotPtr().getAddress() - offset.getAddress(), 0L, true)));
                }
                if (region.getComputePadding()) {
                    offset = region.getSlotPtr();
                }
                parentStack.push(currentNode);
                J9ClassRegionNode newChild = new J9ClassRegionNode(region);
                currentNode.addChild(newChild);
                currentNode = newChild;
                continue;
            }
            if (IClassWalkCallbacks.SlotType.J9_SECTION_END == region.getType()) {
                if (region.getComputePadding()) {
                    long paddingSize = region.getSlotPtr().getAddress() - offset.getAddress();
                    if (paddingSize != 0L) {
                        currentNode.addChild(new J9ClassRegionNode(new J9ClassRegion(offset, IClassWalkCallbacks.SlotType.J9_Padding, "Padding", "", paddingSize, 0L, true)));
                    }
                    offset = region.getSlotPtr();
                }
                currentNode = (J9ClassRegionNode)parentStack.pop();
                continue;
            }
            boolean computePadding = false;
            if (currentNode.getNodeValue() != null) {
                computePadding = currentNode.getNodeValue().getComputePadding();
            }
            if (computePadding && offset.notNull() && !offset.eq(region.getSlotPtr())) {
                currentNode.addChild(new J9ClassRegionNode(new J9ClassRegion(offset, IClassWalkCallbacks.SlotType.J9_Padding, "Padding", "", region.getSlotPtr().getAddress() - offset.getAddress(), 0L, true)));
            }
            if (computePadding) {
                offset = region.getSlotPtr().addOffset(region.length);
            }
            currentNode.addChild(new J9ClassRegionNode(region));
        }
        if (clazz instanceof J9ROMClassPointer) {
            long size = J9ROMClassPointer.cast(clazz).romSize().longValue();
            long paddingSize = clazz.longValue() + size - offset.longValue();
            if (paddingSize != 0L) {
                currentNode.addChild(new J9ClassRegionNode(new J9ClassRegion(offset, IClassWalkCallbacks.SlotType.J9_Padding, "Padding", "", paddingSize, 0L, true)));
                Collections.sort(currentNode.getChildren());
            }
        }
        return currentNode;
    }

    private void groupSectionByName(StructurePointer clazz, String name, boolean computePadding) throws CorruptDataException {
        AbstractPointer firstMethodDebugInfo = null;
        AbstractPointer lastMethodDebugInfo = null;
        for (J9ClassRegion region : this.classRegions) {
            if (IClassWalkCallbacks.SlotType.J9_SECTION_START != region.getType() || !region.getName().equals(name)) continue;
            if (firstMethodDebugInfo == null || region.getSlotPtr().lt(firstMethodDebugInfo)) {
                firstMethodDebugInfo = region.getSlotPtr();
            }
            if (lastMethodDebugInfo != null && !region.getSlotPtr().add(region.getLength()).gt(lastMethodDebugInfo)) continue;
            lastMethodDebugInfo = region.getSlotPtr().addOffset(region.getLength());
        }
        if (firstMethodDebugInfo != null && lastMethodDebugInfo != null) {
            UDATA length = UDATA.cast(lastMethodDebugInfo).sub(UDATA.cast(firstMethodDebugInfo));
            this.addSection(clazz, PointerPointer.cast(firstMethodDebugInfo), length.longValue(), name + "s", computePadding);
        }
    }

    public void gatherLayoutInfo(PrintStream out, ClassWalker classWalker, long nestingThreshold) throws CorruptDataException {
        J9ClassRegionNode allRegionsNode = this.getAllRegions(classWalker);
        LinearDumper.printAllRegions(out, classWalker.getClazz(), nestingThreshold, allRegionsNode, 0);
    }

    public static void printAllRegions(PrintStream out, StructurePointer clazz, long nestingThreshold, J9ClassRegionNode regionNode, int nesting) throws CorruptDataException {
        Object str;
        J9ClassRegion region = regionNode.getNodeValue();
        if ((long)nesting == nestingThreshold || regionNode.getChildren().size() == 0) {
            LinearDumper.printRegionLine(region, out);
            return;
        }
        if ((long)nesting > nestingThreshold) {
            return;
        }
        if (region != null) {
            str = String.format("Section Start: %s (%d bytes)", region.getName(), region.getLength());
            out.println();
            out.println(String.format("=== %-85s ===", str));
        }
        for (J9ClassRegionNode classRegionNode : regionNode.getChildren()) {
            LinearDumper.printAllRegions(out, clazz, nestingThreshold, classRegionNode, nesting + 1);
        }
        if (region != null) {
            str = String.format("Section End: %s", region.getName());
            out.println();
            out.println(String.format("=== %-85s ===", str));
        }
    }

    private static void printRegionLine(J9ClassRegion region, PrintStream out) {
        try {
            long end;
            long start;
            if (region.getType() == IClassWalkCallbacks.SlotType.J9_SECTION_START) {
                start = region.getSlotPtr().getAddress();
                end = region.getSlotPtr().getAddress() + region.getLength();
            } else {
                start = region.getSlotPtr().getAddress();
                end = region.getSlotPtr().getAddress() + region.getLength();
            }
            String address = String.format("%s-%s [ %20s %-28s ] %s", UDATAPointer.cast(start).getHexAddress(), UDATAPointer.cast(end).getHexAddress(), LinearDumper.getRegionValueString(region), region.getName(), LinearDumper.getRegionDetailString(region));
            out.println(address);
        }
        catch (CorruptDataException e) {
            out.println(e.getMessage());
        }
    }

    private static Object getRegionDetailString(J9ClassRegion region) throws CorruptDataException {
        String returnValue = "";
        switch (region.getType()) {
            case J9_SECTION_START: {
                returnValue = String.format(" %5d bytes", region.getLength());
                break;
            }
            case J9_RAM_UTF8: {
                UDATAPointer slotPtr = UDATAPointer.cast(region.getSlotPtr());
                if (slotPtr.at(0L).longValue() == 0L) break;
                returnValue = J9ObjectHelper.stringValue(J9ObjectPointer.cast(slotPtr.at(0L)));
                break;
            }
            case J9_ROM_UTF8: 
            case J9_UTF8: {
                returnValue = J9UTF8Helper.stringValue(J9UTF8Pointer.cast(region.getSlotPtr()));
                break;
            }
            case J9_iTableMethod: {
                AbstractPointer classOffset = region.getSlotPtr().subOffset(region.offset);
                long slotAddress = region.getSlotPtr().at(0L).longValue();
                classOffset = classOffset.addOffset(slotAddress);
                returnValue = region.additionalInfo + " " + classOffset.getHexAddress();
                break;
            }
            case J9_SRP: {
                VoidPointer srp = SelfRelativePointer.cast(region.getSlotPtr()).get();
                if (!srp.notNull()) break;
                returnValue = " -> " + srp.getHexAddress();
                break;
            }
            case J9_WSRP: {
                VoidPointer srp = WideSelfRelativePointer.cast(region.getSlotPtr()).get();
                if (!srp.notNull()) break;
                returnValue = " -> " + srp.getHexAddress();
                break;
            }
            case J9_SRP_TO_STRING: {
                VoidPointer srp = SelfRelativePointer.cast(region.getSlotPtr()).get();
                if (!srp.notNull()) break;
                returnValue = " -> " + srp.getHexAddress();
                returnValue = returnValue + " " + J9UTF8Helper.stringValue(J9UTF8Pointer.cast(srp));
                break;
            }
            case J9_Padding: {
                returnValue = region.length + " byte(s)";
                break;
            }
            case J9_IntermediateClassData: {
                returnValue = region.length + " byte(s) " + region.additionalInfo;
                break;
            }
            default: {
                long slotAddress;
                String detail = "";
                long slotAddressOriginal = slotAddress = region.getSlotPtr().at(0L).longValue();
                if (null != region.additionalInfo && region.additionalInfo.length() != 0) {
                    if ("classAndFlags".equals(region.name) && UDATA.MASK != slotAddress) {
                        slotAddress &= J9JavaAccessFlags.J9StaticFieldRefFlagBits ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    detail = detail + region.additionalInfo + String.format(" 0x%08X", slotAddress);
                    if (0L != slotAddress && region.additionalInfo.equals("!j9class")) {
                        try {
                            detail = detail + " - " + J9UTF8Helper.stringValue(J9ClassPointer.cast(slotAddress).romClass().className());
                            if ("classAndFlags".equals(region.name)) {
                                String flags = "";
                                if (0L != (J9JavaAccessFlags.J9StaticFieldRefBaseType & slotAddressOriginal)) {
                                    flags = flags + "J9StaticFieldRefBaseType, ";
                                }
                                if (0L != (J9JavaAccessFlags.J9StaticFieldRefDouble & slotAddressOriginal)) {
                                    flags = flags + "J9StaticFieldRefDouble, ";
                                }
                                if (0L != (J9JavaAccessFlags.J9StaticFieldRefVolatile & slotAddressOriginal)) {
                                    flags = flags + "J9StaticFieldRefVolatile, ";
                                }
                                if (0 < flags.length()) {
                                    flags = flags.substring(0, flags.length() - 2);
                                    detail = detail + "\t Flag(s) = " + flags;
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                returnValue = detail;
            }
        }
        return returnValue;
    }

    private static String getRegionValueString(J9ClassRegion region) throws CorruptDataException {
        switch (region.getType()) {
            case J9_SECTION_START: {
                return "(SECTION)";
            }
            case J9_ROM_UTF8: 
            case J9_UTF8: 
            case J9_RAM_UTF8: {
                return "UTF8";
            }
            case J9_I8: {
                return I8Pointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_U8: {
                return U8Pointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_I16: {
                return I16Pointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_U16: {
                return U16Pointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_I32: {
                return I32Pointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_U32: {
                return U32Pointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_I64: {
                return I64Pointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_U64: {
                return U64Pointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_SRP: {
                return I32Pointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_WSRP: {
                return IDATAPointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_SRP_TO_STRING: {
                return I32Pointer.cast(region.getSlotPtr()).getHexValue();
            }
            case J9_IntermediateClassData: 
            case J9_Padding: {
                return "";
            }
        }
        return region.getSlotPtr().hexAt(0L);
    }

    private int getUTF8Length(J9UTF8Pointer j9utf8Pointer) throws CorruptDataException {
        UDATA length = new UDATA(j9utf8Pointer.length().longValue() + J9UTF8.SIZEOF - 2L);
        if (length.anyBitsIn(1L)) {
            length = length.add(1L);
        }
        return length.intValue();
    }

    private boolean isSameRegion(J9ClassRegion region1, J9ClassRegion region2) {
        boolean sameRegion;
        if (region1 == null || region2 == null) {
            return false;
        }
        boolean bl = sameRegion = region1.offset == region2.offset && region1.getLength() == region2.getLength();
        if (sameRegion && (IClassWalkCallbacks.SlotType.J9_SECTION_START == region1.getType() || IClassWalkCallbacks.SlotType.J9_SECTION_END == region1.getType())) {
            sameRegion = false;
        }
        return sameRegion;
    }

    public class J9ClassRegionNode
    implements Comparable<J9ClassRegionNode> {
        private J9ClassRegion nodeValue;
        private LinkedList<J9ClassRegionNode> children;

        public J9ClassRegionNode(J9ClassRegion nodeValue) {
            this.nodeValue = nodeValue;
            this.children = new LinkedList();
        }

        public J9ClassRegion getNodeValue() {
            return this.nodeValue;
        }

        public List<J9ClassRegionNode> getChildren() {
            return this.children;
        }

        public void addChild(J9ClassRegionNode child) {
            this.children.addLast(child);
        }

        @Override
        public int compareTo(J9ClassRegionNode region2) {
            if (this.nodeValue.getSlotPtr().lt(region2.nodeValue.getSlotPtr())) {
                return -1;
            }
            if (this.nodeValue.getSlotPtr().gt(region2.nodeValue.getSlotPtr())) {
                return 1;
            }
            return 0;
        }
    }

    public class J9ClassRegion
    implements Comparable<J9ClassRegion> {
        private final AbstractPointer slotPtr;
        private final IClassWalkCallbacks.SlotType type;
        private final String name;
        final String additionalInfo;
        private final long length;
        final long offset;
        private final boolean computePadding;

        public J9ClassRegion(AbstractPointer slotPtr, IClassWalkCallbacks.SlotType type2, String name, String additionalInfo, long length, long offset, boolean computePadding) {
            this.slotPtr = slotPtr;
            this.type = type2;
            this.name = name;
            this.additionalInfo = additionalInfo;
            this.length = length;
            this.offset = offset;
            this.computePadding = computePadding;
        }

        @Override
        public int compareTo(J9ClassRegion region2) {
            int delta = 0;
            J9ClassRegion region1 = this;
            try {
                delta = (int)(region1.getSlotPtr().longValue() - region2.getSlotPtr().longValue());
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
            if (0 != delta) {
                return delta;
            }
            if (IClassWalkCallbacks.SlotType.J9_SECTION_START == region1.getType()) {
                if (IClassWalkCallbacks.SlotType.J9_SECTION_START == region2.getType()) {
                    if (region2.getLength() == region1.getLength()) {
                        return region2.getName().length() - region1.getName().length();
                    }
                    return (int)(region2.getLength() - region1.getLength());
                }
                if (IClassWalkCallbacks.SlotType.J9_SECTION_END == region2.getType()) {
                    return 1;
                }
            } else if (IClassWalkCallbacks.SlotType.J9_SECTION_END == region1.getType()) {
                if (IClassWalkCallbacks.SlotType.J9_SECTION_END == region2.getType()) {
                    if (region2.getLength() == region1.getLength()) {
                        return region1.getName().length() - region2.getName().length();
                    }
                    return (int)(region1.getLength() - region2.getLength());
                }
                if (IClassWalkCallbacks.SlotType.J9_SECTION_START == region2.getType()) {
                    return -1;
                }
            }
            return region2.getType().ordinal() - region1.getType().ordinal();
        }

        public String getName() {
            return this.name;
        }

        public long getLength() {
            return this.length;
        }

        public IClassWalkCallbacks.SlotType getType() {
            return this.type;
        }

        public AbstractPointer getSlotPtr() {
            return this.slotPtr;
        }

        public boolean getComputePadding() {
            return this.computePadding;
        }
    }
}

