/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.StructureCommandUtil;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.IClassWalkCallbacks;
import java.util.HashMap;

public abstract class ClassWalker {
    protected HashMap<String, String> debugExtMap = new HashMap();
    protected StructurePointer clazz;
    protected IClassWalkCallbacks classWalkerCallback;

    public abstract void allSlotsInObjectDo(IClassWalkCallbacks var1) throws CorruptDataException;

    public abstract Context getContext();

    protected void fillDebugExtMap() {
    }

    public StructurePointer getClazz() {
        return this.clazz;
    }

    public IClassWalkCallbacks getClassWalkerCallbacks() {
        return this.classWalkerCallback;
    }

    protected String getDebugExtForMethodName(String methodName) {
        return this.debugExtMap.get(methodName);
    }

    protected void addObjectsAsSlot(StructurePointer methodClass, HashMap<String, String> renameFields) throws CorruptDataException {
        String structureName = methodClass.getClass().getSimpleName().substring(0, methodClass.getClass().getSimpleName().indexOf("Pointer"));
        StructureReader.StructureDescriptor sd = StructureCommandUtil.getStructureDescriptor(structureName, this.getContext());
        if (sd == null) {
            throw new CorruptDataException("Structure \"" + structureName + "\" can not be found.");
        }
        for (StructureReader.FieldDescriptor fd : sd.getFields()) {
            String outName = fd.getName();
            IClassWalkCallbacks.SlotType type2 = this.getTypeByFieldTypeName(fd.getType());
            U8Pointer address = U8Pointer.cast(methodClass).addOffset(fd.getOffset());
            if (null != renameFields && renameFields.containsKey(outName)) {
                outName = renameFields.get(outName);
            }
            this.classWalkerCallback.addSlot(this.clazz, type2, address, outName, this.getDebugExtForMethodName(outName));
        }
    }

    protected void addObjectsasSlot(StructurePointer methodClass) throws CorruptDataException {
        this.addObjectsAsSlot(methodClass, null);
    }

    private IClassWalkCallbacks.SlotType getTypeByFieldTypeName(String fieldTypeName) throws CorruptDataException {
        if (fieldTypeName.startsWith("J9WSRP(")) {
            return IClassWalkCallbacks.SlotType.J9_WSRP;
        }
        if (fieldTypeName.startsWith("J9SRP(struct J9UTF8")) {
            return IClassWalkCallbacks.SlotType.J9_SRP_TO_STRING;
        }
        if (fieldTypeName.startsWith("J9SRP(")) {
            return IClassWalkCallbacks.SlotType.J9_SRP;
        }
        if (fieldTypeName.equals("J9WSRP")) {
            return IClassWalkCallbacks.SlotType.J9_WSRP;
        }
        if (fieldTypeName.equals("J9SRP")) {
            return IClassWalkCallbacks.SlotType.J9_SRP;
        }
        if (fieldTypeName.equals("struct J9UTF8*")) {
            return IClassWalkCallbacks.SlotType.J9_ROM_UTF8;
        }
        if (fieldTypeName.equals("U8")) {
            return IClassWalkCallbacks.SlotType.J9_U8;
        }
        if (fieldTypeName.equals("I8")) {
            return IClassWalkCallbacks.SlotType.J9_I8;
        }
        if (fieldTypeName.equals("U16")) {
            return IClassWalkCallbacks.SlotType.J9_U16;
        }
        if (fieldTypeName.equals("I16")) {
            return IClassWalkCallbacks.SlotType.J9_I16;
        }
        if (fieldTypeName.equals("U32")) {
            return IClassWalkCallbacks.SlotType.J9_U32;
        }
        if (fieldTypeName.equals("I32")) {
            return IClassWalkCallbacks.SlotType.J9_I32;
        }
        if (fieldTypeName.equals("U64")) {
            return IClassWalkCallbacks.SlotType.J9_U64;
        }
        if (fieldTypeName.equals("I64")) {
            return IClassWalkCallbacks.SlotType.J9_I64;
        }
        if (fieldTypeName.equals("UDATA")) {
            return IClassWalkCallbacks.SlotType.J9_UDATA;
        }
        if (fieldTypeName.equals("IDATA")) {
            return IClassWalkCallbacks.SlotType.J9_IDATA;
        }
        if (fieldTypeName.equals("struct J9ROMNameAndSignature")) {
            return IClassWalkCallbacks.SlotType.J9_NAS;
        }
        if (fieldTypeName.endsWith("*")) {
            return IClassWalkCallbacks.SlotType.J9_UDATA;
        }
        throw new CorruptDataException("Field type name is not recognized.");
    }
}

