/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.Pointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.lang.reflect.Field;

public class EnumPointer
extends Pointer {
    public static final EnumPointer NULL = new EnumPointer(0L, VoidPointer.class);
    private Class<?> enumClazz;
    private long enumSize = -1L;

    protected EnumPointer(long address, Class<?> enumClazz) {
        super(address);
        this.enumClazz = enumClazz;
    }

    public static EnumPointer cast(AbstractPointer pointer, Class<?> enumClazz) {
        return EnumPointer.cast(pointer.getAddress(), enumClazz);
    }

    public static EnumPointer cast(UDATA udata, Class<?> enumClazz) {
        return EnumPointer.cast(udata.longValue(), enumClazz);
    }

    public static EnumPointer cast(long address, Class<?> enumClazz) {
        if (address == 0L) {
            return NULL;
        }
        return new EnumPointer(address, enumClazz);
    }

    @Override
    public EnumPointer at(long index) throws CorruptDataException {
        throw new UnsupportedOperationException("Use longAt(long index)");
    }

    @Override
    public EnumPointer at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    @Override
    public long longAt(long index) throws CorruptDataException {
        if (this.sizeOfBaseType() == 1L) {
            return this.getByteAtOffset(index * this.sizeOfBaseType());
        }
        if (this.sizeOfBaseType() == 2L) {
            return this.getShortAtOffset(index * this.sizeOfBaseType());
        }
        if (this.sizeOfBaseType() == 4L) {
            return this.getIntAtOffset(index * this.sizeOfBaseType());
        }
        if (this.sizeOfBaseType() == 8L) {
            return this.getLongAtOffset(index * this.sizeOfBaseType());
        }
        throw new IllegalArgumentException("Unexpected ENUM size in core file");
    }

    @Override
    protected long sizeOfBaseType() {
        if (this.enumSize == -1L) {
            try {
                Field field = this.enumClazz.getField("SIZEOF");
                this.enumSize = field.getLong(null);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return this.enumSize;
    }

    @Override
    public double doubleAt(long index) throws CorruptDataException {
        return this.longAt(index);
    }

    @Override
    public float floatAt(long index) throws CorruptDataException {
        return this.longAt(index);
    }

    @Override
    public EnumPointer add(long count) {
        return new EnumPointer(this.address + this.sizeOfBaseType() * count, this.enumClazz);
    }

    @Override
    public EnumPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public EnumPointer addOffset(long offset) {
        return new EnumPointer(this.address + offset, this.enumClazz);
    }

    @Override
    public EnumPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public EnumPointer sub(long count) {
        return new EnumPointer(this.address - this.sizeOfBaseType() * count, this.enumClazz);
    }

    @Override
    public EnumPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public EnumPointer subOffset(long offset) {
        return new EnumPointer(this.address - offset, this.enumClazz);
    }

    @Override
    public EnumPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public EnumPointer untag() {
        return this.untag(SIZEOF - 1L);
    }

    @Override
    public EnumPointer untag(long mask) {
        return new EnumPointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL), this.enumClazz);
    }
}

