/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm27.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm27.types.UDATA;

public class J9ObjectFieldOffset {
    private final J9ROMFieldShapePointer field;
    private final UDATA offsetOrAddress;
    private final boolean isHidden;

    public J9ObjectFieldOffset(J9ROMFieldShapePointer field, UDATA offsetOrAddress, boolean isHidden) {
        this.field = field;
        this.offsetOrAddress = offsetOrAddress;
        this.isHidden = isHidden;
    }

    public boolean isStatic() {
        try {
            return this.field.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccStatic);
        }
        catch (CorruptDataException e) {
            return false;
        }
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public J9ROMFieldShapePointer getField() {
        return this.field;
    }

    public UDATA getOffsetOrAddress() {
        return this.offsetOrAddress;
    }

    public String toString() {
        return String.format("%s: %s isStatic: %s", this.field, this.offsetOrAddress, this.isStatic());
    }

    public String getName() throws CorruptDataException {
        return J9ROMFieldShapeHelper.getName(this.field);
    }

    public String getSignature() throws CorruptDataException {
        return J9ROMFieldShapeHelper.getSignature(this.field);
    }
}

