/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.vm26.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm26.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm26.pointer.DoublePointer;
import com.ibm.j9ddr.vm26.pointer.FloatPointer;
import com.ibm.j9ddr.vm26.pointer.I16Pointer;
import com.ibm.j9ddr.vm26.pointer.I32Pointer;
import com.ibm.j9ddr.vm26.pointer.I64Pointer;
import com.ibm.j9ddr.vm26.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm26.pointer.Pointer;
import com.ibm.j9ddr.vm26.pointer.U16Pointer;
import com.ibm.j9ddr.vm26.pointer.U32Pointer;
import com.ibm.j9ddr.vm26.pointer.U64Pointer;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import com.ibm.j9ddr.vm26.pointer.UDATAPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm26.structure.J9FieldFlags;
import com.ibm.j9ddr.vm26.structure.J9Object;
import com.ibm.j9ddr.vm26.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class J9ObjectStructureFormatter
extends BaseStructureFormatter {
    private static final int DEFAULT_ARRAY_FORMAT_BEGIN = 0;
    private static final int DEFAULT_ARRAY_FORMAT_END = 16;

    @Override
    public FormatWalkResult format(String type2, long address, PrintStream out, Context context, List<IFieldFormatter> fieldFormatters, String[] extraArgs) {
        if (type2.equalsIgnoreCase("j9object") || type2.equalsIgnoreCase("j9indexableobject")) {
            J9ClassPointer classAddr = null;
            J9ObjectPointer object = null;
            try {
                object = J9ObjectPointer.cast(address);
                classAddr = J9ObjectHelper.clazz(object);
                if (classAddr.isNull()) {
                    out.println("<can not read RAM class address>");
                    return FormatWalkResult.STOP_WALKING;
                }
                J9ClassPointer clazz = classAddr;
                boolean isArray = J9ClassHelper.isArrayClass(clazz);
                String className = J9UTF8Helper.stringValue(clazz.romClass().className());
                if (className.equals("java/lang/String")) {
                    this.formatStringObject(out, object);
                } else if (isArray) {
                    int begin = 0;
                    int end = 16;
                    if (extraArgs.length > 0) {
                        begin = Integer.parseInt(extraArgs[0]);
                    }
                    if (extraArgs.length > 1) {
                        end = Integer.parseInt(extraArgs[1]);
                    }
                    this.formatArrayObject(out, J9IndexableObjectPointer.cast(object), begin, end);
                } else {
                    out.println(String.format("J9Object at %s {", object.getHexAddress()));
                    this.printJ9ObjectFields(out, object);
                    out.println("}");
                }
            }
            catch (MemoryFault ex2) {
                out.println("Unable to read object clazz at " + object.getHexAddress() + " (clazz = " + classAddr.getHexAddress() + ")");
            }
            catch (CorruptDataException ex) {
                out.println("Error for ");
                ex.printStackTrace(out);
            }
            return FormatWalkResult.STOP_WALKING;
        }
        return FormatWalkResult.KEEP_WALKING;
    }

    private void formatArrayObject(PrintStream out, J9IndexableObjectPointer localObject, int begin, int end) throws CorruptDataException {
        String className = J9IndexableObjectHelper.getClassName(localObject);
        out.println(String.format("J9IndexableObject at %s {", localObject.getHexAddress()));
        out.println(String.format("    struct J9Class* clazz = !j9arrayclass %s   // %s", J9IndexableObjectHelper.clazz(localObject).getHexAddress(), className));
        out.println(String.format("    Object flags = %s;", J9IndexableObjectHelper.flags(localObject).getHexValue()));
        if (!J9BuildFlags.thr_lockNursery) {
            out.println(String.format("    j9objectmonitor_t monitor = %s;", J9IndexableObjectHelper.monitor(localObject).getHexValue()));
        }
        out.println(String.format("    U_32 size = %s;", J9IndexableObjectHelper.size(localObject).getHexValue()));
        this.printSubArrayType(out, begin, end, localObject);
        out.println("}");
    }

    void printSubArrayType(PrintStream out, int begin, int end, J9IndexableObjectPointer array) throws CorruptDataException {
        String className = J9IndexableObjectHelper.getClassName(array);
        int arraySize = (int)J9IndexableObjectHelper.size(array).longValue();
        int finish = Math.min(arraySize, end);
        if (begin < finish) {
            switch (className.charAt(1)) {
                case 'B': 
                case 'Z': {
                    for (int index = begin; index < finish; ++index) {
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 1);
                        out.println(String.format("    [%d] = %3d, 0x%02x", index, U8Pointer.cast(slot).at(0L).longValue(), U8Pointer.cast(slot).at(0L).longValue()));
                    }
                    break;
                }
                case 'C': {
                    for (int index = begin; index < finish; ++index) {
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 2);
                        long value = U16Pointer.cast(slot).at(0L).longValue();
                        out.println(String.format("    [%d] = %5d, 0x%2$04x, '%c'", index, value, Character.valueOf((char)value)));
                    }
                    break;
                }
                case 'S': {
                    for (int index = begin; index < finish; ++index) {
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 2);
                        out.println(String.format("    [%d] = %6d, 0x%04x", index, I16Pointer.cast(slot).at(0L).longValue(), U16Pointer.cast(slot).at(0L).longValue()));
                    }
                    break;
                }
                case 'F': 
                case 'I': {
                    for (int index = begin; index < finish; ++index) {
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 4);
                        out.println(String.format("    [%d] = %10d, 0x%08x, %8.8fF", index, I32Pointer.cast(slot).at(0L).longValue(), U32Pointer.cast(slot).at(0L).longValue(), Float.valueOf(FloatPointer.cast(slot).floatAt(0L))));
                    }
                    break;
                }
                case 'D': 
                case 'J': {
                    for (int index = begin; index < finish; ++index) {
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, 8);
                        out.println(String.format("    [%d] = %2d, 0x%016x, %8.8fF", index, I64Pointer.cast(slot).at(0L).longValue(), I64Pointer.cast(slot).at(0L).longValue(), DoublePointer.cast(slot).doubleAt(0L)));
                    }
                    break;
                }
                case 'L': 
                case '[': {
                    for (int index = begin; index < finish; ++index) {
                        VoidPointer slot = J9IndexableObjectHelper.getElementEA(array, index, (int)ObjectReferencePointer.SIZEOF);
                        if (slot.notNull()) {
                            long compressedPtrValue = J9BuildFlags.gc_compressedPointers ? I32Pointer.cast(slot).at(0L).longValue() : slot.getProcess().getPointerAt(slot.getAddress());
                            out.println(String.format("    [%d] = !fj9object 0x%x = !j9object 0x%x", index, compressedPtrValue, ObjectReferencePointer.cast(slot).at(0L).longValue()));
                            continue;
                        }
                        out.println(String.format("    [%d] = null", slot));
                    }
                    break;
                }
            }
        }
        if (begin > 0 || arraySize > finish) {
            out.println(String.format("To print entire range: !j9indexableobject %s %d %d\n", array.getHexAddress(), 0, arraySize));
        }
    }

    private void formatStringObject(PrintStream out, J9ObjectPointer localObject) throws CorruptDataException {
        out.println(String.format("J9VMJavaLangString at %s {\n", localObject.getHexAddress()));
        this.printJ9ObjectFields(out, localObject);
        out.println(String.format("    \"%s\"\n", J9ObjectHelper.stringValue(localObject)));
        out.println("}");
    }

    private void printJ9ObjectFields(PrintStream out, J9ObjectPointer localObject) throws CorruptDataException {
        UDATA lockword;
        J9ClassPointer instanceClass = J9ObjectHelper.clazz(localObject);
        J9UTF8Pointer classNameUTF = instanceClass.romClass().className();
        J9ClassPointer previousSuperclass = J9ClassPointer.NULL;
        boolean lockwordPrinted = false;
        if (J9BuildFlags.thr_lockNursery) {
            lockwordPrinted = false;
        }
        out.println(String.format("    struct J9Class* clazz = !j9class %s   // %s", J9ObjectHelper.clazz(localObject).getHexAddress(), J9UTF8Helper.stringValue(classNameUTF)));
        out.println(String.format("    Object flags = %s;", J9ObjectHelper.flags(localObject).getHexValue()));
        if (!J9BuildFlags.thr_lockNursery && (lockword = J9ObjectHelper.monitor(localObject)) != null) {
            out.println(String.format("    j9objectmonitor_t monitor = %s;", lockword.getHexValue()));
        }
        long depth = J9ClassHelper.depth(instanceClass);
        for (long superclassIndex = 0L; superclassIndex <= depth; ++superclassIndex) {
            J9ClassPointer superclass = superclassIndex == depth ? instanceClass : J9ClassPointer.cast(instanceClass.superclasses().at(superclassIndex));
            U32 flags = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
            Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(superclass.romClass(), instanceClass, previousSuperclass, flags);
            while (iterator.hasNext()) {
                J9ObjectFieldOffset result = iterator.next();
                boolean printField = true;
                boolean isHiddenField = result.isHidden();
                if (J9BuildFlags.thr_lockNursery) {
                    boolean isLockword;
                    boolean bl = isLockword = isHiddenField && result.getOffsetOrAddress().add(J9Object.SIZEOF).eq(superclass.lockOffset());
                    if (isLockword) {
                        boolean bl2 = printField = !lockwordPrinted && instanceClass.lockOffset().eq(superclass.lockOffset());
                        if (printField) {
                            lockwordPrinted = true;
                        }
                    }
                }
                if (!printField) continue;
                this.printObjectField(out, localObject, superclass, result.getField(), result.getOffsetOrAddress(), isHiddenField);
            }
            previousSuperclass = superclass;
        }
    }

    private void printObjectField(PrintStream out, J9ObjectPointer localObject, J9ClassPointer fromClass, J9ROMFieldShapePointer field, UDATA offset, boolean isHiddenField) throws CorruptDataException {
        J9UTF8Pointer className = fromClass.romClass().className();
        J9UTF8Pointer nameUTF = field.nameAndSignature().name();
        J9UTF8Pointer sigUTF = field.nameAndSignature().signature();
        U8Pointer valuePtr = U8Pointer.cast(localObject).add(offset).add(J9Object.SIZEOF);
        out.print(String.format("    %s %s = ", J9UTF8Helper.stringValue(sigUTF), J9UTF8Helper.stringValue(nameUTF)));
        if (field.modifiers().anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
            out.print(U64Pointer.cast(valuePtr).at(0L).getHexValue());
        } else if (field.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
            Pointer ptr = J9BuildFlags.gc_compressedPointers ? U32Pointer.cast(valuePtr) : UDATAPointer.cast(valuePtr);
            out.print(String.format("!fj9object 0x%x", ptr.at(0L).longValue()));
        } else {
            out.print(I32Pointer.cast(valuePtr).at(0L).getHexValue());
        }
        out.print(String.format(" (offset=%d) (%s)", offset.longValue(), J9UTF8Helper.stringValue(className)));
        if (isHiddenField) {
            out.print(" <hidden>");
        }
        out.println();
    }
}

