/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.monitors;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.Pool;
import com.ibm.j9ddr.vm26.j9.SlotIterator;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ThreadLibraryPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm26.structure.J9Consts;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.monitors.DeadlockUtils;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.monitors.NativeDeadlockGraphNode;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;

public class DeadlockDetector {
    public static void findDeadlocks(PrintStream out) throws DDRInteractiveCommandException {
        HashMap<Integer, NativeDeadlockGraphNode> map = new HashMap<Integer, NativeDeadlockGraphNode>();
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            HashMap<J9ObjectPointer, Object> objectMonitorsMap = DeadlockUtils.readObjectMonitors(vm);
            J9ThreadLibraryPointer lib = vm.mainThread().osThread().library();
            J9PoolPointer pool = lib.thread_pool();
            Pool<J9ThreadPointer> threadPool = Pool.fromJ9Pool(pool, J9ThreadPointer.class);
            SlotIterator<J9ThreadPointer> poolIterator = threadPool.iterator();
            J9ThreadPointer osThreadPtr = null;
            while (poolIterator.hasNext()) {
                osThreadPtr = (J9ThreadPointer)poolIterator.next();
                DeadlockUtils.findThreadCycle(osThreadPtr, map, objectMonitorsMap);
                J9VMThreadPointer vmThread = J9ThreadHelper.getVMThread(osThreadPtr);
                if (null == vmThread || !vmThread.notNull() || !vmThread.publicFlags().allBitsIn(J9Consts.J9_PUBLIC_FLAGS_HALT_THREAD_INSPECTION)) continue;
                break;
            }
            int cycle = 0;
            Iterator iterator = map.entrySet().iterator();
            block3: while (iterator.hasNext()) {
                NativeDeadlockGraphNode node = (NativeDeadlockGraphNode)iterator.next().getValue();
                ++cycle;
                while (null != node) {
                    if (node.cycle > 0) {
                        if (node.cycle != cycle) continue block3;
                        out.println("Deadlock Detected !!!");
                        out.println("---------------------");
                        out.println();
                        NativeDeadlockGraphNode head = node;
                        boolean isCycleRoot = true;
                        do {
                            DeadlockUtils.writeDeadlockNode(node, isCycleRoot, objectMonitorsMap, out);
                            node = node.next;
                            isCycleRoot = false;
                        } while (node != head);
                        out.println(node.toString());
                        continue block3;
                    }
                    node.cycle = cycle;
                    node = node.next;
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

