/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.j9.ObjectModel;
import com.ibm.j9ddr.vm26.pointer.I32Pointer;
import com.ibm.j9ddr.vm26.pointer.I64Pointer;
import com.ibm.j9ddr.vm26.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm26.pointer.U16Pointer;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9IndexableObjectContiguousPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9IndexableObjectDiscontiguousPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ArrayClassHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.io.StringWriter;

public class J9IndexableObjectHelper
extends J9ObjectHelper {
    public static U32 flags(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        return J9ObjectHelper.flags(J9ObjectPointer.cast(objPointer));
    }

    public static J9ArrayClassPointer clazz(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        return J9ArrayClassPointer.cast(J9ObjectHelper.clazz(J9ObjectPointer.cast(objPointer)));
    }

    public static UDATA monitor(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        return J9ObjectHelper.monitor(J9ObjectPointer.cast(objPointer));
    }

    public static String getClassName(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        return J9ArrayClassHelper.getName(J9IndexableObjectHelper.clazz(objPointer));
    }

    public static U32 size(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        U32 size = J9IndexableObjectContiguousPointer.cast(objPointer).size();
        if (J9BuildFlags.gc_hybridArraylets && size.eq(0L)) {
            size = J9IndexableObjectDiscontiguousPointer.cast(objPointer).size();
        }
        if (size.anyBitsIn(Integer.MIN_VALUE)) {
            throw new CorruptDataException("java array size with sign bit set");
        }
        return size;
    }

    public static U32 size(J9ObjectPointer objPointer) throws CorruptDataException {
        return J9IndexableObjectHelper.size(J9IndexableObjectPointer.cast(objPointer));
    }

    public static VoidPointer getElementEA(J9IndexableObjectPointer objPointer, int index, int dataSize) throws CorruptDataException {
        return ObjectModel.getElementAddress(objPointer, index, dataSize);
    }

    public static void getData(J9IndexableObjectPointer objPointer, Object dst, int start, int length, int destStart) throws CorruptDataException {
        String className = J9IndexableObjectHelper.getClassName(objPointer);
        int arraySize = (int)J9IndexableObjectHelper.size(objPointer).longValue();
        if (start + length > arraySize) {
            throw new ArrayIndexOutOfBoundsException("Requested range " + start + " to " + (start + length) + " overflows array of length " + arraySize);
        }
        switch (className.charAt(1)) {
            case 'B': {
                if (!(dst instanceof byte[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with byte array (expects byte[])");
                }
                J9IndexableObjectHelper.getByteData(objPointer, (byte[])dst, start, length, destStart);
                break;
            }
            case 'C': {
                if (!(dst instanceof char[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with char array (expects char[])");
                }
                J9IndexableObjectHelper.getCharData(objPointer, (char[])dst, start, length, destStart);
                break;
            }
            case 'D': {
                if (!(dst instanceof double[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with double array (expects double[])");
                }
                J9IndexableObjectHelper.getDoubleData(objPointer, (double[])dst, start, length, destStart);
                break;
            }
            case 'F': {
                if (!(dst instanceof float[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with float array (expects float[])");
                }
                J9IndexableObjectHelper.getFloatData(objPointer, (float[])dst, start, length, destStart);
                break;
            }
            case 'I': {
                if (!(dst instanceof int[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with int array (expects int[])");
                }
                J9IndexableObjectHelper.getIntData(objPointer, (int[])dst, start, length, destStart);
                break;
            }
            case 'J': {
                if (!(dst instanceof long[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with long array (expects long[])");
                }
                J9IndexableObjectHelper.getLongData(objPointer, (long[])dst, start, length, destStart);
                break;
            }
            case 'S': {
                if (!(dst instanceof short[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with short array (expects short[])");
                }
                J9IndexableObjectHelper.getShortData(objPointer, (short[])dst, start, length, destStart);
                break;
            }
            case 'Z': {
                if (!(dst instanceof boolean[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with boolean array (expects boolean[])");
                }
                J9IndexableObjectHelper.getBooleanData(objPointer, (boolean[])dst, start, length, destStart);
                break;
            }
            case 'L': 
            case '[': {
                if (!(dst instanceof J9ObjectPointer[])) {
                    throw new IllegalArgumentException("Destination array of type " + dst.getClass().getName() + " incompatible with Object array (expects J9ObjectPointer[])");
                }
                J9IndexableObjectHelper.getObjectData(objPointer, (J9ObjectPointer[])dst, start, length, destStart);
                break;
            }
            default: {
                throw new CorruptDataException("The data identifier : " + className.charAt(1) + " was not recognised");
            }
        }
    }

    public static void getByteData(J9IndexableObjectPointer objPointer, byte[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = (byte)U8Pointer.cast(ObjectModel.getElementAddress(objPointer, start + i, 1)).at(0L).intValue();
        }
    }

    public static void getCharData(J9IndexableObjectPointer objPointer, char[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = (char)U16Pointer.cast(ObjectModel.getElementAddress(objPointer, start + i, 2)).at(0L).intValue();
        }
    }

    public static void getDoubleData(J9IndexableObjectPointer objPointer, double[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            long bits = I64Pointer.cast(ObjectModel.getElementAddress(objPointer, start + i, 8)).at(0L).longValue();
            dst[destStart + i] = Double.longBitsToDouble(bits);
        }
    }

    public static void getFloatData(J9IndexableObjectPointer objPointer, float[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            int bits = I32Pointer.cast(ObjectModel.getElementAddress(objPointer, start + i, 4)).at(0L).intValue();
            dst[destStart + i] = Float.intBitsToFloat(bits);
        }
    }

    public static void getIntData(J9IndexableObjectPointer objPointer, int[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = I32Pointer.cast(ObjectModel.getElementAddress(objPointer, start + i, 4)).at(0L).intValue();
        }
    }

    public static void getLongData(J9IndexableObjectPointer objPointer, long[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = I64Pointer.cast(ObjectModel.getElementAddress(objPointer, start + i, 8)).at(0L).longValue();
        }
    }

    public static void getShortData(J9IndexableObjectPointer objPointer, short[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = (short)U16Pointer.cast(ObjectModel.getElementAddress(objPointer, start + i, 2)).at(0L).intValue();
        }
    }

    public static void getBooleanData(J9IndexableObjectPointer objPointer, boolean[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = 0 != U8Pointer.cast(ObjectModel.getElementAddress(objPointer, start + i, 1)).at(0L).intValue();
        }
    }

    public static void getObjectData(J9IndexableObjectPointer objPointer, J9ObjectPointer[] dst, int start, int length, int destStart) throws CorruptDataException {
        if (destStart + length > dst.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + destStart + length + ", was " + dst.length);
        }
        for (int i = 0; i < length; ++i) {
            dst[destStart + i] = ObjectReferencePointer.cast(ObjectModel.getElementAddress(objPointer, start + i, (int)ObjectReferencePointer.SIZEOF)).at(0L);
        }
    }

    public static Object getData(J9IndexableObjectPointer objPointer) throws CorruptDataException {
        String className = J9IndexableObjectHelper.getClassName(objPointer);
        int arraySize = (int)J9IndexableObjectHelper.size(objPointer).longValue();
        switch (className.charAt(1)) {
            case 'B': {
                byte[] data = new byte[arraySize];
                J9IndexableObjectHelper.getByteData(objPointer, data, 0, arraySize, 0);
                return data;
            }
            case 'C': {
                char[] data = new char[arraySize];
                J9IndexableObjectHelper.getCharData(objPointer, data, 0, arraySize, 0);
                return data;
            }
            case 'D': {
                double[] data = new double[arraySize];
                J9IndexableObjectHelper.getDoubleData(objPointer, data, 0, arraySize, 0);
                return data;
            }
            case 'F': {
                float[] data = new float[arraySize];
                J9IndexableObjectHelper.getFloatData(objPointer, data, 0, arraySize, 0);
                return data;
            }
            case 'I': {
                int[] data = new int[arraySize];
                J9IndexableObjectHelper.getIntData(objPointer, data, 0, arraySize, 0);
                return data;
            }
            case 'J': {
                long[] data = new long[arraySize];
                J9IndexableObjectHelper.getLongData(objPointer, data, 0, arraySize, 0);
                return data;
            }
            case 'S': {
                short[] data = new short[arraySize];
                J9IndexableObjectHelper.getShortData(objPointer, data, 0, arraySize, 0);
                return data;
            }
            case 'Z': {
                boolean[] data = new boolean[arraySize];
                J9IndexableObjectHelper.getBooleanData(objPointer, data, 0, arraySize, 0);
                return data;
            }
            case 'L': 
            case '[': {
                J9ObjectPointer[] data = new J9ObjectPointer[arraySize];
                J9IndexableObjectHelper.getObjectData(objPointer, data, 0, arraySize, 0);
                return data;
            }
        }
        throw new CorruptDataException("The data identifier : " + className.charAt(1) + " was not recognised");
    }

    public static String getDataAsString(J9IndexableObjectPointer array) throws CorruptDataException {
        return J9IndexableObjectHelper.getDataAsString(array, 10, 80);
    }

    public static String getDataAsString(J9IndexableObjectPointer array, int dumpLimit, int characterDumpLimit) throws CorruptDataException {
        int i;
        StringWriter buf = new StringWriter();
        J9ClassPointer clazz = J9ObjectHelper.clazz(J9ObjectPointer.cast(array));
        char typeChar = J9ClassHelper.getName(clazz).charAt(1);
        int length = J9IndexableObjectHelper.size(array).intValue();
        int limit = 0;
        limit = typeChar != 'C' ? dumpLimit : characterDumpLimit;
        buf.write("{ ");
        for (i = 0; i < Math.min(length, limit); ++i) {
            Object data = J9IndexableObjectHelper.getData(array);
            switch (typeChar) {
                case 'B': {
                    buf.write("0x");
                    buf.write(Integer.toHexString(((byte[])data)[i]));
                    break;
                }
                case 'C': {
                    char ch = ((char[])data)[i];
                    if (ch > '\u001f' && ch < '\u007f') {
                        buf.write(ch);
                        break;
                    }
                    buf.write(63);
                    break;
                }
                case 'D': {
                    buf.write(Double.toString(((double[])data)[i]));
                    break;
                }
                case 'F': {
                    buf.write(Float.toString(((float[])data)[i]));
                    break;
                }
                case 'I': {
                    buf.write("0x");
                    buf.write(Integer.toHexString(((int[])data)[i]));
                    break;
                }
                case 'J': {
                    buf.write("0x");
                    buf.write(Long.toHexString(((long[])data)[i]));
                    break;
                }
                case 'S': {
                    buf.write("0x");
                    buf.write(Integer.toHexString(((short[])data)[i]));
                    break;
                }
                case 'Z': {
                    buf.write(((boolean[])data)[i] ? "true" : "false");
                    break;
                }
                case 'L': 
                case '[': {
                    J9ObjectPointer item = ((J9ObjectPointer[])data)[i];
                    if (null == item) {
                        buf.write("null");
                        break;
                    }
                    buf.write("0x");
                    buf.write(Long.toHexString(item.longValue()));
                    break;
                }
                default: {
                    buf.write("?");
                }
            }
            if (typeChar == 'C' || i == length - 1) continue;
            buf.write(", ");
        }
        if (i != length) {
            buf.write("... ");
        }
        buf.write(" }");
        return buf.toString();
    }
}

