/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.generated;

import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.StructurePointer;
import com.ibm.j9ddr.vm26.structure.BitMapAction;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UDATA;

@GeneratedPointerClass(structureClass=BitMapAction.class)
public class BitMapActionPointer
extends StructurePointer {
    public static final BitMapActionPointer NULL = new BitMapActionPointer(0L);

    protected BitMapActionPointer(long address) {
        super(address);
    }

    public static BitMapActionPointer cast(AbstractPointer structure) {
        return BitMapActionPointer.cast(structure.getAddress());
    }

    public static BitMapActionPointer cast(UDATA udata) {
        return BitMapActionPointer.cast(udata.longValue());
    }

    public static BitMapActionPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new BitMapActionPointer(address);
    }

    @Override
    public BitMapActionPointer add(long count) {
        return BitMapActionPointer.cast(this.address + BitMapAction.SIZEOF * count);
    }

    @Override
    public BitMapActionPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public BitMapActionPointer addOffset(long offset) {
        return BitMapActionPointer.cast(this.address + offset);
    }

    @Override
    public BitMapActionPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public BitMapActionPointer sub(long count) {
        return BitMapActionPointer.cast(this.address - BitMapAction.SIZEOF * count);
    }

    @Override
    public BitMapActionPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public BitMapActionPointer subOffset(long offset) {
        return BitMapActionPointer.cast(this.address - offset);
    }

    @Override
    public BitMapActionPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public BitMapActionPointer untag(long mask) {
        return BitMapActionPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public BitMapActionPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return BitMapAction.SIZEOF;
    }
}

