/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.gc.GCClassStaticsIterator;
import com.ibm.j9ddr.vm26.j9.gc.GCConstantPoolObjectSlotIterator;
import com.ibm.j9ddr.vm26.j9.gc.GCIterator;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import java.util.NoSuchElementException;

public class GCClassIterator
extends GCIterator {
    public static final int state_start = 0;
    public static final int state_statics = 1;
    public static final int state_constant_pool = 2;
    public static final int state_slots = 3;
    public static final int state_end = 4;
    protected int state = 0;
    protected GCClassStaticsIterator staticsIterator;
    protected GCConstantPoolObjectSlotIterator constantPoolSlotIterator;
    protected J9ClassPointer clazz;

    protected GCClassIterator(J9ClassPointer clazz) throws CorruptDataException {
        this.staticsIterator = GCClassStaticsIterator.fromJ9Class(clazz);
        this.constantPoolSlotIterator = GCConstantPoolObjectSlotIterator.fromJ9Class(clazz);
        this.clazz = clazz;
    }

    public static GCClassIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassIterator(clazz);
    }

    @Override
    public boolean hasNext() {
        if (this.state == 4) {
            return false;
        }
        switch (this.state) {
            case 0: {
                ++this.state;
            }
            case 1: {
                if (this.staticsIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 2: {
                if (this.constantPoolSlotIterator.hasNext()) {
                    return true;
                }
                ++this.state;
            }
            case 3: {
                if (this.clazz != null) {
                    return true;
                }
                ++this.state;
            }
        }
        return false;
    }

    @Override
    public J9ObjectPointer next() {
        if (this.hasNext()) {
            switch (this.state) {
                case 1: {
                    return this.staticsIterator.next();
                }
                case 2: {
                    return this.constantPoolSlotIterator.next();
                }
                case 3: {
                    if (this.clazz == null) break;
                    J9ObjectPointer classObject = null;
                    try {
                        classObject = this.clazz.classObject();
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error fetching the class object", e, false);
                    }
                    this.clazz = null;
                    return classObject;
                }
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            switch (this.state) {
                case 1: {
                    return this.staticsIterator.nextAddress();
                }
                case 2: {
                    return this.constantPoolSlotIterator.nextAddress();
                }
                case 3: {
                    if (this.clazz == null) break;
                    VoidPointer ea = null;
                    try {
                        ea = VoidPointer.cast(this.clazz.classObjectEA());
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error fetching the class object", e, false);
                    }
                    this.clazz = null;
                    return ea;
                }
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    public int getState() {
        return this.state;
    }
}

