/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm26.j9.SlotIterator;
import com.ibm.j9ddr.vm26.j9.StringTable_V1;
import com.ibm.j9ddr.vm26.j9.StringTable_V2;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_StringTablePointer;
import com.ibm.j9ddr.vm26.structure.MM_StringTable;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.NoSuchElementException;

public abstract class StringTable {
    protected MM_StringTablePointer _stringTable;
    protected long _tableCount;

    public abstract J9ObjectPointer search(J9ObjectPointer var1) throws CorruptDataException;

    public abstract StringSlotIterator iterator();

    public static StringTable from() throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("VM_HASHTABLE_VERSION");
        switch (version.getAlgorithmVersion()) {
            case 0: {
                return StringTable_V1.from();
            }
        }
        return StringTable_V2.from();
    }

    public SlotIterator<J9ObjectPointer> cacheIterator() {
        return new SlotIterator<J9ObjectPointer>(){
            private UDATA cacheTableIndex = new UDATA(0L);
            private UDATA cacheSize;
            private PointerPointer cache;
            {
                try {
                    this.cacheSize = StringTable.this.getCacheSize();
                    this.cache = StringTable.this._stringTable._cacheEA();
                }
                catch (CorruptDataException e) {
                    EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                    this.cacheSize = new UDATA(0L);
                }
            }

            @Override
            public boolean hasNext() {
                while (this.cacheTableIndex.lt(this.cacheSize)) {
                    try {
                        if (this.cache.at(this.cacheTableIndex).notNull()) {
                            return true;
                        }
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                    }
                    this.cacheTableIndex = this.cacheTableIndex.add(1L);
                }
                return false;
            }

            @Override
            public J9ObjectPointer next() {
                if (this.hasNext()) {
                    try {
                        J9ObjectPointer cachedString = J9ObjectPointer.cast(this.cache.at(this.cacheTableIndex));
                        this.cacheTableIndex = this.cacheTableIndex.add(1L);
                        return cachedString;
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                        return null;
                    }
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public VoidPointer nextAddress() {
                if (this.hasNext()) {
                    VoidPointer address = VoidPointer.cast(this.cache.add(this.cacheTableIndex));
                    this.cacheTableIndex = this.cacheTableIndex.add(1L);
                    return address;
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The image is read only and cannot be modified.");
            }
        };
    }

    protected UDATA getCacheSize() {
        return new UDATA(MM_StringTable.cacheSize);
    }

    public abstract class StringSlotIterator
    implements SlotIterator<J9ObjectPointer> {
        public abstract J9HashTablePointer getCurrentHashTable() throws CorruptDataException;
    }
}

