/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaStackPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class J9JavaStackIterator
implements Iterator<J9JavaStackPointer> {
    protected J9JavaStackPointer initialStack;
    protected J9JavaStackPointer currentStack;
    protected boolean consumedInitial;

    protected J9JavaStackIterator(J9JavaStackPointer stack) throws CorruptDataException {
        this.initialStack = stack;
        this.currentStack = stack;
    }

    public static J9JavaStackIterator fromJ9JavaStack(J9JavaStackPointer stack) throws CorruptDataException {
        return new J9JavaStackIterator(stack);
    }

    @Override
    public boolean hasNext() {
        return this.currentStack.notNull();
    }

    @Override
    public J9JavaStackPointer next() {
        try {
            if (this.hasNext()) {
                J9JavaStackPointer next = this.currentStack;
                this.currentStack = this.currentStack.previous();
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            this.currentStack = J9JavaStackPointer.NULL;
            EventManager.raiseCorruptDataEvent("Error getting next stack section", cde, false);
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The image is read only and cannot be modified.");
    }
}

