/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.stackmap;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm24.j9.ArgBits;
import com.ibm.j9ddr.vm24.j9.PCStack;
import com.ibm.j9ddr.vm24.j9.ROMHelp;
import com.ibm.j9ddr.vm24.j9.VrfyTbl;
import com.ibm.j9ddr.vm24.j9.stackmap.MapHelpers;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm24.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm24.types.I16;
import com.ibm.j9ddr.vm24.types.I32;
import com.ibm.j9ddr.vm24.types.IDATA;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.util.Arrays;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugLocalMap {
    private static Logger logger = Logger.getLogger("j9ddr.stackwalker.localmap");
    private static final int BRANCH_TARGET = 1;
    private static final int BRANCH_EXCEPTION_START = 2;
    private static final int BRANCH_TARGET_IN_USE = 4;
    private static final int BRANCH_TARGET_TO_WALK = 8;
    private static final int[] decodeTable = new int[]{0, -16777214, 17, 33, 65, 129, 6, 0, 8, 9, 10, 11, 12, 13, 14, 15};
    private static DebugLocalMapImpl impl;

    public static int j9localmap_DebugLocalBitsForPC(J9ROMMethodPointer romMethod, UDATA pc, int[] resultsArray) throws CorruptDataException {
        return DebugLocalMap.getImpl().j9localmap_DebugLocalBitsForPC(romMethod, pc, resultsArray);
    }

    private static DebugLocalMapImpl getImpl() {
        if (impl == null) {
            impl = DebugLocalMap.getImpl("ALG_DEBUG_LOCAL_MAP_VERSION");
        }
        return impl;
    }

    private static DebugLocalMapImpl getImpl(String algorithmID) {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf(algorithmID);
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new DebugLocalMap_V1();
    }

    private static class DebugLocalMap_V1
    implements DebugLocalMapImpl {
        private DebugLocalMap_V1() {
        }

        @Override
        public int j9localmap_DebugLocalBitsForPC(J9ROMMethodPointer romMethod, UDATA pc, int[] resultsArray) throws CorruptDataException {
            DebugLocalMapData mapData = new DebugLocalMapData();
            logger.logp(Level.FINE, "DebugLocalMap", "j9localmap_DebugLocalBitsForPC", "[][][] entering DEBUG local map in {0}{1} at {2}\n", new Object[]{J9UTF8Helper.stringValue(romMethod.nameAndSignature().name()), J9UTF8Helper.stringValue(romMethod.nameAndSignature().signature()), pc});
            mapData.romMethod = romMethod;
            mapData.targetPC = pc.intValue();
            mapData.resultsArray = resultsArray;
            UDATA length = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
            mapData.bytecodeMap = new byte[length.intValue()];
            mapData.mapArray = new int[length.intValue()];
            this.debugBuildBranchMap(mapData);
            this.debugMapAllLocals(mapData);
            return 0;
        }

        private void debugMapAllLocals(DebugLocalMapData mapData) throws CorruptDataException {
            J9ROMMethodPointer romMethod = mapData.romMethod;
            int localIndexBase = 0;
            int writeIndex = 0;
            int remainingLocals = ROMHelp.J9_TEMP_COUNT_FROM_ROM_METHOD(romMethod).add(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(romMethod)).intValue();
            int[] parallelResultArrayBase = mapData.resultsArray;
            UDATA length = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
            ArgBits.argBitsFromSignature(J9UTF8Helper.stringValue(romMethod.nameAndSignature().signature()), mapData.resultsArray, remainingLocals + 31 >> 5, romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccStatic));
            while (remainingLocals != 0) {
                remainingLocals = remainingLocals > 32 ? (remainingLocals -= 32) : 0;
                mapData.currentLocals = parallelResultArrayBase[writeIndex];
                Arrays.fill(mapData.mapArray, 0, length.intValue(), 0);
                this.debugMapLocalSet(mapData, localIndexBase);
                if (remainingLocals != 0) {
                    int i = 0;
                    while (i < length.intValue()) {
                        int n = i++;
                        mapData.bytecodeMap[n] = (byte)(mapData.bytecodeMap[n] & 3);
                    }
                }
                parallelResultArrayBase[writeIndex] = mapData.mapArray[mapData.targetPC];
                ++writeIndex;
                localIndexBase += 32;
            }
        }

        private int debugMapLocalSet(DebugLocalMapData mapData, int localIndexBase) throws CorruptDataException {
            J9ROMMethodPointer romMethod = mapData.romMethod;
            byte[] bytecodeMap = mapData.bytecodeMap;
            int pc = 0;
            boolean justLoadedStack = false;
            boolean wideIndex = false;
            boolean checkIfInsideException = romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo);
            J9ExceptionInfoPointer exceptionData = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(romMethod);
            U8Pointer code = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(romMethod);
            int length = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod).intValue();
            U8Pointer bcIndex = code;
            while (pc < length) {
                UDATA exception;
                J9ExceptionHandlerPointer handler;
                int start = pc;
                if ((bytecodeMap[start] & 2) != 0) {
                    handler = ROMHelp.J9EXCEPTIONINFO_HANDLERS(exceptionData);
                    exception = new UDATA(0L);
                    while (exception.lt(exceptionData.catchCount())) {
                        if (start == handler.startPC().intValue()) {
                            this.debugMergeStacks(mapData, handler.handlerPC().intValue());
                        }
                        handler = handler.add(1L);
                        exception = exception.add(1L);
                    }
                }
                if ((bytecodeMap[start] & 1) != 0 && !justLoadedStack) {
                    this.debugMergeStacks(mapData, start);
                    if (!mapData.rootStack.isEmpty()) {
                        pc = mapData.rootStack.pop();
                        mapData.currentLocals = mapData.mapArray[pc];
                        int n = pc;
                        bytecodeMap[n] = (byte)(bytecodeMap[n] & 0xFFFFFFF7);
                        justLoadedStack = true;
                    } else {
                        return 0;
                    }
                }
                justLoadedStack = false;
                bcIndex = code.add(start);
                int bc = bcIndex.at(0L).intValue() & 0xFF;
                if ((PCStack.J9JavaInstructionSizeAndBranchActionTable[bc] & 7) == 0) {
                    throw new CorruptDataException("Invalid byte code");
                }
                pc += PCStack.J9JavaInstructionSizeAndBranchActionTable[bc] & 7;
                int type1 = VrfyTbl.J9JavaBytecodeVerificationTable[bc];
                int action = type1 >>> 8;
                int type2 = type1 >>> 4 & 0xF;
                type1 = decodeTable[type1 & 0xF];
                type2 = decodeTable[type2];
                block0 : switch (action) {
                    case 21: {
                        wideIndex = true;
                    }
                    case 6: {
                        int index = type2 & 7;
                        if (type2 == 0) {
                            index = MapHelpers.PARAM_8(bcIndex, 1).intValue();
                            if (wideIndex) {
                                index = MapHelpers.PARAM_16(bcIndex, 1).intValue();
                                wideIndex = false;
                            }
                        }
                        if ((index -= localIndexBase) < 32) {
                            int setBit = 1 << index;
                            if (type1 == 0) {
                                mapData.currentLocals |= setBit;
                            } else {
                                mapData.currentLocals &= ~setBit;
                                if ((type1 & 0xC0) != 0) {
                                    mapData.currentLocals &= ~(setBit <<= 1);
                                }
                            }
                        }
                        if (!checkIfInsideException) break;
                        handler = ROMHelp.J9EXCEPTIONINFO_HANDLERS(exceptionData);
                        exception = new UDATA(0L);
                        while (exception.lt(exceptionData.catchCount())) {
                            if (start >= handler.startPC().intValue() && start < handler.endPC().intValue()) {
                                this.debugMergeStacks(mapData, handler.handlerPC().intValue());
                            }
                            handler = handler.add(1L);
                            exception = exception.add(1L);
                        }
                        break;
                    }
                    case 14: {
                        int target;
                        int popCount = type2 & 7;
                        if (bc == 200) {
                            int offset32 = new I32(MapHelpers.PARAM_32(bcIndex, 1)).intValue();
                            target = start + offset32;
                        } else {
                            int offset16 = new I16(MapHelpers.PARAM_16(bcIndex, 1)).intValue();
                            target = start + offset16;
                        }
                        this.debugMergeStacks(mapData, target);
                        if (popCount != 0) break;
                        if (!mapData.rootStack.isEmpty()) {
                            pc = mapData.rootStack.pop();
                            mapData.currentLocals = mapData.mapArray[pc];
                            int n = pc;
                            bytecodeMap[n] = (byte)(bytecodeMap[n] & 0xFFFFFFF7);
                            justLoadedStack = true;
                            break;
                        }
                        return 0;
                    }
                    case 15: {
                        if (!mapData.rootStack.isEmpty()) {
                            pc = mapData.rootStack.pop();
                            mapData.currentLocals = mapData.mapArray[pc];
                            int n = pc;
                            bytecodeMap[n] = (byte)(bytecodeMap[n] & 0xFFFFFFF7);
                            justLoadedStack = true;
                            break;
                        }
                        return 0;
                    }
                    case 19: {
                        int target;
                        switch (bc) {
                            case 191: {
                                if (!mapData.rootStack.isEmpty()) {
                                    pc = mapData.rootStack.pop();
                                    mapData.currentLocals = mapData.mapArray[pc];
                                    int n = pc;
                                    bytecodeMap[n] = (byte)(bytecodeMap[n] & 0xFFFFFFF7);
                                    justLoadedStack = true;
                                    break block0;
                                }
                                return 0;
                            }
                            case 170: 
                            case 171: {
                                int temp1;
                                int npairs;
                                bcIndex = U8Pointer.cast(UDATA.cast(bcIndex).add(4L).bitAnd(new UDATA(3L).bitNot()));
                                int offset = new I32(MapHelpers.PARAM_32(bcIndex, 0)).intValue();
                                bcIndex = bcIndex.add(4L);
                                target = start + offset;
                                this.debugMergeStacks(mapData, target);
                                int low = new I32(MapHelpers.PARAM_32(bcIndex, 0)).intValue();
                                bcIndex = bcIndex.add(4L);
                                if (bc == 170) {
                                    int high = new I32(MapHelpers.PARAM_32(bcIndex, 0)).intValue();
                                    bcIndex = bcIndex.add(4L);
                                    npairs = high - low + 1;
                                    temp1 = 0;
                                } else {
                                    npairs = low;
                                    temp1 = 4;
                                }
                                while (npairs > 0) {
                                    bcIndex = bcIndex.add(temp1);
                                    offset = new I32(MapHelpers.PARAM_32(bcIndex, 0)).intValue();
                                    bcIndex = bcIndex.add(4L);
                                    target = start + offset;
                                    this.debugMergeStacks(mapData, target);
                                    --npairs;
                                }
                                if (!mapData.rootStack.isEmpty()) {
                                    pc = mapData.rootStack.pop();
                                    mapData.currentLocals = mapData.mapArray[pc];
                                    int n = pc;
                                    bytecodeMap[n] = (byte)(bytecodeMap[n] & 0xFFFFFFF7);
                                    justLoadedStack = true;
                                    break block0;
                                }
                                return 0;
                            }
                        }
                    }
                }
            }
            return -1;
        }

        private void debugMergeStacks(DebugLocalMapData mapData, int target) {
            if ((mapData.bytecodeMap[target] & 4) != 0) {
                int mergeResult = mapData.mapArray[target] & mapData.currentLocals;
                if (mergeResult == mapData.mapArray[target]) {
                    return;
                }
                mapData.mapArray[target] = mergeResult;
                if ((mapData.bytecodeMap[target] & 8) != 0) {
                    return;
                }
            } else {
                mapData.mapArray[target] = mapData.currentLocals;
                int n = target;
                mapData.bytecodeMap[n] = (byte)(mapData.bytecodeMap[n] | 4);
            }
            mapData.rootStack.push(target);
            int n = target;
            mapData.bytecodeMap[n] = (byte)(mapData.bytecodeMap[n] | 8);
        }

        private int debugBuildBranchMap(DebugLocalMapData mapData) throws CorruptDataException {
            J9ExceptionInfoPointer exceptionData;
            UDATA temp;
            int pcs;
            int pc;
            U8Pointer bcStart;
            J9ROMMethodPointer romMethod = mapData.romMethod;
            byte[] bytecodeMap = mapData.bytecodeMap;
            int count = 0;
            U8Pointer bcIndex = bcStart = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(romMethod);
            U8Pointer bcEnd = bcStart.add(ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod));
            if (bcIndex.at(mapData.targetPC).eq(185L)) {
                mapData.targetPC -= 2;
            }
            bytecodeMap[mapData.targetPC] = 1;
            ++count;
            block5: while (bcIndex.lt(bcEnd)) {
                int bc = bcIndex.at(0L).intValue() & 0xFF;
                int size = PCStack.J9JavaInstructionSizeAndBranchActionTable[bc];
                switch (size >> 4) {
                    case 5: {
                        UDATA npairs;
                        int start = IDATA.cast(bcIndex.sub(UDATA.cast(bcStart))).intValue();
                        pc = start + 4 & 0xFFFFFFFC;
                        bcIndex = bcStart.add(pc);
                        int longBranch = new I32(MapHelpers.PARAM_32(bcIndex, 0)).intValue();
                        bcIndex = bcIndex.add(4L);
                        if (bytecodeMap[start + longBranch] == 0) {
                            bytecodeMap[start + longBranch] = 1;
                            ++count;
                        }
                        int low = new I32(MapHelpers.PARAM_32(bcIndex, 0)).intValue();
                        bcIndex = bcIndex.add(4L);
                        if (bc == 170) {
                            int high = new I32(MapHelpers.PARAM_32(bcIndex, 0)).intValue();
                            bcIndex = bcIndex.add(4L);
                            npairs = new UDATA(high - low + 1);
                            pcs = 0;
                        } else {
                            npairs = new UDATA(low);
                            pcs = 4;
                        }
                        temp = new UDATA(0L);
                        while (temp.lt(npairs)) {
                            bcIndex = bcIndex.add(pcs);
                            longBranch = new I32(MapHelpers.PARAM_32(bcIndex, 0)).intValue();
                            bcIndex = bcIndex.add(4L);
                            if (bytecodeMap[start + longBranch] == 0) {
                                bytecodeMap[start + longBranch] = 1;
                                ++count;
                            }
                            temp = temp.add(1L);
                        }
                        continue block5;
                    }
                    case 2: {
                        int longBranch;
                        int start;
                        if (bc == 200) {
                            start = IDATA.cast(bcIndex.sub(UDATA.cast(bcStart))).intValue();
                            if (bytecodeMap[start + (longBranch = new I32(MapHelpers.PARAM_32(bcIndex, 1)).intValue())] != 0) break;
                            bytecodeMap[start + longBranch] = 1;
                            ++count;
                            break;
                        }
                    }
                    case 1: {
                        int shortBranch = new I16(MapHelpers.PARAM_16(bcIndex, 1)).intValue();
                        int start = IDATA.cast(bcIndex.sub(UDATA.cast(bcStart))).intValue();
                        if (bytecodeMap[start + shortBranch] != 0) break;
                        bytecodeMap[start + shortBranch] = 1;
                        ++count;
                    }
                }
                bcIndex = bcIndex.add(size & 7);
            }
            if (romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo) && !(exceptionData = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(romMethod)).catchCount().eq(0L)) {
                J9ExceptionHandlerPointer handler = ROMHelp.J9EXCEPTIONINFO_HANDLERS(exceptionData);
                temp = new UDATA(0L);
                while (temp.lt(exceptionData.catchCount())) {
                    pc = handler.startPC().intValue();
                    if (pc != (pcs = handler.handlerPC().intValue())) {
                        int n = pc;
                        bytecodeMap[n] = (byte)(bytecodeMap[n] | 2);
                    }
                    if ((bytecodeMap[pcs] & 1) == 0) {
                        int n = pcs;
                        bytecodeMap[n] = (byte)(bytecodeMap[n] | 1);
                        ++count;
                    }
                    handler = handler.add(1L);
                    temp = temp.add(1L);
                }
            }
            return count;
        }
    }

    private static interface DebugLocalMapImpl {
        public int j9localmap_DebugLocalBitsForPC(J9ROMMethodPointer var1, UDATA var2, int[] var3) throws CorruptDataException;
    }

    private static class DebugLocalMapData {
        byte[] bytecodeMap;
        int[] mapArray;
        public final Stack<Integer> rootStack = new Stack();
        public int[] resultsArray;
        public J9ROMMethodPointer romMethod;
        public int targetPC;
        public int currentLocals;

        private DebugLocalMapData() {
        }
    }
}

