/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm24.j9.gc.GCArrayObjectModel;
import com.ibm.j9ddr.vm24.j9.gc.GCBase;
import com.ibm.j9ddr.vm24.j9.gc.GCMixedObjectModel;
import com.ibm.j9ddr.vm24.j9.gc.GCObjectModel_V1;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;

public abstract class GCObjectModel
extends GCBase {
    protected GCMixedObjectModel mixedObjectModel = GCMixedObjectModel.from();
    protected GCArrayObjectModel indexableObjectModel = GCArrayObjectModel.from();

    protected GCObjectModel() throws CorruptDataException {
    }

    public static GCObjectModel from() throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_OBJECT_MODEL_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCObjectModel_V1();
    }

    public abstract UDATA adjustSizeInBytes(UDATA var1);

    public abstract U32 getObjectShape(J9ObjectPointer var1) throws CorruptDataException;

    public abstract U32 getClassShape(J9ClassPointer var1) throws CorruptDataException;

    public abstract boolean isIndexable(J9ObjectPointer var1) throws CorruptDataException;

    public abstract boolean isDeadObject(J9ObjectPointer var1) throws CorruptDataException;

    public abstract boolean isSingleSlotDeadObject(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInBytesMultiSlotDeadObject(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInBytesSingleSlotDeadObject(J9ObjectPointer var1);

    public abstract UDATA getSizeInBytesDeadObject(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInBytesWithHeader(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getConsumedSizeInBytesWithHeader(J9ObjectPointer var1) throws CorruptDataException;

    public UDATA getSizeInSlotsWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.convertBytesToSlots(this.getSizeInBytesWithHeader(object));
    }

    public UDATA getConsumedSizeInSlotsWithHeader(J9ObjectPointer object) throws CorruptDataException {
        return UDATA.convertBytesToSlots(this.getConsumedSizeInBytesWithHeader(object));
    }

    public abstract U32 getAge(J9ObjectPointer var1) throws CorruptDataException;

    public abstract boolean isRemembered(J9ObjectPointer var1) throws CorruptDataException;

    public abstract boolean isOld(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getSizeInElements(J9ObjectPointer var1) throws IllegalArgumentException, CorruptDataException;

    public abstract int getObjectHashCode(J9ObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getHeaderSize(J9ObjectPointer var1) throws CorruptDataException;

    public abstract VoidPointer getElementAddress(J9IndexableObjectPointer var1, int var2, int var3) throws CorruptDataException;
}

