/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.macho.MachoDumpReader;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProcessAddressSpace;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;

public class OSXProcessAddressSpace
extends ProcessAddressSpace {
    private final MachoDumpReader reader;

    public OSXProcessAddressSpace(int pointerSizeBytes, ByteOrder byteOrder, MachoDumpReader reader) {
        super(pointerSizeBytes, byteOrder, reader);
        this.reader = reader;
    }

    @Override
    public ICore getCore() {
        return this.reader;
    }

    @Override
    public String getCommandLine() throws DataUnavailableException {
        return this.reader.getCommandLine();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OSXProcessAddressSpace)) {
            return false;
        }
        OSXProcessAddressSpace space = (OSXProcessAddressSpace)o;
        return this.reader.equals(space.reader);
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    @Override
    public Properties getEnvironmentVariables() throws CorruptDataException, DataUnavailableException {
        throw new DataUnavailableException("Can't get environment from core dump");
    }

    @Override
    public IModule getExecutable() throws CorruptDataException {
        return this.reader.getExecutable();
    }

    public List<? extends IModule> getModules() throws CorruptDataException {
        return this.reader.getModules();
    }

    @Override
    public Platform getPlatform() {
        return Platform.OSX;
    }

    @Override
    public long getProcessId() throws CorruptDataException {
        return this.reader.getProcessId();
    }

    public List<? extends IOSThread> getThreads() throws CorruptDataException {
        return this.reader.getThreads();
    }

    @Override
    public int getSignalNumber() throws DataUnavailableException {
        return this.reader.getSignalNumber();
    }

    public String readStringAt(long nameAddress) throws MemoryFault {
        long ptr = nameAddress;
        while (this.getByteAt(ptr) != 0) {
            ++ptr;
        }
        int stringLength = (int)(ptr - nameAddress);
        byte[] stringBuffer = new byte[stringLength];
        this.getBytesAt(nameAddress, stringBuffer);
        return new String(stringBuffer, StandardCharsets.US_ASCII);
    }

    IMemorySource getRangeForAddress(long address) {
        return this.memorySources.getRangeForAddress(address);
    }

    @Override
    public boolean isFailingProcess() throws DataUnavailableException {
        throw new DataUnavailableException("Not available on this platform");
    }
}

