/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.Address;
import com.ibm.j9ddr.corereaders.elf.ELF32FileReader;
import com.ibm.j9ddr.corereaders.elf.ELF64FileReader;
import com.ibm.j9ddr.corereaders.elf.ELFMemorySource;
import com.ibm.j9ddr.corereaders.elf.ELFSymbol;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.SectionHeaderEntry;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.Symbol;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public abstract class ELFFileReader {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    public static final int ELF_NOTE_HEADER_SIZE = 12;
    public static final int EI_NIDENT = 16;
    public static final byte ELFDATA2LSB = 1;
    public static final byte ELFDATA2MSB = 2;
    public static final int ELFCLASS32 = 1;
    public static final int ELFCLASS64 = 2;
    public static final int ELF_PRARGSZ = 80;
    public static final int ARCH_IA32 = 3;
    public static final int ARCH_PPC32 = 20;
    public static final int ARCH_PPC64 = 21;
    public static final int ARCH_S390 = 22;
    public static final int ARCH_ARM = 40;
    public static final int ARCH_IA64 = 50;
    public static final int ARCH_AMD64 = 62;
    public static final int ARCH_AARCH64 = 183;
    public static final int ARCH_RISCV64 = 243;
    public static final int DT_NULL = 0;
    public static final int DT_DEBUG = 21;
    public static final int DT_SONAME = 14;
    public static final int DT_STRTAB = 5;
    public static final short ET_NONE = 0;
    public static final short ET_REL = 1;
    public static final short ET_EXEC = 2;
    public static final short ET_DYN = 3;
    public static final short ET_CORE = 4;
    public static final short ET_NUM = 5;
    public static final int ET_LOOS = 65024;
    public static final int ET_HIOS = 65279;
    public static final int ET_LOPROC = 65280;
    public static final int ET_HIPROC = 65535;
    public static final int NT_PRSTATUS = 1;
    public static final int NT_PRPSINFO = 3;
    public static final int NT_AUXV = 6;
    public static final int NT_HGPRS = 768;
    public static final int AT_NULL = 0;
    public static final int AT_ENTRY = 9;
    public static final int AT_PLATFORM = 15;
    public static final int AT_HWCAP = 16;
    private long _programHeaderOffset = -1L;
    private long _sectionHeaderOffset = -1L;
    private short _programHeaderEntrySize;
    private short _programHeaderCount;
    private short _sectionHeaderEntrySize;
    private short _sectionHeaderCount;
    private short _objectType;
    private int _version;
    private int _e_flags;
    private short _machineType;
    private long baseOffset;
    private final File _file;
    private boolean _isTruncated;
    private final List<ProgramHeaderEntry> _programHeaderEntries = new LinkedList<ProgramHeaderEntry>();
    private final List<SectionHeaderEntry> _sectionHeaderEntries = new LinkedList<SectionHeaderEntry>();
    protected ImageInputStream is;
    protected String sourceName;

    protected abstract long padToWordBoundary(long var1);

    protected abstract ProgramHeaderEntry readProgramHeaderEntry() throws IOException;

    protected abstract long readElfWord() throws IOException;

    protected abstract Address readElfWordAsAddress() throws IOException;

    protected abstract List<ELFSymbol> readSymbolsAt(SectionHeaderEntry var1) throws IOException;

    protected abstract int addressSizeBits();

    protected ELFFileReader(File file, ByteOrder byteOrder) throws IOException, InvalidDumpFormatException {
        try {
            this.is = new FileImageInputStream(file);
            this.is.setByteOrder(byteOrder);
            this._file = file;
            this.sourceName = file.getAbsolutePath();
            this.baseOffset = 0L;
            this.initializeReader(this.is.length());
        }
        catch (InvalidDumpFormatException | IOException e) {
            this.close();
            throw e;
        }
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    protected ELFFileReader(ImageInputStream in, long offset, long size) throws IOException, InvalidDumpFormatException {
        this._file = null;
        this.is = in;
        this.baseOffset = offset;
        this.sourceName = "internal data stream";
        this.initializeReader(size);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    private void initializeReader(long size) throws IOException, InvalidDumpFormatException {
        try {
            this.is.seek(this.baseOffset);
            this.readHeader();
            this.readSectionHeader();
            this.readProgramHeader();
            if (this.baseOffset == 0L) {
                long maxOffset = 0L;
                for (SectionHeaderEntry section : this._sectionHeaderEntries) {
                    if (section.size == 0L) continue;
                    maxOffset = Math.max(maxOffset, section.offset + section.size - 1L);
                }
                for (ProgramHeaderEntry segment : this._programHeaderEntries) {
                    if (segment.fileSize == 0L) continue;
                    maxOffset = Math.max(maxOffset, segment.fileOffset + segment.fileSize - 1L);
                }
                if (size < 0L) {
                    this.is.seek(maxOffset);
                } else if (maxOffset >= size) {
                    this.markTruncated();
                }
            }
        }
        catch (IOException e) {
            this.markTruncated();
            throw e;
        }
    }

    public static ELFFileReader getELFFileReader(File file) throws IOException, InvalidDumpFormatException {
        try (FileImageInputStream in = new FileImageInputStream(file);){
            if (!ELFFileReader.isFormatValid(in)) {
                throw new InvalidDumpFormatException("File " + file.getAbsolutePath() + " is not an ELF file");
            }
            int bitness = in.read();
            ByteOrder byteOrder = ELFFileReader.getByteOrder(in);
            if (2 == bitness) {
                ELF64FileReader eLF64FileReader = new ELF64FileReader(file, byteOrder);
                return eLF64FileReader;
            }
            ELF32FileReader eLF32FileReader = new ELF32FileReader(file, byteOrder);
            return eLF32FileReader;
        }
    }

    public static ELFFileReader getELFFileReader(ImageInputStream in) throws IOException, InvalidDumpFormatException {
        return ELFFileReader.getELFFileReaderWithOffset(in, 0L, in.length());
    }

    public static ELFFileReader getELFFileReaderWithOffset(ImageInputStream in, long offset, long limit) throws IOException, InvalidDumpFormatException {
        in.mark();
        in.seek(offset);
        if (!ELFFileReader.isFormatValid(in)) {
            throw new InvalidDumpFormatException("The input stream is not an ELF file");
        }
        int bitness = in.read();
        ByteOrder byteOrder = ELFFileReader.getByteOrder(in);
        in.setByteOrder(byteOrder);
        in.reset();
        if (2 == bitness) {
            return new ELF64FileReader(in, offset, limit);
        }
        return new ELF32FileReader(in, offset, limit);
    }

    private static ByteOrder getByteOrder(ImageInputStream in) throws IOException {
        int endian = in.read();
        ByteOrder byteOrder = 2 == endian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        return byteOrder;
    }

    private static boolean isFormatValid(ImageInputStream in) throws IOException {
        byte[] headerData = new byte[4];
        in.readFully(headerData);
        return ELFFileReader.isELF(headerData);
    }

    public static boolean isELF(byte[] signature) {
        return 127 == signature[0] && 69 == signature[1] && 76 == signature[2] && 70 == signature[3];
    }

    private static String _nameForFileType(short type2) {
        String fileType = "Unknown";
        int typeAsInt = 0xFFFF & type2;
        if (0 == type2) {
            fileType = "No file type";
        } else if (1 == type2) {
            fileType = "Relocatable file";
        } else if (2 == type2) {
            fileType = "Executable file";
        } else if (3 == type2) {
            fileType = "Shared object file";
        } else if (4 == type2) {
            fileType = "Core file";
        } else if (5 == type2) {
            fileType = "Number of defined types";
        } else if (65024 <= typeAsInt && typeAsInt <= 65279) {
            fileType = "OS-specific (" + Integer.toHexString(typeAsInt) + ")";
        } else if (65280 <= typeAsInt && typeAsInt <= 65535) {
            fileType = "Processor-specific (" + Integer.toHexString(typeAsInt) + ")";
        }
        return fileType;
    }

    private void readHeader() throws IOException, InvalidDumpFormatException {
        byte[] signature = this.readBytes(16);
        if (!ELFFileReader.isELF(signature)) {
            throw new InvalidDumpFormatException("Missing ELF magic number");
        }
        this._objectType = this.is.readShort();
        this._machineType = this.is.readShort();
        this._version = this.is.readInt();
        this.readElfWord();
        this._programHeaderOffset = this.readElfWord();
        this._sectionHeaderOffset = this.readElfWord();
        this._e_flags = this.is.readInt();
        this.is.readShort();
        this._programHeaderEntrySize = this.is.readShort();
        this._programHeaderCount = this.is.readShort();
        this._sectionHeaderEntrySize = this.is.readShort();
        this._sectionHeaderCount = this.is.readShort();
        this.is.readShort();
    }

    private SectionHeaderEntry readSectionHeaderEntry() throws IOException {
        long name = (long)this.is.readInt() & 0xFFFFFFFFL;
        long type2 = (long)this.is.readInt() & 0xFFFFFFFFL;
        long flags = this.readElfWord();
        long address = this.readElfWord();
        long offset = this.readElfWord();
        long size = this.readElfWord();
        long link = (long)this.is.readInt() & 0xFFFFFFFFL;
        long info = (long)this.is.readInt() & 0xFFFFFFFFL;
        return new SectionHeaderEntry(name, type2, flags, address, offset, size, link, info);
    }

    private void readSectionHeader() throws IOException {
        if (this._sectionHeaderCount < 3) {
            return;
        }
        this.seek(this._sectionHeaderOffset);
        SectionHeaderEntry firstEntry = this.readSectionHeaderEntry();
        if (firstEntry.offset != 0L || firstEntry.size != 0L || firstEntry._type != 0L || firstEntry._name != 0L) {
            this.markTruncated();
            return;
        }
        this.seek(this._sectionHeaderOffset + (long)this._sectionHeaderEntrySize);
        SectionHeaderEntry secondEntry = this.readSectionHeaderEntry();
        if (secondEntry.size == 0L) {
            this.markTruncated();
            return;
        }
        this._sectionHeaderEntries.add(firstEntry);
        this._sectionHeaderEntries.add(secondEntry);
        for (int i = 2; i < this._sectionHeaderCount; ++i) {
            this.seek(this._sectionHeaderOffset + (long)(i * this._sectionHeaderEntrySize));
            SectionHeaderEntry entry = this.readSectionHeaderEntry();
            this._sectionHeaderEntries.add(entry);
        }
    }

    private void readProgramHeader() throws IOException {
        for (int i = 0; i < this._programHeaderCount; ++i) {
            this.seek(this._programHeaderOffset + (long)(i * this._programHeaderEntrySize));
            this._programHeaderEntries.add(this.readProgramHeaderEntry());
        }
    }

    void seekToAddress(long address) throws IOException {
        ProgramHeaderEntry matchedEntry = null;
        for (ProgramHeaderEntry element : this._programHeaderEntries) {
            if (!element.contains(address)) continue;
            matchedEntry = element;
            break;
        }
        if (null == matchedEntry) {
            throw new IOException("No ProgramHeaderEntry found for address");
        }
        this.seek(matchedEntry.fileOffset + (address - matchedEntry.virtualAddress));
    }

    public boolean canResolveAddress(long address) {
        for (ProgramHeaderEntry element : this._programHeaderEntries) {
            if (!element.contains(address)) continue;
            return true;
        }
        return false;
    }

    public List<? extends ISymbol> getSymbols(long baseAddress, boolean useUnallocatedSections) throws IOException {
        LinkedList<ISymbol> symbols = new LinkedList<ISymbol>();
        for (SectionHeaderEntry entry : this._sectionHeaderEntries) {
            if (!useUnallocatedSections && !entry.isAllocated() || !entry.isSymbolTable()) continue;
            symbols.addAll(this.readSymbolsFrom(entry, baseAddress));
        }
        return symbols;
    }

    public Collection<? extends IMemorySource> getMemoryRanges(long baseAddress, List<SectionHeaderEntry> sectionHeaderEntries, Map<Long, String> sectionHeaderStringTable) throws IOException {
        LinkedList<ELFMemorySource> sections = new LinkedList<ELFMemorySource>();
        if (sectionHeaderStringTable == null || sectionHeaderEntries == null) {
            return sections;
        }
        for (SectionHeaderEntry entry : sectionHeaderEntries) {
            if (!this.sectionHeaderMapsToProgramHeader(entry) || entry.isNoBits() || entry.address == 0L || entry.size == 0L) continue;
            String name = sectionHeaderStringTable.get(entry._name);
            sections.add(new ELFMemorySource(baseAddress + entry.offset, entry.size, entry.offset, this, name));
        }
        return sections;
    }

    public boolean sectionHeaderMapsToProgramHeader(SectionHeaderEntry section) {
        for (ProgramHeaderEntry phe : this._programHeaderEntries) {
            long headerBase = phe.fileOffset;
            long headerTop = phe.fileOffset + phe.fileSize;
            if (section.offset < headerBase || section.offset >= headerTop) continue;
            return true;
        }
        return false;
    }

    public Map<Long, String> getSectionHeaderStringTable() throws IOException {
        SectionHeaderEntry shstrtabEntry = null;
        for (SectionHeaderEntry entry : this._sectionHeaderEntries) {
            if (!entry.isStringTable()) continue;
            this.seek(entry.offset + entry._name);
            String peek = this.readString();
            if (peek != null) {
                if (!peek.equals(".shstrtab")) continue;
                shstrtabEntry = entry;
                continue;
            }
            logger.log(Level.FINER, "Error reading section header name. The core file is invalid and the results may unpredictable");
        }
        if (shstrtabEntry == null) {
            return null;
        }
        HashMap<Long, String> sectionHeaderStringTable = new HashMap<Long, String>();
        for (SectionHeaderEntry entry : this._sectionHeaderEntries) {
            this.seek(shstrtabEntry.offset + entry._name);
            String name = this.readString();
            sectionHeaderStringTable.put(entry._name, name);
            if (name != null) continue;
            logger.log(Level.FINER, "Error reading section header name. The core file is invalid and the results may unpredictable");
        }
        return sectionHeaderStringTable;
    }

    private List<ISymbol> readSymbolsFrom(SectionHeaderEntry entry, long baseAddress) throws IOException {
        SectionHeaderEntry stringTable;
        LinkedList<ISymbol> symbols = new LinkedList<ISymbol>();
        try {
            stringTable = this._sectionHeaderEntries.get((int)entry.link);
        }
        catch (IndexOutOfBoundsException e) {
            logger.log(Level.FINER, "Invalid link value " + entry.link + " when reading section header table of length " + this._sectionHeaderEntries.size());
            return symbols;
        }
        this.seek(stringTable.offset);
        for (ELFSymbol sym : this.readSymbolsAt(entry)) {
            if (!sym.isFunction()) continue;
            this.seek(stringTable.offset + sym.name);
            String name = this.readString();
            if (name != null) {
                if (sym.value == 0L) continue;
                if (sym.value > 0L && baseAddress > 0L || sym.value < 0L && baseAddress < 0L) {
                    if (sym.value >= baseAddress) {
                        symbols.add(new Symbol(name, sym.value));
                        continue;
                    }
                    symbols.add(new Symbol(name, baseAddress + sym.value));
                    continue;
                }
                if (sym.value < baseAddress) {
                    symbols.add(new Symbol(name, sym.value));
                    continue;
                }
                symbols.add(new Symbol(name, baseAddress + sym.value));
                continue;
            }
            logger.log(Level.FINER, "Error reading section header name. The core file is invalid and the results may unpredictable");
        }
        return symbols;
    }

    public boolean is64Bit() {
        return 64 == this.addressSizeBits();
    }

    public byte[] readBytes(int len) throws IOException {
        byte[] buffer = new byte[len];
        this.is.readFully(buffer);
        return buffer;
    }

    public short getMachineType() {
        return this._machineType;
    }

    public List<? extends ProgramHeaderEntry> getProgramHeaderEntries() {
        return Collections.unmodifiableList(this._programHeaderEntries);
    }

    public List<SectionHeaderEntry> getSectionHeaderEntries() {
        return Collections.unmodifiableList(this._sectionHeaderEntries);
    }

    public ImageInputStream getStream() throws IOException {
        if (this.is != null) {
            return this.is;
        }
        FileImageInputStream fis = new FileImageInputStream(this._file);
        return fis;
    }

    public File getFile() {
        return this._file;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("Object file type", ELFFileReader._nameForFileType(this._objectType));
        props.setProperty("Object file version", Integer.toHexString(this._version));
        props.setProperty("Processor-specific flags", Integer.toHexString(this._e_flags));
        return props;
    }

    public int readInt() throws IOException {
        return this.is.readInt();
    }

    public byte readByte() throws IOException {
        return this.is.readByte();
    }

    public void seek(long pos) throws IOException {
        try {
            this.is.seek(this.baseOffset + pos);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("Seek index out of bounds in " + this.getSourceName());
        }
    }

    public ByteOrder getByteOrder() {
        return this.is.getByteOrder();
    }

    public short readShort() throws IOException {
        return this.is.readShort();
    }

    public long readLong() throws IOException {
        return this.is.readLong();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.is.readFully(b, off, len);
    }

    public String readString() {
        try {
            byte ascii;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            while ((ascii = this.readByte()) != 0) {
                buffer.write(ascii);
            }
            return new String(buffer.toByteArray(), StandardCharsets.US_ASCII);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ProgramHeaderEntry getDynamicTableEntry() {
        for (ProgramHeaderEntry programHeaderEntry : this.getProgramHeaderEntries()) {
            if (!programHeaderEntry.isDynamic()) continue;
            return programHeaderEntry;
        }
        return null;
    }

    public boolean isExecutable() {
        return this._objectType == 2;
    }

    public boolean isTruncated() {
        return this._isTruncated;
    }

    private void markTruncated() {
        if (this.baseOffset == 0L) {
            this._isTruncated = true;
        }
    }

    public String readSONAME(ELFFileReader coreFileReader) {
        ProgramHeaderEntry dynamicTableEntry = this.getDynamicTableEntry();
        if (dynamicTableEntry == null) {
            return null;
        }
        try {
            long tag;
            long imageStart = dynamicTableEntry.virtualAddress;
            this.seekToAddress(imageStart);
            long sonameOffset = -1L;
            long strtabAddress = -1L;
            do {
                tag = this.readElfWord();
                long address = this.readElfWord();
                if (!(tag >= 0L && tag <= 33L || tag >= 0x60000000L && tag <= 0x6FFFFFFFL || tag >= 0x70000000L && tag <= Integer.MAX_VALUE)) {
                    logger.log(Level.FINER, "Error reading SONAME. Invalid tag value '0x" + Long.toHexString(tag) + "'. The core file is invalid and the results may unpredictable");
                }
                if (tag == 14L) {
                    sonameOffset = address;
                    continue;
                }
                if (tag != 5L) continue;
                strtabAddress = address;
            } while (tag != 0L);
            if (sonameOffset != -1L && strtabAddress != -1L) {
                String name;
                if (this.canResolveAddress(strtabAddress + sonameOffset)) {
                    this.seekToAddress(strtabAddress + sonameOffset);
                    name = this.readString();
                } else {
                    coreFileReader.seekToAddress(strtabAddress + sonameOffset);
                    name = coreFileReader.readString();
                }
                if (name == null || name.isEmpty()) {
                    return null;
                }
                return name;
            }
            return null;
        }
        catch (IOException e) {
            logger.info("ProgramHeaderEntry @ " + Long.toHexString(dynamicTableEntry.virtualAddress) + " does not appear point to a module with a valid SONAME tag.");
            return null;
        }
    }

    public boolean isCompatibleWith(ELFFileReader otherReader) {
        if (null == otherReader) {
            return false;
        }
        if (this.getMachineType() != otherReader.getMachineType()) {
            return false;
        }
        if (this._programHeaderCount != otherReader._programHeaderCount) {
            return false;
        }
        Iterator<? extends ProgramHeaderEntry> primaryHeaders = this.getProgramHeaderEntries().iterator();
        Iterator<? extends ProgramHeaderEntry> secondaryHeaders = otherReader.getProgramHeaderEntries().iterator();
        while (primaryHeaders.hasNext() && secondaryHeaders.hasNext()) {
            ProgramHeaderEntry primaryEntry = primaryHeaders.next();
            ProgramHeaderEntry secondaryEntry = secondaryHeaders.next();
            if (primaryEntry.virtualAddress == secondaryEntry.virtualAddress) continue;
            return false;
        }
        if (this._sectionHeaderCount != otherReader._sectionHeaderCount) {
            return false;
        }
        return this._version == otherReader._version;
    }
}

