/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.FlagsHelper;
import com.ibm.j9ddr.PointerHelper;
import com.ibm.j9ddr.StructureHelper;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.StructureTypeManager;
import com.ibm.j9ddr.tools.FlagStructureList;

public class BytecodeGenerator {
    private static final String[] knownNames = new String[]{"AOT", "Arg0EA", "INL", "JIT", "JNI"};

    public static boolean shouldUseCNameFor(String className) {
        return className.equals("J9BuildFlags");
    }

    public static String getFlagCName(String id) {
        switch (id) {
            case "EsVersionMajor": 
            case "EsVersionMajor_DEFINED": 
            case "EsVersionMinor": 
            case "EsVersionMinor_DEFINED": 
            case "JAVA_SPEC_VERSION": 
            case "JAVA_SPEC_VERSION_DEFINED": {
                return id;
            }
        }
        if (id.startsWith("J9VM_")) {
            return id;
        }
        StringBuilder cname = new StringBuilder("J9VM_");
        boolean addUnderscore = false;
        int idLength = id.length();
        int i = 0;
        block11: while (i < idLength) {
            if (addUnderscore) {
                cname.append('_');
                addUnderscore = false;
            }
            for (String knownName : knownNames) {
                int knownLength = knownName.length();
                if (!id.regionMatches(i, knownName, 0, knownLength)) continue;
                cname.append(knownName.toUpperCase());
                addUnderscore = true;
                i += knownLength;
                continue block11;
            }
            char ch = id.charAt(i);
            cname.append(Character.toUpperCase(ch));
            if (Character.isUpperCase(ch) || ++i >= idLength || !Character.isUpperCase(id.charAt(i))) continue;
            addUnderscore = true;
        }
        return cname.toString();
    }

    public static byte[] getPointerClassBytes(StructureReader reader, StructureTypeManager typeManager, StructureReader.StructureDescriptor structure, String className) {
        if (FlagStructureList.isFlagsStructure(structure.getName())) {
            return FlagsHelper.getClassBytes(structure, className);
        }
        return PointerHelper.getClassBytes(reader, typeManager, structure, className);
    }

    public static byte[] getStructureClassBytes(StructureReader.StructureDescriptor structure, String className) {
        return StructureHelper.getClassBytes(structure, className);
    }
}

