/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.Util;
import java.math.BigInteger;

public final class Message {
    private static int ptrSize;
    private int type;
    private String message;
    private String component;
    private boolean zero = false;
    private String symbol;

    public Message(int type, String message, String component, String symbol) {
        this.type = type;
        this.message = message;
        this.component = component;
        this.symbol = symbol;
    }

    protected StringBuffer processPercents(String str, byte[] buffer, int offset) {
        FormatSpec fspec = null;
        StringBuffer result = new StringBuffer();
        int index = str.indexOf("%");
        this.zero = false;
        while (index != -1 && offset < buffer.length) {
            char first;
            boolean utf8 = false;
            int dataSize = 4;
            boolean prefix0x = index > 1 ? "0x".equalsIgnoreCase(str.substring(index - 2, index)) : false;
            result.append(str.substring(0, index));
            str = str.substring(index + 1, str.length());
            if (str.charAt(0) == '-') {
                fspec = new FormatSpec(true);
                str = str.substring(1, str.length());
            }
            if (str.charAt(0) == '0') {
                this.zero = true;
                str = str.substring(1, str.length());
            }
            if (Character.isDigit(str.charAt(0))) {
                if (fspec == null) {
                    fspec = new FormatSpec();
                }
                String val = this.readDigits(str);
                fspec.width = Integer.valueOf(val);
                str = str.substring(val.length(), str.length());
            }
            if (str.charAt(0) == '.') {
                if ((str = str.substring(1, str.length())).charAt(0) == '*') {
                    utf8 = true;
                    str = str.substring(1, str.length());
                } else {
                    if (fspec == null) {
                        fspec = new FormatSpec();
                    }
                    String prec = this.readDigits(str);
                    fspec.precision = Integer.valueOf(prec);
                    str = str.substring(prec.length(), str.length());
                }
            }
            if ((first = str.charAt(0)) == 'l') {
                if (str.charAt(1) == 'l') {
                    dataSize = 8;
                    str = str.substring(2, str.length());
                } else {
                    str = str.substring(1, str.length());
                }
            } else if (first == 'I' && str.charAt(1) == '6' && str.charAt(2) == '4') {
                dataSize = 8;
                str = str.substring(3, str.length());
            } else if (first == 'h') {
                dataSize = 2;
                str = str.substring(1, str.length());
            } else if (first == 'z') {
                if (ptrSize == 8) {
                    dataSize = 8;
                }
                str = str.substring(1, str.length());
            }
            first = str.charAt(0);
            switch (first) {
                case 'p': {
                    long l = ptrSize == 4 ? Util.constructUnsignedInt(buffer, offset) : Util.constructUnsignedLong(buffer, offset).longValue();
                    offset += ptrSize;
                    if (!prefix0x) {
                        result.append("0x");
                    }
                    result.append(this.format(l, fspec, 16));
                    str = str.substring(1, str.length());
                    break;
                }
                case 's': {
                    String s;
                    if (utf8) {
                        int utf8Length = Util.constructUnsignedLong(buffer, offset, 2).intValue();
                        s = Util.constructString(buffer, offset += 2, utf8Length);
                        offset += utf8Length;
                    } else {
                        s = Util.constructString(buffer, offset);
                        offset += s.length() + 1;
                    }
                    s = Util.escapeControlCharacters(s);
                    result.append(this.format(s, fspec));
                    str = str.substring(1, str.length());
                    break;
                }
                case 'd': 
                case 'i': {
                    long l = dataSize == 4 ? Util.constructUnsignedInt(buffer, offset) : Util.constructUnsignedLong(buffer, offset).longValue();
                    offset += dataSize;
                    result.append(this.format(l, fspec));
                    str = str.substring(1, str.length());
                    break;
                }
                case 'u': {
                    long l;
                    if (dataSize == 4) {
                        l = Util.constructUnsignedInt(buffer, offset);
                        l &= 0xFFFFFFFFL;
                    } else {
                        l = Util.constructUnsignedLong(buffer, offset).longValue();
                    }
                    offset += dataSize;
                    result.append(this.format(l, fspec));
                    str = str.substring(1, str.length());
                    break;
                }
                case 'f': 
                case 'g': {
                    long l = Util.constructUnsignedLong(buffer, offset).longValue();
                    offset += 8;
                    result.append(this.format(Double.longBitsToDouble(l), fspec));
                    str = str.substring(1, str.length());
                    break;
                }
                case 'X': 
                case 'x': {
                    long l;
                    if (dataSize == 4) {
                        l = Util.constructUnsignedInt(buffer, offset);
                        l &= 0xFFFFFFFFL;
                    } else {
                        l = Util.constructUnsignedLong(buffer, offset).longValue();
                    }
                    offset += dataSize;
                    if (!prefix0x) {
                        result.append("0x");
                    }
                    result.append(this.format(l, fspec, 16));
                    str = str.substring(1, str.length());
                    break;
                }
                case 'c': {
                    String s = Util.constructString(buffer, offset, 1);
                    ++offset;
                    s = Util.escapeControlCharacters(s);
                    result.append(this.format(s, fspec));
                    str = str.substring(1, str.length());
                    break;
                }
                case '%': {
                    result.append("%");
                    str = str.substring(1, str.length());
                    break;
                }
                case ' ': 
                case '#': 
                case '+': {
                    TraceFormat.outStream.println("Used a printf flag not supported " + first);
                    str = str.substring(1, str.length());
                    break;
                }
                default: {
                    TraceFormat.outStream.println("error percent directive looked like => " + str);
                    str = str.substring(1, str.length());
                }
            }
            fspec = null;
            this.zero = false;
            index = str.indexOf("%");
        }
        result.append(str);
        return result;
    }

    protected StringBuffer skipPercents(String str, byte[] buffer, int offset) {
        StringBuffer result = new StringBuffer();
        int index = str.indexOf("%");
        while (index != -1 && offset < buffer.length) {
            char first;
            result.append(str.substring(0, index));
            str = str.substring(index + 1, str.length());
            if (str.charAt(0) == '-' || str.charAt(0) == '0') {
                str = str.substring(1, str.length());
            }
            if (Character.isDigit(str.charAt(0))) {
                String val = this.readDigits(str);
                str = str.substring(val.length(), str.length());
            }
            if (str.charAt(0) == '.') {
                if ((str = str.substring(1, str.length())).charAt(0) == '*') {
                    str = str.substring(1, str.length());
                } else {
                    String prec = this.readDigits(str);
                    str = str.substring(prec.length(), str.length());
                }
            }
            if ((first = str.charAt(0)) == 'l') {
                str = str.substring(str.charAt(1) == 'l' ? 2 : 1, str.length());
            } else if (first == 'I' && str.charAt(1) == '6' && str.charAt(2) == '4') {
                str = str.substring(3, str.length());
            } else if (first == 'h') {
                str = str.substring(1, str.length());
            } else if (first == 'z') {
                str = str.substring(1, str.length());
            }
            first = str.charAt(0);
            switch (first) {
                case 'X': 
                case 'c': 
                case 'd': 
                case 'f': 
                case 'i': 
                case 'p': 
                case 's': 
                case 'u': 
                case 'x': {
                    str = str.substring(1, str.length());
                    result.append("???");
                    break;
                }
                case '%': {
                    result.append("%");
                    str = str.substring(1, str.length());
                    break;
                }
                case ' ': 
                case '#': 
                case '+': {
                    TraceFormat.outStream.println("Used a printf flag not supported " + first);
                    str = str.substring(1, str.length());
                    break;
                }
                default: {
                    TraceFormat.outStream.println("Error: percent directive looked like => " + str);
                    str = str.substring(1, str.length());
                }
            }
            index = str.indexOf("%");
        }
        result.append(str);
        return result;
    }

    protected static void setPointerSize() {
        ptrSize = Integer.valueOf(Util.getProperty("POINTER_SIZE"));
    }

    private String readDigits(String str) {
        char[] digits = new char[10];
        int index = 0;
        while (Character.isDigit(str.charAt(index))) {
            if (index >= digits.length) continue;
            digits[index] = str.charAt(index);
            ++index;
        }
        return new String(digits, 0, index);
    }

    private StringBuffer format(BigInteger val, FormatSpec spec) {
        StringBuffer str = new StringBuffer(val.toString());
        if (spec != null) {
            if (spec.precision != null) {
                Util.padBuffer(str, spec.precision, '0');
            }
            if (spec.width != null) {
                Util.padBuffer(str, spec.width, ' ', spec.leftJustified);
            }
        }
        return str;
    }

    private StringBuffer format(long val, FormatSpec spec) {
        return this.format(val, spec, 10);
    }

    private StringBuffer format(long val, FormatSpec spec, int radix) {
        StringBuffer str = new StringBuffer(Long.toString(val, radix));
        if (spec != null) {
            if (spec.precision != null) {
                Util.padBuffer(str, spec.precision, '0');
            }
            if (spec.width != null) {
                Util.padBuffer(str, spec.width, this.zero && !spec.leftJustified ? (char)'0' : ' ', spec.leftJustified);
            }
        }
        return str;
    }

    private StringBuffer format(float val, FormatSpec spec) {
        StringBuffer str = new StringBuffer(Float.toString(val));
        if (spec != null && spec.width != null) {
            Util.padBuffer(str, spec.width, ' ', spec.leftJustified);
        }
        return str;
    }

    private StringBuffer format(double val, FormatSpec spec) {
        StringBuffer str = new StringBuffer(Double.toString(val));
        if (spec != null && spec.width != null) {
            Util.padBuffer(str, spec.width, ' ', spec.leftJustified);
        }
        return str;
    }

    private StringBuffer format(String str, FormatSpec spec) {
        StringBuffer result = new StringBuffer();
        if (spec != null) {
            int x;
            if (spec.precision != null && (x = spec.precision.intValue()) < str.length()) {
                str = str.substring(0, x);
            }
            result.append(str);
            if (spec.width != null) {
                Util.padBuffer(result, spec.width, ' ', spec.leftJustified);
            }
        } else {
            result.append(str);
        }
        return result;
    }

    public String getMessage(byte[] buffer, int offset, int end) {
        String prefix;
        String string = prefix = TraceArgs.symbolic ? this.symbol + " " : "";
        if (offset < end) {
            if (this.component == "ApplicationTrace") {
                offset += 4;
            }
            return prefix + this.processPercents(this.message, buffer, offset).toString();
        }
        return prefix + this.skipPercents(this.message, buffer, offset).toString();
    }

    protected String getComponent() {
        return this.component;
    }

    protected int getType() {
        return this.type;
    }

    protected String getFormattingTemplate() {
        return this.message;
    }

    class FormatSpec {
        protected Integer width;
        protected Integer precision;
        protected boolean leftJustified = false;

        public FormatSpec(boolean left) {
            this.leftJustified = left;
        }

        public FormatSpec() {
            this(false);
        }

        public String toString() {
            return "FormatSpec w: " + this.width + " p:" + this.precision + " just: " + this.leftJustified;
        }
    }
}

