/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.LastReq;
import com.ibm.security.krb5.internal.PAData;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.TicketFlags;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class EncKDCRepPart {
    public EncryptionKey key;
    public LastReq lastReq;
    public int nonce;
    public KerberosTime keyExpiration;
    public TicketFlags flags;
    public KerberosTime authtime;
    public KerberosTime starttime;
    public KerberosTime endtime;
    public KerberosTime renewTill;
    public PrincipalName sname;
    public HostAddresses caddr;
    public PAData[] pAData;
    public int msgType;

    public EncKDCRepPart(EncryptionKey encryptionKey, LastReq lastReq, int n2, KerberosTime kerberosTime, TicketFlags ticketFlags, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, KerberosTime kerberosTime5, PrincipalName principalName, HostAddresses hostAddresses, PAData[] pADataArray, int n3) {
        this.key = encryptionKey;
        this.lastReq = lastReq;
        this.nonce = n2;
        this.keyExpiration = kerberosTime;
        this.flags = ticketFlags;
        this.authtime = kerberosTime2;
        this.starttime = kerberosTime3;
        this.endtime = kerberosTime4;
        this.renewTill = kerberosTime5;
        this.sname = principalName;
        this.caddr = hostAddresses;
        this.pAData = pADataArray;
        this.msgType = n3;
    }

    public EncKDCRepPart() {
    }

    public EncKDCRepPart(byte[] byArray, int n2) throws Asn1Exception, IOException, RealmException {
        this.a(new DerValue(byArray), n2);
    }

    public EncKDCRepPart(DerValue derValue, int n2) throws Asn1Exception, IOException, RealmException {
        this.a(derValue, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void a(DerValue derValue, int n2) throws Asn1Exception, IOException, RealmException {
        this.msgType = derValue.getTag() & 0x1F;
        if (this.msgType != 25 && this.msgType != 26) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.key = EncryptionKey.parse(derValue2.getData(), (byte)0, false);
        this.lastReq = LastReq.parse(derValue2.getData(), (byte)1, false);
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 2) throw new Asn1Exception(906);
        this.nonce = derValue3.getData().getBigInteger().intValue();
        this.keyExpiration = KerberosTime.parse(derValue2.getData(), (byte)3, true);
        this.flags = TicketFlags.parse(derValue2.getData(), (byte)4, false);
        this.authtime = KerberosTime.parse(derValue2.getData(), (byte)5, false);
        this.starttime = KerberosTime.parse(derValue2.getData(), (byte)6, true);
        this.endtime = KerberosTime.parse(derValue2.getData(), (byte)7, false);
        this.renewTill = KerberosTime.parse(derValue2.getData(), (byte)8, true);
        Realm realm = Realm.parse(derValue2.getData(), (byte)9, false);
        this.sname = PrincipalName.parse(derValue2.getData(), (byte)10, false, realm);
        if (derValue2.getData().available() > 0) {
            this.caddr = HostAddresses.parse(derValue2.getData(), (byte)11, true);
        }
        if (derValue2.getData().available() <= 0) return;
        this.pAData = PAData.parseSequence(derValue2.getData(), (byte)12, true);
    }

    public byte[] asn1Encode(int n2) throws Asn1Exception, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2;
        DerOutputStream derOutputStream3;
        block17: {
            derOutputStream3 = new DerOutputStream();
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.key.asn1Encode());
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.lastReq.asn1Encode());
            derOutputStream3.putInteger(BigInteger.valueOf(this.nonce));
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream3);
            if (this.keyExpiration != null) {
                derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.keyExpiration.asn1Encode());
            }
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.flags.asn1Encode());
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.authtime.asn1Encode());
            if (this.starttime != null) {
                derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.starttime.asn1Encode());
            }
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)7), this.endtime.asn1Encode());
            if (this.renewTill != null) {
                derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)8), this.renewTill.asn1Encode());
            }
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.sname.getRealm().asn1Encode());
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.sname.asn1Encode());
            if (this.caddr != null) {
                derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)11), this.caddr.asn1Encode());
            }
            if (this.pAData == null || this.pAData.length <= 0) break block17;
            derOutputStream3 = new DerOutputStream();
            for (int i2 = 0; i2 < this.pAData.length; ++i2) {
                derOutputStream3.write(this.pAData[i2].asn1Encode());
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream3);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)12), derOutputStream);
        }
        derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        derOutputStream = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)64, (boolean)true, (byte)((byte)this.msgType)), derOutputStream3);
        return derOutputStream.toByteArray();
    }
}

