/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.HostAddress;
import com.ibm.security.krb5.internal.ccache.b;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;

public class HostAddresses
implements Cloneable {
    public HostAddress[] addresses;
    private static final String[] z;

    public HostAddresses(HostAddress[] hostAddressArray) {
        this.addresses = hostAddressArray;
    }

    public HostAddresses() throws UnknownHostException {
        this.addresses = new HostAddress[1];
        this.addresses[0] = new HostAddress();
    }

    private HostAddresses(int n2) {
    }

    public HostAddresses(PrincipalName principalName) throws UnknownHostException, KrbException {
        String[] stringArray;
        block7: {
            stringArray = principalName.getNameStrings();
            if (principalName.getNameType() == 3 && stringArray.length >= 2) break block7;
            throw new KrbException(z[0], null);
        }
        String string = stringArray[1];
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            try {
                hostAddressArray[i2] = new HostAddress(inetAddressArray[i2]);
                continue;
            }
            catch (Exception exception) {
                if (!Krb5Debug.on(9)) continue;
                Krb5Debug krb5Debug = new Krb5Debug(z[1] + Thread.currentThread().getName() + z[3]);
                krb5Debug.out(9, z[2]);
            }
        }
        this.addresses = hostAddressArray;
    }

    public Object clone() {
        HostAddresses hostAddresses = new HostAddresses(0);
        if (this.addresses != null) {
            hostAddresses.addresses = new HostAddress[this.addresses.length];
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                hostAddresses.addresses[i2] = (HostAddress)this.addresses[i2].clone();
            }
        }
        return hostAddresses;
    }

    public boolean inList(HostAddress hostAddress) {
        if (this.addresses != null) {
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                if (!this.addresses[i2].equals(hostAddress)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(HostAddresses hostAddresses) {
        if (this.addresses == null && hostAddresses.addresses != null || this.addresses != null && hostAddresses.addresses == null) {
            return false;
        }
        if (this.addresses != null && hostAddresses.addresses != null) {
            if (this.addresses.length != hostAddresses.addresses.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                if (this.addresses[i2].equals(hostAddresses.addresses[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public HostAddresses(DerValue derValue) throws Asn1Exception, IOException {
        Vector<HostAddress> vector = new Vector<HostAddress>();
        DerValue derValue2 = null;
        while (derValue.getData().available() > 0) {
            derValue2 = derValue.getData().getDerValue();
            vector.addElement(new HostAddress(derValue2));
        }
        if (vector.size() > 0) {
            this.addresses = new HostAddress[vector.size()];
            vector.copyInto(this.addresses);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2;
        block5: {
            derOutputStream2 = new DerOutputStream();
            derOutputStream = new DerOutputStream();
            if (this.addresses == null || this.addresses.length <= 0) break block5;
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                derOutputStream2.write(this.addresses[i2].asn1Encode());
            }
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HostAddresses parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddresses(derValue2);
    }

    public void writeAddrs(b b2) throws IOException {
        b2.a(this.addresses.length);
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            b2.b(this.addresses[i2].addrType);
            b2.a(this.addresses[i2].address.length);
            b2.write(this.addresses[i2].address, 0, this.addresses[i2].address.length);
        }
    }

    public InetAddress[] getInetAddresses() {
        block11: {
            if (this.addresses != null && this.addresses.length != 0) break block11;
            return null;
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(this.addresses.length);
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            try {
                if (this.addresses[i2].addrType != 2 && this.addresses[i2].addrType != 24) continue;
                arrayList.add(this.addresses[i2].getInetAddress());
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        InetAddress[] inetAddressArray = new InetAddress[arrayList.size()];
        return arrayList.toArray(inetAddressArray);
    }

    public static HostAddresses getLocalAddresses() throws IOException {
        Object object;
        String string = null;
        InetAddress[] inetAddressArray = null;
        HostAddresses hostAddresses = null;
        try {
            object = InetAddress.getLocalHost();
            string = ((InetAddress)object).getHostName();
            inetAddressArray = InetAddress.getAllByName(string);
            HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
            for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
                hostAddressArray[i2] = new HostAddress(inetAddressArray[i2]);
            }
            hostAddresses = new HostAddresses(hostAddressArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        if (Krb5Debug.on(9)) {
            object = new Krb5Debug(z[6] + Thread.currentThread().getName() + z[7]);
            ((Krb5Debug)object).out(9, z[4] + string + z[5]);
            for (int i3 = 0; i3 < inetAddressArray.length; ++i3) {
                ((Krb5Debug)object).out(9, z[8] + inetAddressArray[i3]);
            }
        }
        return hostAddresses;
    }

    public HostAddresses(InetAddress[] inetAddressArray) {
        if (inetAddressArray == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new HostAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            this.addresses[i2] = new HostAddress(inetAddressArray[i2]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\u001c>pt$ 'mD$\u001c0iB";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block20;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 82;
                                break;
                            }
                            case 1: {
                                n9 = 81;
                                break;
                            }
                            case 2: {
                                n9 = 4;
                                break;
                            }
                            case 3: {
                                n9 = 39;
                                break;
                            }
                            default: {
                                n9 = 65;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u001a>wS\u000065vB2!4w\u001d";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "lo:\u0007\u00023$cO5r<eK'=#iB%r9kT5r0`C37\"w";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "hq";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "lo:\u0007\n 3OC\"\u00004u\u0007-=2eKa35`U$!\"aTa4>v\u0007";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "r0vB{r";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001a>wS\u000065vB2!4w\u001d";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "hq";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "XX";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

