/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.jgss.i18n.PropertyResource;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.KdcErrException;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.crypto.KrbCryptoException;
import com.ibm.security.krb5.internal.crypto.a;
import com.ibm.security.krb5.internal.crypto.o;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class Checksum {
    private int a;
    private byte[] b;
    public static final int CKSUMTYPE_NULL = 0;
    public static final int CKSUMTYPE_CRC32 = 1;
    public static final int CKSUMTYPE_RSA_MD4 = 2;
    public static final int CKSUMTYPE_RSA_MD4_DES = 3;
    public static final int CKSUMTYPE_DES_MAC = 4;
    public static final int CKSUMTYPE_DES_MAC_K = 5;
    public static final int CKSUMTYPE_RSA_MD4_DES_K = 6;
    public static final int CKSUMTYPE_RSA_MD5 = 7;
    public static final int CKSUMTYPE_RSA_MD5_DES = 8;
    public static final int CKSUMTYPE_HMAC_SHA1_DES3 = 12;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES128 = 15;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES256 = 16;
    public static final int CKSUMTYPE_HMAC_MD5 = -138;
    public static int CKSUMTYPE_DEFAULT;
    public static int SAFECKSUMTYPE_DEFAULT;
    private static final int[] c;
    private static final String[] z;

    public static void initStatic() {
        block13: {
            Krb5Debug krb5Debug;
            Config config;
            String string;
            block11: {
                string = null;
                config = null;
                try {
                    block10: {
                        config = Config.getInstance();
                        string = config.get(z[7], z[0]);
                        if (string == null) break block10;
                        CKSUMTYPE_DEFAULT = Config.getType(string);
                        break block11;
                    }
                    CKSUMTYPE_DEFAULT = -1;
                }
                catch (Exception exception) {
                    if (Krb5Debug.on(5)) {
                        krb5Debug = new Krb5Debug(z[9] + Thread.currentThread().getName() + z[3]);
                        krb5Debug.out(9, z[8]);
                        exception.printStackTrace();
                    }
                    CKSUMTYPE_DEFAULT = -1;
                }
            }
            try {
                block12: {
                    string = config.get(z[4], z[5]);
                    if (string == null) break block12;
                    SAFECKSUMTYPE_DEFAULT = Config.getType(string);
                    break block13;
                }
                SAFECKSUMTYPE_DEFAULT = -1;
            }
            catch (Exception exception) {
                if (Krb5Debug.on(5)) {
                    krb5Debug = new Krb5Debug(z[1] + Thread.currentThread().getName() + z[2]);
                    krb5Debug.out(9, z[6]);
                    exception.printStackTrace();
                }
                SAFECKSUMTYPE_DEFAULT = -1;
            }
        }
    }

    public Checksum(byte[] byArray, int n2) {
        this.a = n2;
        this.b = byArray;
    }

    public boolean verifyAnyChecksum(byte[] byArray, EncryptionKey encryptionKey, int n2) throws KdcErrException, KrbCryptoException {
        return com.ibm.security.krb5.internal.crypto.a.a(this.a).a(byArray, byArray.length, encryptionKey.getBytes(), this.b, n2);
    }

    public Checksum(int n2, byte[] byArray, EncryptionKey encryptionKey, int n3) throws KdcErrException, KrbApErrException, KrbCryptoException {
        this.a = n2 == -1 ? o.a(encryptionKey.getEType()).checksumType() : n2;
        this.b = com.ibm.security.krb5.internal.crypto.a.a(this.a).a(byArray, byArray.length, encryptionKey.getBytes(), n3);
    }

    public boolean verifyKeyedChecksum(byte[] byArray, EncryptionKey encryptionKey, int n2) throws KdcErrException, KrbApErrException, KrbCryptoException {
        a a2 = com.ibm.security.krb5.internal.crypto.a.a(this.a);
        if (!a2.c()) {
            throw new KrbApErrException(50);
        }
        return a2.a(byArray, byArray.length, encryptionKey.getBytes(), this.b, n2);
    }

    boolean a(Checksum checksum) throws KdcErrException {
        if (this.a != checksum.a) {
            return false;
        }
        return com.ibm.security.krb5.internal.crypto.a.a(this.b, checksum.b);
    }

    public Checksum(DerValue derValue) throws Asn1Exception, IOException {
        block11: {
            block10: {
                DerValue derValue2;
                block9: {
                    block8: {
                        if (derValue.getTag() != 48) {
                            throw new Asn1Exception(906);
                        }
                        derValue2 = derValue.getData().getDerValue();
                        if ((derValue2.getTag() & 0x1F) != 0) break block8;
                        this.a = derValue2.getData().getBigInteger().intValue();
                        break block9;
                    }
                    throw new Asn1Exception(906);
                }
                derValue2 = derValue.getData().getDerValue();
                if ((derValue2.getTag() & 0x1F) != 1) break block10;
                this.b = derValue2.getData().getOctetString();
                break block11;
            }
            throw new Asn1Exception(906);
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.a));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.b);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Checksum parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new Checksum(derValue2);
    }

    public final byte[] getBytes() {
        return this.b;
    }

    public final int getType() {
        return this.a;
    }

    public static boolean isSupportedType(int n2) {
        return Arrays.binarySearch(c, n2) >= 0;
    }

    public static boolean isValidType(int n2) {
        return Checksum.isSupportedType(n2);
    }

    public boolean isCollisionProofType() {
        return Checksum.isCollisionProofType(this.a);
    }

    public static boolean isCollisionProofType(int n2) {
        return n2 == 4 || n2 == 5 || n2 == 7 || n2 == 8 || n2 == 12 || n2 == 15 || n2 == 16 || n2 == -138;
    }

    public static int[] getSupportedTypes() {
        return c;
    }

    public boolean isSafeType() {
        return Checksum.isSafeType(this.a);
    }

    public static boolean isSafeType(int n2) {
        return n2 == 4 || n2 == 5 || n2 == 8 || n2 == 12 || n2 == 15 || n2 == 16 || n2 == -138;
    }

    public static int stringToChecksumType(String string) throws Exception {
        if (string == null) {
            I18NException.throwException(z[19]);
        }
        if (string.equalsIgnoreCase(z[10])) {
            return 12;
        }
        if (string.equalsIgnoreCase(z[11])) {
            return 8;
        }
        if (string.equalsIgnoreCase(z[16])) {
            return 7;
        }
        if (string.equalsIgnoreCase(z[13])) {
            return -138;
        }
        if (string.equalsIgnoreCase(z[12])) {
            return 4;
        }
        if (string.equalsIgnoreCase(z[15])) {
            return 5;
        }
        if (string.equalsIgnoreCase(z[20])) {
            return 15;
        }
        if (string.equalsIgnoreCase(z[17])) {
            return 16;
        }
        if (string.equalsIgnoreCase(z[18])) {
            return 1;
        }
        I18NException.throwException(z[14], new String[]{string});
        return -999;
    }

    public static String checksumTypeToString(int n2) {
        switch (n2) {
            case 12: {
                return z[24];
            }
            case 8: {
                return z[25];
            }
            case 7: {
                return z[28];
            }
            case -138: {
                return z[23];
            }
            case 4: {
                return z[26];
            }
            case 5: {
                return z[30];
            }
            case 15: {
                return z[27];
            }
            case 16: {
                return z[29];
            }
            case 1: {
                return z[22];
            }
        }
        PropertyResource propertyResource = PropertyResource.getExceptionInstance();
        return propertyResource.getFormattedString(z[21], new Integer[]{new Integer(n2)});
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[31];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "q${9\u0002y5B;\u001fp\"v+\u0002x";
        int n3 = -1;
        block38: while (true) {
            char[] cArray;
            block43: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block42: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block42;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block43;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 21;
                                break;
                            }
                            case 1: {
                                n9 = 65;
                                break;
                            }
                            case 2: {
                                n9 = 29;
                                break;
                            }
                            case 3: {
                                n9 = 88;
                                break;
                            }
                            default: {
                                n9 = 119;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "V)x;\u001cf4pb";
                    n3 = 0;
                    continue block38;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "/a";
                    n3 = 1;
                    continue block38;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "/a";
                    n3 = 2;
                    continue block38;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "y(\u007f<\u0012s h4\u0003f";
                    n3 = 3;
                    continue block38;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "f {=(v)x;\u001cf4p\u0007\u0003l1x";
                    n3 = 4;
                    continue block38;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "P9~=\u0007a(r6W|/=?\u0012a5t6\u001052|>\u00125%x>\u0016`-ix\u0014}$~3\u0004`,=.\u0016y4xx\u0011g.px\u0003}$=;\u0018{'t?\u0002g i1\u0018{aN=\u0003a(s?W5\u000frx\u0004t'xx\u0013p'|-\u001baa~0\u0012v*n-\u001a52x,Y";
                    n3 = 5;
                    continue block38;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "y(\u007f<\u0012s h4\u0003f";
                    n3 = 6;
                    continue block38;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "P9~=\u0007a(r6W|/=?\u0012a5t6\u00105%x>\u0016`-ix\u0014}$~3\u0004`,=.\u0016y4xx\u0011g.px\u0003}$=;\u0018{'t?\u0002g i1\u0018{aS7Wq${9\u0002y5=;\u001fp\"v+\u0002xan=\u0003;";
                    n3 = 7;
                    continue block38;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "V)x;\u001cf4pb";
                    n3 = 8;
                    continue block38;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "},|;Zf)|iZq$nk";
                    n3 = 9;
                    continue block38;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "g2|u\u001aqt0<\u0012f";
                    n3 = 10;
                    continue block38;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "q$nu\u001at\"";
                    n3 = 11;
                    continue block38;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "},|;Zx%(";
                    n3 = 12;
                    continue block38;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "W y\u001b\u001cf4p\f\u000ee$N,\u0005|/z";
                    n3 = 13;
                    continue block38;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "q$nu\u001at\"03";
                    n3 = 14;
                    continue block38;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "g2|u\u001aqt";
                    n3 = 15;
                    continue block38;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "},|;Zf)|iZ,w09\u0012fs(n";
                    n3 = 16;
                    continue block38;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "V\u0013^kE";
                    n3 = 17;
                    continue block38;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "[4q44~2h5#l1x\u000b\u0003g(s?";
                    n3 = 18;
                    continue block38;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "},|;Zf)|iZ,w09\u0012fp/`";
                    n3 = 19;
                    continue block38;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "W y\u001b\u001cf4p\f\u000ee$";
                    n3 = 20;
                    continue block38;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "v3~kE";
                    n3 = 21;
                    continue block38;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "},|;Zx%(";
                    n3 = 22;
                    continue block38;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "},|;Zf)|iZq$nk";
                    n3 = 23;
                    continue block38;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "g2|u\u001aqt0<\u0012f";
                    n3 = 24;
                    continue block38;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "q$nu\u001at\"";
                    n3 = 25;
                    continue block38;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "},|;Zf)|iZ,w09\u0012fp/`";
                    n3 = 26;
                    continue block38;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "g2|u\u001aqt";
                    n3 = 27;
                    continue block38;
                }
                case 27: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 29;
                    string2 = "},|;Zf)|iZ,w09\u0012fs(n";
                    n3 = 28;
                    continue block38;
                }
                case 28: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 30;
                    string2 = "q$nu\u001at\"03";
                    n3 = 29;
                    continue block38;
                }
                case 29: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        c = new int[]{7, 8, 4, 5, 1, -138, 12, 15, 16};
        Checksum.initStatic();
    }
}

