/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools.impl;

import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.IPipe;
import com.ibm.jvm.dtfjview.tools.Tool;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import com.ibm.jvm.dtfjview.tools.utils.BlockPostmatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.BlockPrematchHandle;
import com.ibm.jvm.dtfjview.tools.utils.IMatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.IPostmatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.IPrematchHandle;
import com.ibm.jvm.dtfjview.tools.utils.MatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.MaxLinesPostmatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.MaxLinesPrematchHandle;
import com.ibm.jvm.dtfjview.tools.utils.OutputStreamModifier;
import com.ibm.jvm.dtfjview.tools.utils.RegExprMatchHandle;
import com.ibm.jvm.dtfjview.tools.utils.StringModifier;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GrepTool
extends Tool
implements IPipe {
    public static final String COMMAND = "grep";
    public static final String COMMAND_NEGATE = "grep-";
    public static final String ARGUMENT_DESCRIPTION = "[options] <pattern>";
    public static final String HELP_DESCRIPTION = "to be used after the pipeline to show lines which match a pattern.";
    public static final String USAGE = "grep\t[options] <pattern>\tto be used after the pipeline to show lines which match a pattern.\n     Options :\n          -i : Ignore case.\n          -r, -G, --regex : Use regular expression as defined in the Java documentation of class java.utils.regex.Pattern.\n          -b, --block : show the block of lines when at least one of the lines matches the pattern.  Block of lines are separated by empty lines.\n          -A <NUM>, +<NUM> : Show at most <NUM> lines after the matching line.\n          -B <NUM>, -<NUM> : show at most <NUM> lines after the matching line.\n          -C <NUM>, +-<NUM> : show at most <NUM> lines before and after the matching line.\n          -v, --invert-match : to be used with command grep to show the lines which does not match the pattern, equivalent to using command grep-.\n          -F, --fixed-strings : to treat character '*' not as a wide card. This option can not be used together with -r, -G or --regex.\n     Pattern : \n           Character '*' in a pattern will be treated as a wild card unless option -F or --fixed-strings is used.\n           If a pattern contains any spaces, enclose the pattern in a pair of double quotation marks.\n           If a pattern contains any double quotation marks, enclose the pattern in a pair of single quotation marks.\n           The pattern can be in the following format to show lines which match any of the sub-patterns:\n                    \"[<pattern1>|<pattern2>|...|<patternN>]\"\n               This format has to start with \"[ and ends with ]\" and use character '|' as the sub-pattern separator.\n               No quotation marks and character '|' are allowed in any sub-patterns.\n               Spaces are allowed in the middle of a sub-patterns, but leading and trailing spaces will be trimmed.\n               This format only works when option -r, -G, and --regex are not used.\n     Use command grep- to show lines which do not match the pattern.";

    @Override
    public boolean accept(String command, String[] args) {
        return command.equalsIgnoreCase(COMMAND) || command.equalsIgnoreCase(COMMAND_NEGATE);
    }

    @Override
    public void process(String command, String[] args, PrintStream out) throws CommandException {
        Attributes attributes = null;
        try {
            attributes = this.readAttributes(command, args, command.equalsIgnoreCase(COMMAND_NEGATE), out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (attributes == null) {
            out.println(USAGE);
            return;
        }
        IPrematchHandle prematchHandle = null;
        prematchHandle = attributes.matchBlock ? new BlockPrematchHandle() : new MaxLinesPrematchHandle(attributes.maxPreviousLines);
        IMatchHandle matchHandle = null;
        matchHandle = attributes.useRegularExpression ? new RegExprMatchHandle(attributes.normalStringsToGrep, attributes.caseInsensitive, attributes.negate) : new MatchHandle(attributes.normalStringsToGrep, attributes.caseInsensitive, attributes.negate, attributes.isFixedString);
        IPostmatchHandle postmatchHandle = null;
        postmatchHandle = attributes.matchBlock ? new BlockPostmatchHandle() : new MaxLinesPostmatchHandle(attributes.maxNextLines);
        ToolsRegistry.process(attributes.nextCommand, attributes.nextCommandArgs, new PrintStream(new OutputStreamModifier(out, new StringModifier(prematchHandle, matchHandle, postmatchHandle))));
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println(USAGE);
    }

    @Override
    public String getCommandName() {
        return COMMAND;
    }

    @Override
    public String getArgumentDescription() {
        return ARGUMENT_DESCRIPTION;
    }

    @Override
    public String getHelpDescription() {
        return HELP_DESCRIPTION;
    }

    private Attributes readAttributes(String command, String[] args, boolean negate, PrintStream out) {
        if (2 > args.length) {
            return null;
        }
        boolean useRegularExpression = false;
        boolean caseInsensitive = false;
        String stringToGrep = null;
        String nextCommand = null;
        ArrayList<String> nextCommandArgs = new ArrayList<String>();
        int maxPreviousLines = 0;
        int maxNextLines = 0;
        boolean matchBlock = false;
        boolean dashVUsed = false;
        boolean isFixedString = false;
        boolean grepOptionsEnded = false;
        for (int i = 0; i < args.length; ++i) {
            if (!grepOptionsEnded && args[i].equals("-i")) {
                caseInsensitive = true;
                continue;
            }
            if (!grepOptionsEnded && (args[i].equals("-b") || args[i].equals("--block"))) {
                matchBlock = true;
                continue;
            }
            if (!grepOptionsEnded && (args[i].equals("-r") || args[i].equals("-G") || args[i].equals("--regex"))) {
                useRegularExpression = true;
                continue;
            }
            if (!grepOptionsEnded && (args[i].equals("-F") || args[i].equals("--fixed-strings"))) {
                isFixedString = true;
                continue;
            }
            if (!grepOptionsEnded && args[i].equals("-C")) {
                if (i < args.length - 1) {
                    ++i;
                    try {
                        maxNextLines = maxPreviousLines = Integer.parseInt(args[i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        out.println("Option -C is not followed by a number; instead it is followed by token " + args[i]);
                        return null;
                    }
                }
                out.println("Option -C is not followed by a number.");
                return null;
            }
            if (!grepOptionsEnded && (args[i].startsWith("-+") || args[i].startsWith("+-"))) {
                try {
                    maxNextLines = maxPreviousLines = Integer.parseInt(args[i].substring(2));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (!grepOptionsEnded && args[i].equals("-A")) {
                if (i < args.length - 1) {
                    ++i;
                    try {
                        maxNextLines = Integer.parseInt(args[i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        out.println("Option -A is not followed by a number; instead it is followed by token " + args[i]);
                        return null;
                    }
                }
                out.println("Option -A is not followed by a number.");
                return null;
            }
            if (!grepOptionsEnded && args[i].startsWith("+")) {
                try {
                    maxNextLines = Integer.parseInt(args[i].substring(1));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (!grepOptionsEnded && (args[i].equals("-v") || args[i].equalsIgnoreCase("--invert-match"))) {
                dashVUsed = true;
                continue;
            }
            if (!grepOptionsEnded && args[i].equals("-B")) {
                if (i < args.length - 1) {
                    ++i;
                    try {
                        maxPreviousLines = Integer.parseInt(args[i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        out.println("Option -B is not followed by a number; instead it is followed by token " + args[i]);
                        return null;
                    }
                }
                out.println("Option -B is not followed by a number.");
                return null;
            }
            if (!grepOptionsEnded && args[i].startsWith("-")) {
                try {
                    maxPreviousLines = Integer.parseInt(args[i].substring(1));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            grepOptionsEnded = true;
            if (stringToGrep == null) {
                stringToGrep = args[i];
                continue;
            }
            if (nextCommand == null) {
                nextCommand = args[i];
                continue;
            }
            nextCommandArgs.add(args[i]);
        }
        if (null == stringToGrep || null == nextCommand) {
            out.println("The grep/grep- command can only be used after the pipeline.");
            return null;
        }
        if (dashVUsed) {
            if (command.equalsIgnoreCase(COMMAND_NEGATE)) {
                out.println("Option -v can not be used with command grep-.");
                return null;
            }
            if (!negate) {
                negate = true;
            }
        }
        if (isFixedString && useRegularExpression) {
            out.println("Option -F and --fixed-strings can not be used with option -r, -G, or --regex.");
            return null;
        }
        return new Attributes(negate, useRegularExpression, caseInsensitive, stringToGrep, nextCommand, nextCommandArgs.toArray(new String[nextCommandArgs.size()]), maxPreviousLines, maxNextLines, matchBlock, isFixedString);
    }

    private class Attributes {
        public boolean negate = false;
        public boolean useRegularExpression = false;
        public boolean caseInsensitive = false;
        public String nextCommand = null;
        public String[] nextCommandArgs = null;
        public int maxPreviousLines = 0;
        public int maxNextLines = 0;
        public boolean matchBlock = false;
        public boolean isFixedString = false;
        public String[] normalStringsToGrep = null;

        public Attributes(boolean negate, boolean useRegularExpression, boolean caseInsensitive, String stringToGrep, String nextCommand, String[] nextCommandArgs, int maxPreviousLines, int maxNextLines, boolean matchBlock, boolean isFixedString) {
            this.negate = negate;
            this.useRegularExpression = useRegularExpression;
            this.caseInsensitive = caseInsensitive;
            this.nextCommand = nextCommand;
            this.nextCommandArgs = nextCommandArgs;
            this.maxPreviousLines = maxPreviousLines;
            this.maxNextLines = maxNextLines;
            this.matchBlock = matchBlock;
            this.isFixedString = isFixedString;
            this.normalStringsToGrep = this.extractNormalStringsToGrep(stringToGrep);
        }

        private String[] extractNormalStringsToGrep(String s) {
            if (this.useRegularExpression || !s.startsWith("[") || !s.endsWith("]")) {
                return new String[]{s};
            }
            ArrayList<String> ls = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(s.substring(1, s.length() - 1), "|");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.trim().length() <= 0) continue;
                ls.add(t.trim());
            }
            return ls.toArray(new String[ls.size()]);
        }
    }
}

