/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.setcommands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.FileOutputChannel;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import com.ibm.jvm.dtfjview.tools.ToolsRegistryOutputChannels;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Calendar;

@DTFJPlugin(version="1.*", runtime=false, image=false)
public class SetLoggingCommand
extends BaseJdmpviewCommand {
    public static final String LOG_STATE_OVERWRITE = "set_logging_overwrite";
    public static final String LOG_STATE_LOGGING = "set_logging";
    public static final String LOG_STATE_FILE = "current_logging_file";
    private static final String CMD = "set logging";
    private static final String SUBCMD_ON = "on";
    private static final String SUBCMD_OFF = "off";
    private static final String SUBCMD_FILE = "file";
    private static final String SUBCMD_OVERWRITE = "overwrite";
    private boolean isOverwriteEnabled = false;
    private boolean isLoggingEnabled = false;
    private File logFile = null;
    private IOutputChannel fileChannel = null;

    public SetLoggingCommand() {
        this.addCommand(CMD, "", "configures several logging-related parameters, starts/stops logging");
        for (SubCommand sub : SubCommand.values()) {
            this.addSubCommand(CMD, sub.name, sub.params, sub.help);
        }
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        if (args.length == 0) {
            out.println("\"set logging\" requires at least one parameter");
            this.printDetailedHelp(out);
            return;
        }
        this.restoreState();
        try {
            SubCommand cmd = SubCommand.valueOf(args[0]);
            block1 : switch (cmd) {
                case on: 
                case off: {
                    if (args.length != 1) {
                        out.println("\"set logging " + cmd.name + "\" does not take any additional parameters");
                        return;
                    }
                    boolean enabled = cmd.equals((Object)SubCommand.on);
                    this.setLogging(enabled);
                    break;
                }
                case file: {
                    switch (args.length) {
                        case 3: {
                            if (args[2].equalsIgnoreCase(SUBCMD_OVERWRITE)) {
                                this.setOverwrite(true);
                            } else {
                                out.println("\"set logging file\" takes exactly one parameter, the filename to log entries to");
                                return;
                            }
                        }
                        case 2: {
                            this.setLogFile(args[1]);
                            this.setLogging(true);
                            break block1;
                        }
                    }
                    out.println("\"set logging file\" takes exactly one parameter, the filename to log entries to");
                    break;
                }
                case overwrite: {
                    if (args.length != 2) {
                        out.println("\"set logging overwrite\" takes exactly one parameter, either \"on\" or \"off\"");
                        return;
                    }
                    this.setOverwrite(this.parseBoolean(args[1]));
                    break;
                }
                default: {
                    out.println("\"" + args[0] + "\" is not a valid parameter for the \"set logging\" command");
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            out.println("\"" + args[0] + "\" is not a valid parameter for the \"set logging\" command");
        }
    }

    private void restoreState() {
        this.isOverwriteEnabled = this.parseBoolean(this.ctx.getProperties().get(LOG_STATE_OVERWRITE));
        this.isLoggingEnabled = this.parseBoolean(this.ctx.getProperties().get(LOG_STATE_LOGGING));
        String file = (String)this.ctx.getProperties().get(LOG_STATE_FILE);
        if (file != null) {
            this.logFile = Utils.absPath(this.ctx.getProperties(), file);
        }
    }

    private boolean parseBoolean(Object obj) {
        if (obj == null) {
            return false;
        }
        String value = obj.toString().trim();
        if (value.equalsIgnoreCase(SUBCMD_ON)) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    private void setOverwrite(boolean enabled) {
        if (!(this.isOverwriteEnabled ^ enabled)) {
            this.out.println("Command ignored : overwriting already has this setting");
            return;
        }
        String state = enabled ? SUBCMD_ON : SUBCMD_OFF;
        this.isOverwriteEnabled = enabled;
        this.ctx.getProperties().put(LOG_STATE_OVERWRITE, state);
        this.out.println("overwriting of log file option changed to \"" + state + "\"");
    }

    private void setLogging(boolean enabled) {
        if (!(this.isLoggingEnabled ^ enabled)) {
            this.out.println("Command ignored : logging already has this setting");
            return;
        }
        if (enabled) {
            if (this.logFile == null) {
                this.setDefaultLogFile();
            }
            if (!this.isLogFileValid()) {
                return;
            }
            this.openLogFile();
            this.ctx.getProperties().put(LOG_STATE_LOGGING, SUBCMD_ON);
        } else {
            this.closeLogFile();
            this.ctx.getProperties().put(LOG_STATE_LOGGING, SUBCMD_OFF);
        }
        this.isLoggingEnabled = enabled;
    }

    private boolean isLogFileValid() {
        if (this.logFile.exists()) {
            if (this.logFile.isDirectory()) {
                this.out.println("Cannot write to " + this.logFile.getPath() + " as it is a directory");
                return false;
            }
            if (this.isOverwriteEnabled) {
                this.out.println("Specified log file already exists, overwriting");
                if (!this.logFile.delete()) {
                    this.out.println("Failed to delete existing log file");
                    return false;
                }
            } else {
                this.out.println("Specified log file already exists, either\n1) set logging file <new file>\n2) set logging overwrite on");
                return false;
            }
        }
        return true;
    }

    private void setDefaultLogFile() {
        Calendar cal = Calendar.getInstance();
        String filename = String.format("jdmpview.%1$tY%1$tm%1$td.%1$tH%1$tM%1$tS.txt", cal);
        this.out.println("log file not specified; using default log file " + filename);
        this.out.println("to change this type 'set logging off' then specify a file with 'set logging file <log file>'");
        this.setLogFile(filename);
    }

    private void setLogFile(String filename) {
        if (null != this.logFile && this.isLoggingEnabled) {
            this.setLogging(false);
        }
        if (filename == null) {
            this.ctx.getProperties().remove(LOG_STATE_FILE);
        } else {
            File test = new File(filename);
            if (test.isAbsolute()) {
                this.logFile = new File(filename);
            } else {
                File pwd = (File)this.ctx.getProperties().get("pwd");
                this.logFile = new File(pwd.getPath() + File.separator + filename);
            }
            this.ctx.getProperties().put(LOG_STATE_FILE, this.logFile.getAbsolutePath());
        }
    }

    private void openLogFile() {
        FileWriter f;
        try {
            f = new FileWriter(this.logFile, false);
        }
        catch (IOException e) {
            Object f2 = null;
            this.out.println("IOException encountered while opening file \"" + this.logFile.getAbsolutePath() + "\"; make sure the file can be written to");
            return;
        }
        this.fileChannel = new FileOutputChannel(f, this.logFile);
        ToolsRegistryOutputChannels.addChannel(this.fileChannel);
        this.out.println("logging turned on; outputting to \"" + this.logFile.getAbsolutePath() + "\"");
    }

    private void closeLogFile() {
        ToolsRegistryOutputChannels.removeChannel(this.fileChannel);
        this.out.println("logging turned off; was logging to \"" + this.logFile + "\"");
        this.logFile = null;
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("configures several logging-related parameters, starts/stops logging\n\nparameters: [on|off], file <filename>, overwrite [on|off]\n- [on|off]           - turns logging on or off (default: off)\n- file <filename>    - sets the file to log to; this will be relative to the directory returned by the \"pwd\" command unless an absolute path is specified; if the file is set while logging is on, the change will take effect the next time logging is started (default: <not set>)\n- overwrite [on|off] - turns overwriting of the specified log file on or off (off means that the log file will be appended to); if this is on, the log file will be cleared every time \"set logging on\" is run (default: off)\n");
    }

    private static enum SubCommand {
        on("on", "", "turn on logging"),
        off("off", "", "turn off logging"),
        file("file", "", "turn on logging"),
        overwrite("overwrite", "", "controls the overwriting of log files");

        private final String name;
        private final String params;
        private final String help;

        private SubCommand(String name, String params, String help) {
            this.name = name;
            this.params = params;
            this.help = help;
        }
    }
}

