/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

public class StateToString {
    private static int JVMTI_THREAD_STATE_ALIVE = 1;
    private static int JVMTI_THREAD_STATE_TERMINATED = 2;
    private static int JVMTI_THREAD_STATE_RUNNABLE = 4;
    private static int JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static int JVMTI_THREAD_STATE_WAITING = 128;
    private static int JVMTI_THREAD_STATE_WAITING_INDEFINITELY = 16;
    private static int JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT = 32;
    private static int JVMTI_THREAD_STATE_SLEEPING = 64;
    private static int JVMTI_THREAD_STATE_IN_OBJECT_WAIT = 256;
    private static int JVMTI_THREAD_STATE_PARKED = 512;
    private static int JVMTI_THREAD_STATE_SUSPENDED = 0x100000;
    private static int JVMTI_THREAD_STATE_INTERRUPTED = 0x200000;
    private static int JVMTI_THREAD_STATE_IN_NATIVE = 0x400000;
    private static int JVMTI_THREAD_STATE_VENDOR_1 = 0x10000000;
    private static int JVMTI_THREAD_STATE_VENDOR_2 = 0x20000000;
    private static int JVMTI_THREAD_STATE_VENDOR_3 = 0x40000000;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_MASK = JVMTI_THREAD_STATE_TERMINATED | JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_RUNNABLE | JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER | JVMTI_THREAD_STATE_WAITING | JVMTI_THREAD_STATE_WAITING_INDEFINITELY | JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_NEW = 0;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_TERMINATED = JVMTI_THREAD_STATE_TERMINATED;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_RUNNABLE = JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_RUNNABLE;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_BLOCKED = JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_WAITING = JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_WAITING | JVMTI_THREAD_STATE_WAITING_INDEFINITELY;
    private static int JVMTI_JAVA_LANG_THREAD_STATE_TIMED_WAITING = JVMTI_THREAD_STATE_ALIVE | JVMTI_THREAD_STATE_WAITING | JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT;

    public static String getJVMTIStateString(int state) {
        String retval = "";
        if (0 == state) {
            return "<new or terminated> ";
        }
        if ((state & JVMTI_THREAD_STATE_ALIVE) == JVMTI_THREAD_STATE_ALIVE) {
            retval = retval + "ALIVE ";
        }
        if ((state & JVMTI_THREAD_STATE_TERMINATED) == JVMTI_THREAD_STATE_TERMINATED) {
            retval = retval + "TERMINATED ";
        }
        if ((state & JVMTI_THREAD_STATE_RUNNABLE) == JVMTI_THREAD_STATE_RUNNABLE) {
            retval = retval + "RUNNABLE ";
        }
        if ((state & JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER) == JVMTI_THREAD_STATE_BLOCKED_ON_MONITOR_ENTER) {
            retval = retval + "BLOCKED_ON_MONITOR_ENTER ";
        }
        if ((state & JVMTI_THREAD_STATE_WAITING) == JVMTI_THREAD_STATE_WAITING) {
            retval = retval + "WAITING ";
        }
        if ((state & JVMTI_THREAD_STATE_WAITING_INDEFINITELY) == JVMTI_THREAD_STATE_WAITING_INDEFINITELY) {
            retval = retval + "WAITING_INDEFINITELY ";
        }
        if ((state & JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT) == JVMTI_THREAD_STATE_WAITING_WITH_TIMEOUT) {
            retval = retval + "WAITING_WITH_TIMEOUT ";
        }
        if ((state & JVMTI_THREAD_STATE_SLEEPING) == JVMTI_THREAD_STATE_SLEEPING) {
            retval = retval + "SLEEPING ";
        }
        if ((state & JVMTI_THREAD_STATE_IN_OBJECT_WAIT) == JVMTI_THREAD_STATE_IN_OBJECT_WAIT) {
            retval = retval + "IN_OBJECT_WAIT ";
        }
        if ((state & JVMTI_THREAD_STATE_PARKED) == JVMTI_THREAD_STATE_PARKED) {
            retval = retval + "PARKED ";
        }
        if ((state & JVMTI_THREAD_STATE_SUSPENDED) == JVMTI_THREAD_STATE_SUSPENDED) {
            retval = retval + "SUSPENDED ";
        }
        if ((state & JVMTI_THREAD_STATE_INTERRUPTED) == JVMTI_THREAD_STATE_INTERRUPTED) {
            retval = retval + "INTERRUPTED ";
        }
        if ((state & JVMTI_THREAD_STATE_IN_NATIVE) == JVMTI_THREAD_STATE_IN_NATIVE) {
            retval = retval + "IN_NATIVE ";
        }
        if ((state & JVMTI_THREAD_STATE_VENDOR_1) == JVMTI_THREAD_STATE_VENDOR_1) {
            retval = retval + "VENDOR_1 ";
        }
        if ((state & JVMTI_THREAD_STATE_VENDOR_2) == JVMTI_THREAD_STATE_VENDOR_2) {
            retval = retval + "VENDOR_2 ";
        }
        if ((state & JVMTI_THREAD_STATE_VENDOR_3) == JVMTI_THREAD_STATE_VENDOR_3) {
            retval = retval + "VENDOR_3 ";
        }
        if (retval.equals("")) {
            retval = "<no matching state> ";
        }
        return retval;
    }

    public static String getThreadStateString(int state) {
        String retval = "";
        if ((state &= JVMTI_JAVA_LANG_THREAD_STATE_MASK) == JVMTI_JAVA_LANG_THREAD_STATE_NEW) {
            return "NEW ";
        }
        if ((state & JVMTI_JAVA_LANG_THREAD_STATE_TERMINATED) == JVMTI_JAVA_LANG_THREAD_STATE_TERMINATED) {
            retval = retval + "TERMINATED ";
        }
        if ((state & JVMTI_JAVA_LANG_THREAD_STATE_RUNNABLE) == JVMTI_JAVA_LANG_THREAD_STATE_RUNNABLE) {
            retval = retval + "RUNNABLE ";
        }
        if ((state & JVMTI_JAVA_LANG_THREAD_STATE_BLOCKED) == JVMTI_JAVA_LANG_THREAD_STATE_BLOCKED) {
            retval = retval + "BLOCKED ";
        }
        if ((state & JVMTI_JAVA_LANG_THREAD_STATE_WAITING) == JVMTI_JAVA_LANG_THREAD_STATE_WAITING) {
            retval = retval + "WAITING ";
        }
        if ((state & JVMTI_JAVA_LANG_THREAD_STATE_TIMED_WAITING) == JVMTI_JAVA_LANG_THREAD_STATE_TIMED_WAITING) {
            retval = retval + "TIMED_WAITING ";
        }
        if (retval.equals("")) {
            retval = "<no matching state> ";
        }
        return retval;
    }
}

