/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;

public class ClassOutput {
    public static void printStaticFields(JavaClass jc, PrintStream out) {
        String className;
        try {
            if (jc.isArray()) {
                return;
            }
        }
        catch (CorruptDataException cde) {
            out.print("\t  <can't determine if class is array; assuming it's not>\n\n");
        }
        try {
            className = jc.getName();
        }
        catch (CorruptDataException cde) {
            className = null;
        }
        boolean found = false;
        Iterator itField = jc.getDeclaredFields();
        while (itField.hasNext()) {
            boolean isStatic;
            JavaField jf = (JavaField)itField.next();
            try {
                isStatic = Modifier.isStatic(jf.getModifiers());
            }
            catch (CorruptDataException e) {
                out.print("\t   <error while getting modifier for field \"");
                try {
                    out.print(jf.getName());
                }
                catch (CorruptDataException d) {
                    out.print(Exceptions.getCorruptDataExceptionString());
                }
                out.print("\", " + Exceptions.getCorruptDataExceptionString() + ">");
                isStatic = false;
            }
            if (!isStatic) continue;
            if (!found) {
                out.print("\t  static fields for \"" + className + "\"\n");
            }
            found = true;
            ClassOutput.printStaticFieldData(jf, out);
        }
        if (found) {
            out.print("\n");
        } else {
            out.print("\t  \"" + className + "\" has no static fields\n\n");
        }
    }

    public static void printNonStaticFields(JavaClass jc, PrintStream out) {
        String className;
        try {
            if (jc.isArray()) {
                return;
            }
        }
        catch (CorruptDataException cde) {
            out.print("\t  <can't determine if class is array; assuming it's not>\n\n");
        }
        try {
            className = jc.getName();
        }
        catch (CorruptDataException cde) {
            className = null;
        }
        boolean found = false;
        Iterator itField = jc.getDeclaredFields();
        while (itField.hasNext()) {
            boolean isStatic;
            JavaField jf = (JavaField)itField.next();
            try {
                isStatic = Modifier.isStatic(jf.getModifiers());
            }
            catch (CorruptDataException e) {
                out.print("\t   <error while getting modifier for field \"");
                try {
                    out.print(jf.getName());
                }
                catch (CorruptDataException d) {
                    out.print(Exceptions.getCorruptDataExceptionString());
                }
                out.print("\", " + Exceptions.getCorruptDataExceptionString() + ">");
                isStatic = false;
            }
            if (isStatic) continue;
            if (!found) {
                out.print("\t  non-static fields for \"" + className + "\"\n");
            }
            found = true;
            ClassOutput.printNonStaticFieldData(null, jf, out);
        }
        if (found) {
            out.print("\n");
        } else {
            out.print("\t  \"" + className + "\" has no non-static fields\n\n");
        }
    }

    public static void printFields(JavaObject jo, JavaClass jc, JavaRuntime jr, PrintStream out) {
        boolean array;
        try {
            array = jo.isArray();
        }
        catch (CorruptDataException e) {
            out.print("\t   <cannot determine if above object is array (" + Exceptions.getCorruptDataExceptionString() + "); we will assume it is not an array>\n");
            array = false;
        }
        if (array) {
            int arraySize;
            String componentType;
            try {
                componentType = jc.getComponentType().getName();
            }
            catch (CorruptDataException e) {
                out.print("\t   <cannot determine what type of array this is (" + Exceptions.getCorruptDataExceptionString() + ")>\n");
                return;
            }
            try {
                arraySize = jo.getArraySize();
            }
            catch (CorruptDataException e) {
                out.print("\t   <cannot determine the size of the array (" + Exceptions.getCorruptDataExceptionString() + ")>\n");
                return;
            }
            Object[] dst = null;
            dst = componentType.equals("boolean") ? new boolean[arraySize] : (componentType.equals("byte") ? (Object[])new byte[arraySize] : (componentType.equals("char") ? (Object[])new char[arraySize] : (componentType.equals("short") ? (Object[])new short[arraySize] : (componentType.equals("int") ? (Object[])new int[arraySize] : (componentType.equals("long") ? (Object[])new long[arraySize] : (componentType.equals("float") ? (Object[])new float[arraySize] : (componentType.equals("double") ? (Object[])new double[arraySize] : (Object[])new JavaObject[arraySize])))))));
            try {
                jo.arraycopy(0, (Object)dst, 0, arraySize);
            }
            catch (CorruptDataException e) {
                out.print("\t   <cannot copy data from the array (" + Exceptions.getCorruptDataExceptionString() + ")>\n");
                return;
            }
            catch (MemoryAccessException e) {
                out.print("\t   <cannot copy data from the array (" + Exceptions.getMemoryAccessExceptionString() + ")>\n");
                return;
            }
            catch (UnsupportedOperationException e) {
                out.print("\t    This is an array of size " + arraySize + " elements\n");
                return;
            }
            for (int i = 0; i < arraySize; ++i) {
                out.print("\t   " + i + ":\t");
                if (componentType.equals("boolean")) {
                    out.print(Utils.getVal(dst[i]));
                } else if (componentType.equals("byte")) {
                    out.print(Utils.getVal(((byte[])dst)[i]));
                } else if (componentType.equals("char")) {
                    out.print(Utils.getVal(Character.valueOf(((char[])dst)[i])));
                } else if (componentType.equals("short")) {
                    out.print(Utils.getVal(((short[])dst)[i]));
                } else if (componentType.equals("int")) {
                    out.print(Utils.getVal(((int[])dst)[i]));
                } else if (componentType.equals("long")) {
                    out.print(Utils.getVal(((long[])dst)[i]));
                } else if (componentType.equals("float")) {
                    out.print(Utils.getVal(Float.valueOf(((float[])dst)[i])));
                } else if (componentType.equals("double")) {
                    out.print(Utils.getVal(((double[])dst)[i]));
                } else {
                    out.print(Utils.getVal(((JavaObject[])dst)[i]));
                }
                out.print("\n");
            }
        } else {
            JavaClass initialJC = jc;
            ArrayList<JavaClass> classList = new ArrayList<JavaClass>();
            while (jc != null) {
                classList.add(jc);
                try {
                    jc = jc.getSuperclass();
                }
                catch (CorruptDataException d) {
                    jc = null;
                }
            }
            for (int i = classList.size() - 1; i >= 0; --i) {
                jc = (JavaClass)classList.get(i);
                Iterator itField = jc.getDeclaredFields();
                if (itField.hasNext()) {
                    if (jc.equals((Object)initialJC)) {
                        out.print("\t   declared fields:\n");
                    } else {
                        out.print("\t   fields inherited from \"");
                        try {
                            out.print(jc.getName() + "\":\n");
                        }
                        catch (CorruptDataException d) {
                            out.print(Exceptions.getCorruptDataExceptionString());
                        }
                    }
                }
                while (itField.hasNext()) {
                    boolean isStatic;
                    JavaField jf = (JavaField)itField.next();
                    try {
                        isStatic = Modifier.isStatic(jf.getModifiers());
                    }
                    catch (CorruptDataException e) {
                        out.print("\t   <error while getting modifier for field \"");
                        try {
                            out.print(jf.getName());
                        }
                        catch (CorruptDataException d) {
                            out.print(Exceptions.getCorruptDataExceptionString());
                        }
                        out.print("\", " + Exceptions.getCorruptDataExceptionString() + ">");
                        isStatic = true;
                    }
                    if (isStatic) continue;
                    ClassOutput.printNonStaticFieldData(jo, jf, out);
                }
            }
        }
        out.print("\n");
    }

    private static void printStaticFieldData(JavaField jf, PrintStream out) {
        ClassOutput.printFieldData(null, jf, out, true);
    }

    private static void printNonStaticFieldData(JavaObject jo, JavaField jf, PrintStream out) {
        ClassOutput.printFieldData(jo, jf, out, false);
    }

    private static void printFieldData(JavaObject jo, JavaField jf, PrintStream out, boolean isStatic) {
        String signature;
        out.print("\t    ");
        try {
            String modifierString = Utils.getFieldModifierString(jf);
            out.print(modifierString);
        }
        catch (CorruptDataException e) {
            out.print(Exceptions.getCorruptDataExceptionString());
        }
        try {
            signature = jf.getSignature();
        }
        catch (CorruptDataException e) {
            out.print(Exceptions.getCorruptDataExceptionString());
            signature = null;
        }
        if (null != signature) {
            String name = Utils.getSignatureName(signature);
            if (null == name) {
                out.print("<unknown>");
            } else {
                out.print(name);
            }
        }
        out.print(" ");
        try {
            out.print(jf.getName());
        }
        catch (CorruptDataException e) {
            out.print(Exceptions.getCorruptDataExceptionString());
        }
        if (isStatic || null != jo) {
            out.print(" = ");
            out.print(Utils.getVal(jo, jf));
        }
        out.print("\n");
    }

    public static void printMethods(Iterator methods, PrintStream out) {
        while (methods.hasNext()) {
            JavaMethod jMethod = (JavaMethod)methods.next();
            try {
                String signature;
                out.print("Bytecode range(s): ");
                Iterator imageSections = jMethod.getBytecodeSections();
                boolean firstSectionPassed = false;
                while (imageSections.hasNext()) {
                    ImageSection is = (ImageSection)imageSections.next();
                    long baseAddress = is.getBaseAddress().getAddress();
                    long endAddress = baseAddress + is.getSize();
                    if (firstSectionPassed) {
                        out.print(", ");
                    }
                    out.print(Long.toHexString(baseAddress) + " -- " + Long.toHexString(endAddress));
                    firstSectionPassed = true;
                }
                out.print(":  ");
                try {
                    out.print(Utils.getMethodModifierString(jMethod));
                }
                catch (CorruptDataException e) {
                    out.print(Exceptions.getCorruptDataExceptionString());
                }
                try {
                    signature = jMethod.getSignature();
                }
                catch (CorruptDataException e) {
                    out.print(Exceptions.getCorruptDataExceptionString());
                    signature = null;
                }
                if (null != signature) {
                    String name = Utils.getReturnValueName(signature);
                    if (null == name) {
                        out.print("<unknown>");
                    } else {
                        out.print(name);
                    }
                }
                out.print(" ");
                out.print(jMethod.getName());
                if (null != signature) {
                    String name = Utils.getMethodSignatureName(signature);
                    if (null == name) {
                        out.print("<unknown>");
                    } else {
                        out.print(name);
                    }
                }
                out.print("\n");
            }
            catch (CorruptDataException cde) {
                out.print("N/A (CorruptDataException occurred)");
            }
        }
    }

    public static String printRuntimeClassAndLoader(JavaClass jc, PrintStream out) {
        String classLoaderClass;
        String classLoaderInfo;
        String cdeInfo = "N/A (CorruptDataException occurred)";
        try {
            JavaClassLoader jClassLoader = jc.getClassLoader();
            classLoaderInfo = "0x" + Long.toHexString(jClassLoader.getObject().getID().getAddress());
            classLoaderClass = jClassLoader.getObject().getJavaClass().getName();
        }
        catch (CorruptDataException cde) {
            classLoaderInfo = null;
            classLoaderClass = cdeInfo;
        }
        String spaces = "    ";
        out.print(spaces);
        out.print("Class ID = 0x" + Long.toHexString(jc.getID().getAddress()));
        out.print(spaces);
        out.print("Class Loader " + classLoaderClass + "(" + classLoaderInfo + ")");
        out.print("\n");
        return classLoaderInfo;
    }
}

