/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Arrays;

@DTFJPlugin(version="1.*", runtime=false)
public class HexdumpCommand
extends BaseJdmpviewCommand {
    public HexdumpCommand() {
        this.addCommand("hexdump", "<hex address> [<bytes_to_print>]", "outputs a section of memory in hexadecimal, ASCII and EBCDIC");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        this.doCommand(args);
    }

    public void doCommand(String[] args) {
        ImageAddressSpace imageAddressSpace = this.ctx.getAddressSpace();
        if (null == imageAddressSpace) {
            this.out.println("Could not find an address space which contains a process in this core file");
            return;
        }
        if (args.length == 0) {
            this.out.println("\"hexdump\" requires at least an address parameter");
            return;
        }
        Long longAddress = Utils.longFromString(args[0]);
        if (null == longAddress) {
            this.out.println("Specified address is invalid: " + args[0]);
            return;
        }
        long address = longAddress;
        int numBytesToPrint = 256;
        if (args.length > 1) {
            try {
                numBytesToPrint = Integer.decode(args[1]);
            }
            catch (NumberFormatException e) {
                this.out.println("Specified length is invalid: " + args[1]);
                return;
            }
        }
        boolean is_zOSdump = false;
        try {
            is_zOSdump = this.ctx.getImage().getSystemType().toLowerCase().contains("z/os");
        }
        catch (CorruptDataException | DataUnavailable throwable) {
            // empty catch block
        }
        ImagePointer imagePointer = imageAddressSpace.getPointer(address);
        StringBuilder lineBuffer = new StringBuilder();
        char[] asciiBlock = new char[16];
        char[] ebcdicBlock = new char[16];
        this.out.println();
        for (int byteOffset = 0; byteOffset < numBytesToPrint; ++byteOffset) {
            try {
                int lineOffset = byteOffset % 16;
                if (0 == lineOffset) {
                    lineBuffer.append(Long.toHexString(address + (long)byteOffset));
                    lineBuffer.append(':');
                }
                int byteValue = imagePointer.getByteAt((long)byteOffset) & 0xFF;
                if (0 == lineOffset % 4) {
                    lineBuffer.append(' ');
                }
                lineBuffer.append(String.format("%02x", byteValue));
                asciiBlock[lineOffset] = "................................ !\"#$%&'()*+'-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~.................................................................................................................................".charAt(byteValue);
                if (is_zOSdump) {
                    ebcdicBlock[lineOffset] = "................................................................ ...........<(+|&.........!$*);.-/.........,%_>?.........`:#@'=\".abcdefghi.......jklmnopqr.......~stuvwxyz......^..........[]...{ABCDEFGHI......}JKLMNOPQR......\\.STUVWXYZ......0123456789......".charAt(byteValue);
                }
                if (15 != lineOffset) continue;
                lineBuffer.append("  |");
                lineBuffer.append(asciiBlock);
                lineBuffer.append('|');
                if (is_zOSdump) {
                    lineBuffer.append(" |");
                    lineBuffer.append(ebcdicBlock);
                    lineBuffer.append('|');
                }
                this.out.println(lineBuffer.toString());
                lineBuffer.setLength(0);
                continue;
            }
            catch (CorruptDataException e) {
                this.out.println("Dump data is corrupted");
                return;
            }
            catch (MemoryAccessException e) {
                this.out.println("Address not in memory - 0x" + Long.toHexString(address + (long)byteOffset));
                return;
            }
        }
        int lineOffset = numBytesToPrint % 16;
        if (0 != lineOffset) {
            for (int offset = lineOffset; offset < 16; ++offset) {
                if (0 == offset % 4) {
                    lineBuffer.append(' ');
                }
                lineBuffer.append("  ");
            }
            Arrays.fill(asciiBlock, lineOffset, 16, ' ');
            lineBuffer.append("  |");
            lineBuffer.append(asciiBlock);
            lineBuffer.append('|');
            if (is_zOSdump) {
                Arrays.fill(ebcdicBlock, lineOffset, 16, ' ');
                lineBuffer.append(" |");
                lineBuffer.append(ebcdicBlock);
                lineBuffer.append('|');
            }
            this.out.println(lineBuffer.toString());
        }
        this.out.println();
        this.ctx.getProperties().put("currentMemPtrAddress", (Object)address);
        this.ctx.getProperties().put("currentNumBytes", (Object)numBytesToPrint);
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.format("outputs a section of memory in hexadecimal, ASCII and EBCDIC%n%nparameters: <hex_address> [<bytes_to_print>]%n%noutputs <bytes_to_print> (default 256) bytes of memory contents starting from <hex_address>%nEBCDIC output is also provided for z/OS dumps%n", new Object[0]);
    }
}

