/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.IDTFJContext;
import com.ibm.java.diagnostics.utils.commands.BaseCommand;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.jvm.dtfjview.commands.ExceptionHandler;
import java.io.PrintStream;
import java.util.logging.Logger;

public abstract class BaseJdmpviewCommand
extends BaseCommand {
    private static final String CMD_HELP = "help";
    private static final String CMD_QMARK = "?";
    private static final String HEX_PREFIX = "0x";
    protected PrintStream out = null;
    protected IDTFJContext ctx = null;
    protected Logger logger = Logger.getLogger("com.ibm.jvm.dtfjview.logger.command");
    protected String hexfmt = "0x%016x";

    public abstract void printDetailedHelp(PrintStream var1);

    public final boolean initCommand(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (!(context instanceof IDTFJContext)) {
            throw new CommandException("This command works within a DTFJ context, the supplied context was an instance of " + context.getClass().getName());
        }
        this.out = out;
        this.ctx = (IDTFJContext)context;
        if (this.ctx.getProcess() != null) {
            this.hexfmt = "0x%0" + this.ctx.getProcess().getPointerSize() / 8 * 2 + "x";
        }
        if (args.length == 1 && (args[0].equalsIgnoreCase(CMD_HELP) || args[0].equalsIgnoreCase(CMD_QMARK))) {
            this.printDetailedHelp(out);
            return true;
        }
        return false;
    }

    public long toLong(String number) {
        if (number.toLowerCase().startsWith(HEX_PREFIX)) {
            return Long.parseLong(number.substring(HEX_PREFIX.length()), 16);
        }
        return Long.parseLong(number);
    }

    protected ArtifactType getArtifactType() {
        String className;
        String name = this.ctx.getAddressSpace().getClass().getName();
        int index = name.lastIndexOf(46);
        if ((className = name.substring(++index)).startsWith("JC")) {
            return ArtifactType.javacore;
        }
        if (className.startsWith("PHD")) {
            return ArtifactType.phd;
        }
        if (className.startsWith("J9DDR")) {
            return ArtifactType.core;
        }
        if (className.startsWith("Image")) {
            return ArtifactType.core;
        }
        return ArtifactType.unknown;
    }

    public String toHexStringAddr(long num) {
        return String.format(this.hexfmt, num);
    }

    public String handleException(Throwable cause) {
        return ExceptionHandler.handleException(this, cause);
    }

    public String decodeThreadState(int state) {
        int[] states = new int[]{1, 1024, 0x400000, 256, 0x200000, 512, 4, 64, 0x100000, 2, 0x10000000, 0x20000000, 0x40000000, 128, 16, 32};
        String[] stateDescriptions = new String[]{"STATE_ALIVE", "STATE_BLOCKED_ON_MONITOR_ENTER", "STATE_IN_NATIVE", "STATE_IN_OBJECT_WAIT", "STATE_INTERRUPTED", "STATE_PARKED", "STATE_RUNNABLE", "STATE_SLEEPING", "STATE_SUSPENDED", "STATE_TERMINATED", "STATE_VENDOR_1", "STATE_VENDOR_2", "STATE_VENDOR_3", "STATE_WAITING", "STATE_WAITING_INDEFINITELY", "STATE_WAITING_WITH_TIMEOUT"};
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < states.length; ++i) {
            if ((state & states[i]) != states[i]) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(stateDescriptions[i]);
        }
        return sb.toString();
    }

    public String toHexString(long num) {
        return String.format(FormatEnum.HEX_LONG.getFormat(), num);
    }

    public String toHexString(short num) {
        return String.format(FormatEnum.HEX_SHORT.getFormat(), num);
    }

    public String toHexString(int num) {
        return String.format(FormatEnum.HEX_INT.getFormat(), num);
    }

    public String toHexString(byte num) {
        return String.format(FormatEnum.HEX_BYTE.getFormat(), num);
    }

    public String toString(float num) {
        return String.format(FormatEnum.DEC_FLOAT.getFormat(), Float.valueOf(num));
    }

    public String toString(double num) {
        return String.format(FormatEnum.DEC_DOUBLE.getFormat(), num);
    }

    private static enum FormatEnum {
        HEX_LONG("0x%016x"),
        HEX_SHORT("0x%04x"),
        HEX_BYTE("0x%02x"),
        HEX_INT("0x%08x"),
        DEC_FLOAT("%e"),
        DEC_DOUBLE("%e");

        private final String format;

        private FormatEnum(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }
    }

    protected static enum ArtifactType {
        core,
        phd,
        javacore,
        unknown;

    }
}

