/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.DTFJContext;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.commands.CommandParser;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.CdCommand;
import com.ibm.jvm.dtfjview.commands.CloseCommand;
import com.ibm.jvm.dtfjview.commands.OpenCommand;
import com.ibm.jvm.dtfjview.commands.PwdCommand;
import com.ibm.jvm.dtfjview.commands.setcommands.SetLoggingCommand;
import com.ibm.jvm.dtfjview.commands.showcommands.ShowLoggingCommand;
import com.ibm.jvm.dtfjview.spi.ICombinedContext;
import com.ibm.jvm.dtfjview.spi.IOutputManager;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CombinedContext
extends DTFJContext
implements ICombinedContext {
    private Logger logger = Logger.getLogger("com.ibm.jvm.dtfjview.logger");
    private static final String DDR_INTERACTIVE_CLASS = "com.ibm.j9ddr.tools.ddrinteractive.DDRInteractive";
    private Throwable ddrStartupException = null;
    private Object ddriObject = null;
    private Method ddriMethod = null;
    private boolean ddrAvailable = false;
    private int id = 0;

    public CombinedContext(int major, int minor, Image image, ImageAddressSpace space, ImageProcess proc, JavaRuntime rt, int id) {
        super(major, minor, image, space, proc, rt);
        this.globalCommands.add(new OpenCommand());
        this.globalCommands.add(new CloseCommand());
        this.globalCommands.add(new SetLoggingCommand());
        this.globalCommands.add(new ShowLoggingCommand());
        this.globalCommands.add(new PwdCommand());
        this.globalCommands.add(new CdCommand());
        this.id = id;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int id) {
        this.id = id;
    }

    public void execute(String cmdline, String[] arguments, PrintStream out) {
        try {
            CommandParser parser = new CommandParser(cmdline, arguments);
            this.execute(parser, out);
        }
        catch (ParseException e) {
            out.println("Error parsing command: " + cmdline + " (" + e.getMessage() + ")");
            this.logger.log(Level.FINE, "Error parsing command " + cmdline, e);
        }
    }

    private boolean initJdmpviewCommand(CommandParser parser, PrintStream out) throws CommandException {
        for (ICommand command : this.commands) {
            if (!command.recognises(parser.getCommand(), (IContext)this)) continue;
            try {
                Class<?> base = command.getClass().getClassLoader().loadClass(BaseJdmpviewCommand.class.getName());
                if (!base.isAssignableFrom(command.getClass())) continue;
                Method method = base.getMethod("initCommand", String.class, String[].class, IContext.class, PrintStream.class);
                Object result = method.invoke((Object)command, parser.getCommand(), parser.getArguments(), this, out);
                return (Boolean)result;
            }
            catch (Exception e) {
                out.println("Error initialising command : " + parser.getOriginalLine() + " (" + e.getMessage() + ")");
                this.logger.log(Level.FINE, "Error initialising command : " + parser.getOriginalLine(), e);
            }
        }
        return false;
    }

    public void execute(String cmdline, PrintStream out) {
        try {
            CommandParser parser = new CommandParser(cmdline);
            this.execute(parser, out);
        }
        catch (ParseException e) {
            out.println("Error parsing command: " + cmdline + " (" + e.getMessage() + ")");
            this.logger.log(Level.FINE, "Error parsing command " + cmdline, e);
        }
    }

    public void execute(CommandParser command, PrintStream out) {
        if (CombinedContext.isDDRCommand(command.getOriginalLine())) {
            this.executeDDRInteractiveCommand(command.getOriginalLine(), out);
        } else {
            try {
                if (!this.initJdmpviewCommand(command, out)) {
                    super.execute(command, out);
                }
            }
            catch (Exception e) {
                out.println("Error executing command: " + e.getMessage());
                this.logger.log(Level.FINE, "Error executing command : " + command.getOriginalLine(), e);
            }
        }
    }

    private static boolean isDDRCommand(String cmdline) {
        return cmdline != null && cmdline.startsWith("!");
    }

    public void startDDRInteractiveSession(Image image, PrintStream out) {
        Constructor<?> constructor;
        Class<?> ddriClass;
        this.ddrAvailable = false;
        try {
            ddriClass = Class.forName(DDR_INTERACTIVE_CLASS, true, image.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            this.logger.fine("DDR is not enabled for " + image.getSource() + " (context " + this.id + "). It may be pre-DDR or not a core file e.g. javacore or PHD");
            return;
        }
        try {
            constructor = ddriClass.getConstructor(List.class, PrintStream.class);
        }
        catch (Exception e) {
            this.logger.log(Level.FINE, "Error getting DDR Interactive constructor", e);
            return;
        }
        try {
            ArrayList<CombinedContext> contexts = new ArrayList<CombinedContext>(1);
            contexts.add(this);
            this.ddriObject = constructor.newInstance(contexts, out);
            this.ddriMethod = this.ddriObject.getClass().getMethod("processLine", String.class);
            this.ddrAvailable = true;
            if (this.hasPropertyBeenSet("verbose.mode")) {
                out.println("DTFJ DDR is enabled for this core dump");
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnsupportedOperationException) {
                this.logger.fine("DDR is not enabled for " + image.getSource() + " (context " + this.id + "). It may be pre-DDR or not a core file e.g. javacore or PHD");
            } else {
                this.ddrStartupException = cause;
                this.logger.log(Level.FINE, "Error creating DDR Interactive instance", e.getCause());
            }
        }
        catch (Exception e) {
            this.ddrStartupException = e;
            this.logger.log(Level.FINE, "Error creating DDR Interactive instance", e);
        }
    }

    @Override
    public Object getDDRIObject() {
        return this.ddriObject;
    }

    private void executeDDRInteractiveCommand(String line, PrintStream out) {
        if (!this.ddrAvailable) {
            out.println("DDR is not enabled for this core file, '!' commands are disabled");
            return;
        }
        try {
            this.ddriMethod.invoke(this.ddriObject, line);
        }
        catch (Exception e) {
            out.println("Error executing DDR command " + line + " : " + e.getMessage());
            e.printStackTrace(out);
        }
    }

    @Override
    public Throwable getDDRStartupException() {
        return this.ddrStartupException;
    }

    @Override
    public void displayContext(IOutputManager out, boolean shortFormat) {
        out.print(this.id + " : ");
        if (this.ddrAvailable) {
            out.clearBuffer();
            try {
                out.setBuffering(true);
                this.executeDDRInteractiveCommand("!context short", out.getPrintStream());
            }
            finally {
                out.setBuffering(false);
            }
            int index = out.getBuffer().indexOf(58);
            if (index != -1) {
                out.print(out.getBuffer().substring(index + 1).trim());
            }
            out.print(" : ");
            out.print(this.getJREVersion(shortFormat));
        } else {
            this.showDTFJContexts(out, shortFormat);
        }
        out.print("\n");
    }

    private void showDTFJContexts(IOutputManager out, boolean shortFormat) {
        if (this.getRuntime() == null) {
            out.print("<no Java runtime>");
        } else {
            out.print(this.getJREVersion(shortFormat));
        }
    }

    private String getJREVersion(boolean shortFormat) {
        StringBuilder builder;
        block10: {
            builder = new StringBuilder();
            try {
                if (this.getRuntime() == null) {
                    builder.append("No JRE");
                    break block10;
                }
                try {
                    String version = this.getRuntime().getVersion();
                    if (shortFormat) {
                        int index = version.indexOf("\n");
                        String firstLine = null;
                        firstLine = index == -1 ? (version.length() == 0 ? "[cannot determine JRE level]" : version) : version.substring(0, index).trim();
                        builder.append(firstLine);
                    } else {
                        String[] parts;
                        for (String part : parts = version.split("\n")) {
                            builder.append("\n\t\t" + part.trim());
                        }
                    }
                }
                catch (CorruptDataException c) {
                    if (this.getRuntime().getJavaVM() != null) {
                        builder.append("JRE level unknown");
                    }
                }
            }
            catch (CorruptDataException e) {
                builder.append("<corrupt Java runtime>");
            }
            catch (Exception e) {
                builder.append("<error : " + e.getMessage() + ">");
            }
        }
        return builder.toString();
    }

    @Override
    public void setAsCurrent() {
        URI uri = this.getImage().getSource();
        String fragment = uri.getFragment();
        if (fragment != null && !fragment.isEmpty()) {
            try {
                uri = new URI(uri.getScheme() + "://" + uri.getRawPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        File file = new File(uri);
        System.setProperty("com.ibm.j9ddr.tools.ddrinteractive.filepath", file.getAbsolutePath());
    }

    @Override
    public boolean isDDRAvailable() {
        return this.ddrAvailable;
    }
}

