/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http.spnego;

import com.ibm.security.jgss.GSSManagerImpl;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.Negotiator;
import sun.security.action.GetBooleanAction;

public class NegotiatorImpl
extends Negotiator {
    private static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.debug"));
    private GSSContext context;
    private byte[] oneToken;

    private void init(HttpCallerInfo httpCallerInfo) throws GSSException {
        String string;
        Oid oid;
        int n = 0;
        if (httpCallerInfo.scheme.equalsIgnoreCase("Kerberos")) {
            oid = new Oid("1.2.840.113554.1.2.2");
        } else {
            string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("http.auth.preference", "spnego");
                }
            });
            if (string.equalsIgnoreCase("kerberos")) {
                oid = new Oid("1.2.840.113554.1.2.2");
            } else {
                oid = new Oid("1.3.6.1.5.5.2");
                n = Integer.MAX_VALUE;
            }
        }
        string = new GSSManagerImpl();
        String string2 = "HTTP@" + httpCallerInfo.host.toLowerCase();
        GSSName gSSName = string.createName(string2, GSSName.NT_HOSTBASED_SERVICE);
        this.context = string.createContext(gSSName, oid, null, n);
        this.oneToken = this.context.initSecContext(new byte[0], 0, 0);
    }

    public NegotiatorImpl(HttpCallerInfo httpCallerInfo) throws IOException {
        try {
            this.init(httpCallerInfo);
        }
        catch (GSSException gSSException) {
            if (DEBUG) {
                System.out.println("Negotiate support not initiated, will fallback to other scheme if allowed. Reason:");
                gSSException.printStackTrace();
            }
            try {
                this.disposeContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IOException iOException = new IOException("Negotiate support not initiated");
            iOException.initCause(gSSException);
            throw iOException;
        }
    }

    @Override
    public byte[] firstToken() {
        return this.oneToken;
    }

    @Override
    public byte[] nextToken(byte[] byArray) throws IOException {
        try {
            if (this.context == null) {
                throw new IOException("Negotiate support cannot continue. Context is invalidated");
            }
            return this.context.initSecContext(byArray, 0, byArray.length);
        }
        catch (GSSException gSSException) {
            if (DEBUG) {
                System.out.println("Negotiate support cannot continue. Reason:");
                gSSException.printStackTrace();
            }
            IOException iOException = new IOException("Negotiate support cannot continue");
            iOException.initCause(gSSException);
            throw iOException;
        }
    }

    @Override
    public void disposeContext() throws IOException {
        try {
            if (this.context != null) {
                this.context.dispose();
            }
        }
        catch (GSSException gSSException) {
            if (DEBUG) {
                System.out.println("Cannot release resources. Reason:");
                gSSException.printStackTrace();
            }
            throw new IOException("Cannot release resources", gSSException);
        }
        this.context = null;
    }
}

