/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.jvm.MemorySafetyService;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PolicySpi;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import sun.security.jca.GetInstance;
import sun.security.provider.PolicyFile;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public abstract class Policy {
    public static final PermissionCollection UNSUPPORTED_EMPTY_COLLECTION = new UnsupportedEmptyCollection();
    private static AtomicReference<PolicyInfo> policy = new AtomicReference<PolicyInfo>(new PolicyInfo(null, false));
    private static final Debug debug = Debug.getInstance("policy");
    private WeakHashMap<ProtectionDomain.Key, PermissionCollection> pdMapping;

    static boolean isSet() {
        PolicyInfo policyInfo = policy.get();
        return policyInfo.policy != null && policyInfo.initialized;
    }

    private static void checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("createPolicy." + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Policy getPolicy() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_POLICY_PERMISSION);
        }
        long l = -1L;
        try {
            l = MemorySafetyService.enterSafeMemoryArea();
            Policy policy = Policy.getPolicyNoCheck();
            return policy;
        }
        finally {
            MemorySafetyService.exitLastMemoryArea((long)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Policy getPolicyNoCheck() {
        PolicyInfo policyInfo = policy.get();
        if (!policyInfo.initialized || policyInfo.policy == null) {
            Class<Policy> clazz = Policy.class;
            synchronized (Policy.class) {
                PolicyInfo policyInfo2 = policy.get();
                if (policyInfo2.policy == null) {
                    String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            return Security.getProperty("policy.provider");
                        }
                    });
                    if (string == null) {
                        string = "sun.security.provider.PolicyFile";
                    }
                    try {
                        policyInfo2 = new PolicyInfo((Policy)Class.forName(string).newInstance(), true);
                    }
                    catch (Exception exception) {
                        PolicyFile policyFile = new PolicyFile();
                        policyInfo2 = new PolicyInfo(policyFile, false);
                        policy.set(policyInfo2);
                        final String string2 = string;
                        Policy policy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

                            @Override
                            public Policy run() {
                                try {
                                    ClassLoader classLoader = null;
                                    for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
                                        classLoader = classLoader2;
                                    }
                                    return classLoader != null ? (Policy)Class.forName(string2, true, classLoader).newInstance() : null;
                                }
                                catch (Exception exception) {
                                    if (debug != null) {
                                        debug.println("policy provider " + string2 + " not available");
                                        exception.printStackTrace();
                                    }
                                    return null;
                                }
                            }
                        });
                        if (policy != null) {
                            policyInfo2 = new PolicyInfo(policy, true);
                        }
                        if (debug != null) {
                            debug.println("using sun.security.provider.PolicyFile");
                        }
                        policyInfo2 = new PolicyInfo(policyFile, true);
                    }
                    policy.set(policyInfo2);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return policyInfo2.policy;
            }
        }
        return policyInfo.policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicy(Policy policy) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (policy != null) {
            Policy.initPolicy(policy);
        }
        Class<Policy> clazz = Policy.class;
        synchronized (Policy.class) {
            Policy.policy.set(new PolicyInfo(policy, policy != null));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initPolicy(final Policy policy) {
        ProtectionDomain protectionDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return policy.getClass().getProtectionDomain();
            }
        });
        PermissionCollection permissionCollection = null;
        Policy policy2 = policy;
        synchronized (policy2) {
            if (policy.pdMapping == null) {
                policy.pdMapping = new WeakHashMap();
            }
        }
        if (protectionDomain.getCodeSource() != null) {
            policy2 = Policy.policy.get().policy;
            if (policy2 != null) {
                permissionCollection = policy2.getPermissions(protectionDomain);
            }
            if (permissionCollection == null) {
                permissionCollection = new Permissions();
                permissionCollection.add(SecurityConstants.ALL_PERMISSION);
            }
            WeakHashMap<ProtectionDomain.Key, PermissionCollection> weakHashMap = policy.pdMapping;
            synchronized (weakHashMap) {
                policy.pdMapping.put(protectionDomain.key, permissionCollection);
            }
        }
    }

    public static Policy getInstance(String string, Parameters parameters) throws NoSuchAlgorithmException {
        Policy.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, string, parameters);
            return new PolicyDelegate((PolicySpi)instance.impl, instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Policy.handleException(noSuchAlgorithmException);
        }
    }

    public static Policy getInstance(String string, Parameters parameters, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Policy.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, string, (Object)parameters, string2);
            return new PolicyDelegate((PolicySpi)instance.impl, instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Policy.handleException(noSuchAlgorithmException);
        }
    }

    public static Policy getInstance(String string, Parameters parameters, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Policy.checkPermission(string);
        try {
            GetInstance.Instance instance = GetInstance.getInstance("Policy", PolicySpi.class, string, (Object)parameters, provider);
            return new PolicyDelegate((PolicySpi)instance.impl, instance.provider, string, parameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Policy.handleException(noSuchAlgorithmException);
        }
    }

    private static Policy handleException(NoSuchAlgorithmException noSuchAlgorithmException) throws NoSuchAlgorithmException {
        Throwable throwable = noSuchAlgorithmException.getCause();
        if (throwable instanceof IllegalArgumentException) {
            throw (IllegalArgumentException)throwable;
        }
        throw noSuchAlgorithmException;
    }

    public Provider getProvider() {
        return null;
    }

    public String getType() {
        return null;
    }

    public Parameters getParameters() {
        return null;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return UNSUPPORTED_EMPTY_COLLECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        PermissionCollection permissionCollection = null;
        if (protectionDomain == null) {
            return new Permissions();
        }
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        Object object = this.pdMapping;
        synchronized (object) {
            permissionCollection = this.pdMapping.get(protectionDomain.key);
        }
        if (permissionCollection != null) {
            object = new Permissions();
            PermissionCollection permissionCollection2 = permissionCollection;
            synchronized (permissionCollection2) {
                Enumeration<Permission> enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    ((Permissions)object).add(enumeration.nextElement());
                }
            }
            return object;
        }
        permissionCollection = this.getPermissions(protectionDomain.getCodeSource());
        if (permissionCollection == null || permissionCollection == UNSUPPORTED_EMPTY_COLLECTION) {
            permissionCollection = new Permissions();
        }
        this.addStaticPerms(permissionCollection, protectionDomain.getPermissions());
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticPerms(PermissionCollection permissionCollection, PermissionCollection permissionCollection2) {
        if (permissionCollection2 != null) {
            PermissionCollection permissionCollection3 = permissionCollection2;
            synchronized (permissionCollection3) {
                Enumeration<Permission> enumeration = permissionCollection2.elements();
                while (enumeration.hasMoreElements()) {
                    permissionCollection.add(enumeration.nextElement());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        PermissionCollection permissionCollection;
        if (this.pdMapping == null) {
            Policy.initPolicy(this);
        }
        WeakHashMap<ProtectionDomain.Key, PermissionCollection> weakHashMap = this.pdMapping;
        synchronized (weakHashMap) {
            permissionCollection = this.pdMapping.get(protectionDomain.key);
        }
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        permissionCollection = this.getPermissions(protectionDomain);
        if (permissionCollection == null) {
            return false;
        }
        weakHashMap = this.pdMapping;
        synchronized (weakHashMap) {
            this.pdMapping.put(protectionDomain.key, permissionCollection);
        }
        return permissionCollection.implies(permission);
    }

    public void refresh() {
    }

    private static class UnsupportedEmptyCollection
    extends PermissionCollection {
        private static final long serialVersionUID = -8492269157353014774L;
        private Permissions perms = new Permissions();

        public UnsupportedEmptyCollection() {
            this.perms.setReadOnly();
        }

        @Override
        public void add(Permission permission) {
            this.perms.add(permission);
        }

        @Override
        public boolean implies(Permission permission) {
            return this.perms.implies(permission);
        }

        @Override
        public Enumeration<Permission> elements() {
            return this.perms.elements();
        }
    }

    public static interface Parameters {
    }

    private static class PolicyDelegate
    extends Policy {
        private PolicySpi spi;
        private Provider p;
        private String type;
        private Parameters params;

        private PolicyDelegate(PolicySpi policySpi, Provider provider, String string, Parameters parameters) {
            this.spi = policySpi;
            this.p = provider;
            this.type = string;
            this.params = parameters;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public Parameters getParameters() {
            return this.params;
        }

        @Override
        public Provider getProvider() {
            return this.p;
        }

        @Override
        public PermissionCollection getPermissions(CodeSource codeSource) {
            return this.spi.engineGetPermissions(codeSource);
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
            return this.spi.engineGetPermissions(protectionDomain);
        }

        @Override
        public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
            return this.spi.engineImplies(protectionDomain, permission);
        }

        @Override
        public void refresh() {
            this.spi.engineRefresh();
        }
    }

    private static class PolicyInfo {
        final Policy policy;
        final boolean initialized;

        PolicyInfo(Policy policy, boolean bl) {
            this.policy = policy;
            this.initialized = bl;
        }
    }
}

