/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.StreamEncoder;

public class OutputStreamWriter
extends Writer {
    private static final int BUFFER_SIZE = 512;
    private OutputStreamWriter osw = null;
    private char[] buffer = new char[512];
    private volatile int index = -1;
    private volatile boolean streamClosed = false;
    private boolean bufferFlushed = true;
    private final StreamEncoder se;

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream);
        if (string == null) {
            throw new NullPointerException("charsetName");
        }
        this.se = StreamEncoder.forOutputStreamWriter(outputStream, (Object)outputStream, string);
    }

    public OutputStreamWriter(OutputStream outputStream) {
        super(outputStream);
        try {
            this.se = StreamEncoder.forOutputStreamWriter(outputStream, (Object)outputStream, (String)null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException);
        }
    }

    public OutputStreamWriter(OutputStream outputStream, Charset charset) {
        super(outputStream);
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.se = StreamEncoder.forOutputStreamWriter(outputStream, (Object)outputStream, charset);
    }

    public OutputStreamWriter(OutputStream outputStream, CharsetEncoder charsetEncoder) {
        super(outputStream);
        if (charsetEncoder == null) {
            throw new NullPointerException("charset encoder");
        }
        this.se = StreamEncoder.forOutputStreamWriter(outputStream, (Object)outputStream, charsetEncoder);
    }

    public String getEncoding() {
        return this.se.getEncoding();
    }

    void flushBuffer() throws IOException {
        this.se.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bufferFlushed && 1 >= 512 - this.index) {
                this.emptyBuffer();
            }
            if (this.streamClosed) {
                this.se.write(n);
                return;
            }
            this.bufferFlushed = false;
            this.buffer[++this.index] = (char)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bufferFlushed && cArray.length >= 512 - this.index) {
                this.emptyBuffer();
            }
            if (cArray.length > 512 || this.streamClosed) {
                this.se.write(cArray, n, n2);
                return;
            }
            System.arraycopy(cArray, n, this.buffer, this.index + 1, n2);
            this.bufferFlushed = false;
            this.index += n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.bufferFlushed && string.length() >= 512 - this.index) {
                this.emptyBuffer();
            }
            if (string.length() > 512 || this.streamClosed) {
                this.se.write(string, n, n2);
                return;
            }
            string.getChars(n, n + n2, this.buffer, this.index + 1);
            this.bufferFlushed = false;
            this.index += n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.emptyBuffer();
            this.se.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.emptyBuffer();
            this.streamClosed = true;
            this.se.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.streamClosed) {
                this.se.write(this.buffer, 0, this.index + 1);
            }
            this.bufferFlushed = true;
            this.index = -1;
        }
    }
}

