/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang;

import com.ibm.lang.ThreadPropertyMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.WeakHashMap;

public final class ThreadProperties {
    public static final String KEEPALIVE_IDLE_TIME = new String("com.ibm.net.SocketKeepAlive.idleTime");
    public static final String KEEPALIVE_PROBE_COUNT = new String("com.ibm.net.SocketKeepAlive.probeCount");
    public static final String KEEPALIVE_INTERVAL_TIME = new String("com.ibm.net.SocketKeepAlive.intervalTime");
    private static final int DEFAULT_THREADGROUP_SIZE = 2;
    private static final int DEFAULT_PROPERTIES_SIZE = 3;
    private static final ThreadLocal<ThreadPropertyMap> THREAD_PROPERTIES = new ThreadLocal();
    private static final Map<ThreadGroup, ThreadPropertyMap> THREADGROUP_PROPERTIES = Collections.synchronizedMap(new WeakHashMap(2));

    public static String getProperty(String string) {
        return ThreadProperties.getProperty(string, true);
    }

    public static String getProperty(String string, boolean bl) {
        Object object;
        ThreadPropertyMap threadPropertyMap;
        ThreadProperties.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        if ((threadPropertyMap = THREAD_PROPERTIES.get()) != null && (object = (String)threadPropertyMap.get(string)) != null) {
            return object;
        }
        if (!bl) {
            return null;
        }
        object = THREADGROUP_PROPERTIES.get(Thread.currentThread().getThreadGroup());
        return object != null ? (String)((HashMap)object).get(string) : null;
    }

    public static ThreadPropertyMap getProperties() {
        return ThreadProperties.getProperties(true);
    }

    public static ThreadPropertyMap getProperties(boolean bl) {
        ThreadPropertyMap threadPropertyMap;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        if ((threadPropertyMap = THREAD_PROPERTIES.get()) != null) {
            return (ThreadPropertyMap)threadPropertyMap.clone();
        }
        if (!bl) {
            return null;
        }
        return ThreadProperties.getProperties(Thread.currentThread().getThreadGroup());
    }

    public static String setProperty(String string, String string2) {
        ThreadPropertyMap threadPropertyMap;
        ThreadProperties.checkKeyAndValue(string, string2);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        if ((threadPropertyMap = THREAD_PROPERTIES.get()) == null) {
            threadPropertyMap = new ThreadPropertyMap(3);
        }
        String string3 = threadPropertyMap.put(string, string2);
        THREAD_PROPERTIES.set(threadPropertyMap);
        return string3;
    }

    public static void setProperties(ThreadPropertyMap threadPropertyMap) {
        if (threadPropertyMap == null) {
            throw new NullPointerException("properties can't be null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        THREAD_PROPERTIES.set(threadPropertyMap);
    }

    public static String clearProperty(String string) {
        ThreadPropertyMap threadPropertyMap;
        ThreadProperties.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return (threadPropertyMap = THREAD_PROPERTIES.get()) == null ? null : (String)threadPropertyMap.remove(string);
    }

    public static void clearProperties() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        THREAD_PROPERTIES.remove();
    }

    public static String getProperty(ThreadGroup threadGroup, String string) {
        ThreadPropertyMap threadPropertyMap;
        if (threadGroup == null) {
            throw new NullPointerException("threadGroup can't be null");
        }
        ThreadProperties.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return (threadPropertyMap = THREADGROUP_PROPERTIES.get(threadGroup)) != null ? (String)threadPropertyMap.get(string) : null;
    }

    public static ThreadPropertyMap getProperties(ThreadGroup threadGroup) {
        ThreadPropertyMap threadPropertyMap;
        if (threadGroup == null) {
            throw new NullPointerException("threadGroup can't be null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return (threadPropertyMap = THREADGROUP_PROPERTIES.get(threadGroup)) != null ? (ThreadPropertyMap)threadPropertyMap.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setProperty(ThreadGroup threadGroup, String string, String string2) {
        ThreadPropertyMap threadPropertyMap;
        if (threadGroup == null) {
            throw new NullPointerException("threadGroup can't be null");
        }
        ThreadProperties.checkKeyAndValue(string, string2);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        threadPropertyMap = (threadPropertyMap = THREADGROUP_PROPERTIES.get(threadGroup)) != null ? threadPropertyMap : new ThreadPropertyMap(3);
        String string3 = null;
        Class<ThreadProperties> clazz = ThreadProperties.class;
        synchronized (ThreadProperties.class) {
            string3 = threadPropertyMap.put(string, string2);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            THREADGROUP_PROPERTIES.put(threadGroup, threadPropertyMap);
            return string3;
        }
    }

    public static void setProperties(ThreadGroup threadGroup, ThreadPropertyMap threadPropertyMap) {
        if (threadGroup == null) {
            throw new NullPointerException("threadGroup can't be null");
        }
        if (threadPropertyMap == null) {
            throw new NullPointerException("PropertyMap can't be null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        THREADGROUP_PROPERTIES.put(threadGroup, threadPropertyMap);
    }

    public static String clearProperty(ThreadGroup threadGroup, String string) {
        ThreadPropertyMap threadPropertyMap;
        if (threadGroup == null) {
            throw new NullPointerException("threadGroup can't be null");
        }
        ThreadProperties.checkKey(string);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        if ((threadPropertyMap = THREADGROUP_PROPERTIES.get(threadGroup)) == null) {
            return null;
        }
        String string2 = (String)threadPropertyMap.remove(string);
        if (string2 != null) {
            THREADGROUP_PROPERTIES.put(threadGroup, threadPropertyMap);
        }
        return string2;
    }

    public static void clearProperties(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new NullPointerException("threadGroup can't be null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        THREADGROUP_PROPERTIES.remove(threadGroup);
    }

    private static void checkKey(String string) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
    }

    private static void checkKeyAndValue(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (string2 == null) {
            throw new NullPointerException("value can't be null");
        }
    }
}

