/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.io;

import com.ibm.jvm.io.LocalizedInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public final class ConsolePrintStream
extends PrintStream {
    private String lineSeparator;
    private int lineSeparatorNLIndex;
    private static boolean conversionRequired;
    private PrintStream ps;

    private ConsolePrintStream(OutputStream outputStream, boolean bl, String string, boolean bl2) {
        super(outputStream, bl);
        this.ps = new PrintStream(outputStream, bl);
        this.lineSeparator = string;
        this.lineSeparatorNLIndex = this.lineSeparator.indexOf(10);
        conversionRequired = bl2;
    }

    public static void setConversionRequired(boolean bl) {
        conversionRequired = bl;
    }

    private ConsolePrintStream(OutputStream outputStream, boolean bl, String string, String string2, boolean bl2) throws UnsupportedEncodingException {
        super(outputStream, bl, string2);
        this.ps = new PrintStream(outputStream, bl, string2);
        this.lineSeparator = string;
        this.lineSeparatorNLIndex = this.lineSeparator.indexOf(10);
        conversionRequired = bl2;
    }

    @Override
    public void write(int n) {
        if (conversionRequired) {
            this.ps.print((char)n);
        } else {
            this.ps.write(n);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (conversionRequired) {
            this.ps.print(new String(byArray, n, n2));
        } else {
            this.ps.write(byArray, n, n2);
        }
    }

    @Override
    public boolean checkError() {
        return this.ps.checkError();
    }

    @Override
    public void close() {
        this.ps.close();
    }

    @Override
    public void flush() {
        this.ps.flush();
    }

    @Override
    public void print(boolean bl) {
        this.ps.print(bl);
    }

    @Override
    public void print(int n) {
        this.ps.print(n);
    }

    @Override
    public void print(long l) {
        this.ps.print(l);
    }

    @Override
    public void print(float f) {
        this.ps.print(f);
    }

    @Override
    public void print(double d) {
        this.ps.print(d);
    }

    @Override
    public void println() {
        this.ps.println();
    }

    @Override
    public void println(boolean bl) {
        this.ps.println(bl);
    }

    @Override
    public void println(int n) {
        this.ps.println(n);
    }

    @Override
    public void println(long l) {
        this.ps.println(l);
    }

    @Override
    public void println(float f) {
        this.ps.println(f);
    }

    @Override
    public void println(double d) {
        this.ps.println(d);
    }

    @Override
    public void print(char c) {
        if (c != '\n') {
            this.ps.print(c);
        } else {
            this.ps.print(this.lineSeparator);
        }
    }

    @Override
    public void print(char[] cArray) {
        this.ps.print(this.getNewlinedString(cArray, false));
    }

    @Override
    public void print(String string) {
        this.ps.print(this.getNewlinedString(string));
    }

    @Override
    public void print(Object object) {
        this.ps.print(this.getNewlinedString(object));
    }

    @Override
    public void println(char c) {
        if (c != '\n') {
            this.ps.println(c);
        } else {
            this.ps.println(this.lineSeparator);
        }
    }

    @Override
    public void println(char[] cArray) {
        this.ps.println(this.getNewlinedString(cArray, false));
    }

    @Override
    public void println(String string) {
        this.ps.println(this.getNewlinedString(string));
    }

    @Override
    public void println(Object object) {
        this.ps.println(this.getNewlinedString(object));
    }

    private String getNewlinedString(Object object) {
        return this.getNewlinedString(object, true);
    }

    private String getNewlinedString(Object object, boolean bl) {
        String string;
        if (object == null) {
            return null;
        }
        String string2 = string = object instanceof char[] && !bl ? new String((char[])object) : String.valueOf(object);
        if (string == null) {
            return null;
        }
        int n = string.indexOf(10);
        if (n == -1) {
            return string;
        }
        char[] cArray = object instanceof char[] && !bl ? (char[])object : string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n2 = 0;
        while (n != -1) {
            if (this.lineSeparatorNLIndex != -1 && string.regionMatches(n - this.lineSeparatorNLIndex, this.lineSeparator, 0, this.lineSeparator.length())) {
                n = n + this.lineSeparator.length() - this.lineSeparatorNLIndex - 1;
            } else {
                stringBuffer.append(cArray, n2, n - n2);
                stringBuffer.append(this.lineSeparator);
                n2 = n + 1;
            }
            n = string.indexOf(10, n + 1);
        }
        if (stringBuffer.length() == 0) {
            return string;
        }
        if (n2 < cArray.length) {
            stringBuffer.append(cArray, n2, cArray.length - n2);
        }
        return stringBuffer.toString();
    }

    public static PrintStream localize(OutputStream outputStream) {
        return ConsolePrintStream.localize(outputStream, false);
    }

    public static PrintStream localize(OutputStream outputStream, boolean bl) {
        if (outputStream instanceof ConsolePrintStream) {
            return (PrintStream)outputStream;
        }
        String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        String string2 = AccessController.doPrivileged(new GetPropertyAction("console.encoding"));
        if (string2 == null && LocalizedInputStream.nonASCIIPlatform) {
            string2 = AccessController.doPrivileged(new GetPropertyAction("ibm.system.encoding"));
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        String string3 = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        boolean bl2 = string2 != null && !string2.equals(string3);
        if (string.equals("\n")) {
            if (outputStream instanceof PrintStream) {
                return (PrintStream)outputStream;
            }
            if (string2 != null) {
                try {
                    return new ConsolePrintStream(outputStream, bl, string, string2, bl2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new PrintStream(outputStream, bl);
        }
        if (string2 != null) {
            try {
                return new ConsolePrintStream(outputStream, bl, string, string2, bl2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ConsolePrintStream(outputStream, bl, string, bl2);
    }
}

