/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.plus.provider;

import com.ibm.crypto.plus.provider.DHParameters;
import com.ibm.crypto.plus.provider.IBMJCEPlusProvider;
import com.ibm.crypto.plus.provider.icc.DHKey;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

final class DHPublicKey
extends X509Key
implements javax.crypto.interfaces.DHPublicKey,
PublicKey,
Serializable,
Destroyable {
    private static final long serialVersionUID = -2993913181811776154L;
    private IBMJCEPlusProvider provider = null;
    private BigInteger y = null;
    private DHParameters dhParams = null;
    private byte[] key = null;
    private byte[] encodedKey = null;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private transient boolean destroyed = false;
    private transient DHKey dhKey = null;
    private static final String[] z;

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(iBMJCEPlusProvider, bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.y = bigInteger;
        this.dhParams = new DHParameters(iBMJCEPlusProvider);
        try {
            this.dhParams.engineInit(new DHParameterSpec(bigInteger2, bigInteger3, n2));
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[13]);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(z[14]);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, BigInteger bigInteger, DHParameters dHParameters) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        this.y = bigInteger;
        this.dhParams = dHParameters;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[24]);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, DHKey dHKey) {
        try {
            this.provider = iBMJCEPlusProvider;
            byte[] byArray = this.a(dHKey.getPublicKeyBytes());
            this.dhKey = dHKey;
            this.parseKeyBits();
        }
        catch (Exception exception) {
            throw iBMJCEPlusProvider.a(z[21], (Throwable)exception);
        }
    }

    public DHPublicKey(IBMJCEPlusProvider iBMJCEPlusProvider, byte[] byArray) throws InvalidKeyException {
        this.provider = iBMJCEPlusProvider;
        try {
            this.a(byArray);
            byte[] byArray2 = this.a();
            this.dhKey = DHKey.createPublicKey(iBMJCEPlusProvider.a(), this.encodedKey);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[22]);
        }
        catch (Exception exception) {
            throw iBMJCEPlusProvider.a(z[23], (Throwable)exception);
        }
    }

    private byte[] a(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DerValue derValue = new DerValue((InputStream)byteArrayInputStream);
            if (derValue.getTag() != 48) {
                throw new IOException(z[7]);
            }
            DerValue derValue2 = derValue.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new IOException(z[5]);
            }
            DerInputStream derInputStream = derValue2.toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream.getOID();
            if (derInputStream.available() == 0) {
                throw new IOException(z[10]);
            }
            DerValue derValue3 = derInputStream.getDerValue();
            if (derValue3.getTag() == 5) {
                throw new IOException(z[6]);
            }
            if (derValue3.getTag() != 48) {
                throw new IOException(z[8]);
            }
            derValue3.getData().reset();
            BigInteger bigInteger = derValue3.getData().getInteger();
            BigInteger bigInteger2 = derValue3.getData().getInteger();
            int n2 = -1;
            if (derValue3.getData().available() != 0) {
                n2 = derValue3.getData().getInteger().intValue();
            }
            if (derValue3.getData().available() != 0) {
                throw new IOException(z[11]);
            }
            this.key = derValue.getData().getBitString();
            this.parseKeyBits();
            if (derValue.getData().available() != 0) {
                throw new InvalidKeyException(z[12]);
            }
            DHParameters dHParameters = this.dhParams = new DHParameters(this.provider);
            DHParameterSpec dHParameterSpec = n2 == -1 ? new DHParameterSpec(bigInteger, bigInteger2, this.y.bitLength()) : new DHParameterSpec(bigInteger, bigInteger2, n2);
            dHParameters.engineInit(dHParameterSpec);
            this.encodedKey = (byte[])byArray.clone();
            DerValue derValue4 = new DerValue(2, this.key);
            return derValue4.toByteArray();
        }
        catch (IOException | NumberFormatException exception) {
            throw new IOException(z[3], exception);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException(z[9], invalidKeyException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new IOException(z[4], invalidParameterSpecException);
        }
    }

    private byte[] a() throws Exception {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, this.y.toByteArray()), new DerValue(2, this.dhParams.a().toByteArray()), new DerValue(2, this.dhParams.b().toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putSequence(derValueArray);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            this.a(derOutputStream);
        }
        return derOutputStream.toByteArray();
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            this.y = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    @Override
    public DHParameterSpec getParams() {
        this.c();
        try {
            return this.dhParams.engineGetParameterSpec(DHParameterSpec.class);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw this.provider.a(z[2], (Throwable)invalidParameterSpecException);
        }
    }

    @Override
    public String getAlgorithm() {
        this.c();
        return z[20];
    }

    @Override
    public String getFormat() {
        this.c();
        return super.getFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getEncoded() {
        this.c();
        DerOutputStream derOutputStream = null;
        DerOutputStream derOutputStream2 = null;
        DerOutputStream derOutputStream3 = null;
        DerOutputStream derOutputStream4 = null;
        if (this.encodedKey == null) {
            try {
                derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(new ObjectIdentifier(this.DH_data));
                derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(this.dhParams.a());
                derOutputStream.putInteger(this.dhParams.b());
                if (this.dhParams.c() != 0) {
                    derOutputStream.putInteger(BigInteger.valueOf(this.dhParams.c()));
                }
                DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
                derOutputStream2.putDerValue(derValue);
                derOutputStream3 = new DerOutputStream();
                derOutputStream3.write((byte)48, derOutputStream2);
                derOutputStream3.putBitString(this.key);
                derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream3);
                this.encodedKey = derOutputStream4.toByteArray();
                this.a(derOutputStream);
                this.a(derOutputStream2);
                this.a(derOutputStream3);
                this.a(derOutputStream4);
            }
            catch (IOException iOException) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                this.a(derOutputStream);
                this.a(derOutputStream2);
                this.a(derOutputStream3);
                this.a(derOutputStream4);
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getY() {
        this.c();
        return this.y;
    }

    DHKey b() {
        return this.dhKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
            }
            this.dhKey = null;
            this.y = null;
            this.dhParams = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private void c() {
        if (this.destroyed) {
            throw new IllegalStateException(z[19]);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        this.c();
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(z[18] + this.y.toString() + z[17] + this.dhParams.a().toString() + z[15] + this.dhParams.b().toString());
        if (this.dhParams.c() != 0) {
            stringBuffer.append(z[16] + this.dhParams.c());
        }
        return stringBuffer.toString();
    }

    private void a(DerOutputStream derOutputStream) {
        try {
            derOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.y, this.dhParams.a(), this.dhParams.b()};
        return Arrays.hashCode(objectArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof javax.crypto.interfaces.DHPublicKey)) {
            return false;
        }
        javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)object;
        DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
        if (this.y.compareTo(dHPublicKey.getY()) != 0) return false;
        if (this.dhParams.a().compareTo(dHParameterSpec.getP()) != 0) return false;
        if (this.dhParams.b().compareTo(dHParameterSpec.getG()) != 0) return false;
        if (object instanceof DHPublicKey) {
            return true;
        }
        if (this.hashCode() != object.hashCode()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.key == null || this.key.length == 0) {
            throw new InvalidObjectException(z[1]);
        }
        this.key = (byte[])this.key.clone();
        if (this.encodedKey != null && this.encodedKey.length != 0) {
            this.encodedKey = (byte[])this.encodedKey.clone();
            return;
        }
        throw new InvalidObjectException(z[0]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[25];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = ".-=\u001e\u0011.'~\u001a\u00102c0\u001e\u0001k';\u0002\u00109*?\u001d\u001c1\"<\u001d\u0010";
        int n3 = -1;
        block32: while (true) {
            char[] cArray;
            block36: {
                int n4;
                int n5;
                block35: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block35;
                    n5 = n5;
                    if (n5 <= n4) break block36;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 75;
                            break;
                        }
                        case 1: {
                            n6 = 67;
                            break;
                        }
                        case 2: {
                            n6 = 94;
                            break;
                        }
                        case 3: {
                            n6 = 113;
                            break;
                        }
                        default: {
                            n6 = 117;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = " &'Q\u001b$7~\u0015\u00108&,\u0018\u0014'*$\u0010\u0017'&";
                    n3 = 0;
                    continue block32;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\r\"7\u001d\u00009&~\u0018\u001bk\u0007\u0016!\u0000)/7\u0012>.:";
                    n3 = 1;
                    continue block32;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u000e1,\u001e\u0007k3?\u0003\u0006\"-9Q\u001e.:~\u0014\u001b(,:\u0018\u001b,";
                    n3 = 2;
                    continue block32;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u000e1,\u001e\u0007k ,\u0014\u0014?*0\u0016U\u000f\u000b\u000e\u0010\u0007*.;\u0005\u001090";
                    n3 = 3;
                    continue block32;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\n/98\u0011k*-Q\u001b$7~\u0010U\u0018\u0006\u000f$0\u0005\u0000\u001b";
                    n3 = 4;
                    continue block32;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u000562\u001dU;\",\u0010\u0018.7;\u0003\u0006";
                    n3 = 5;
                    continue block32;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u0002-(\u0010\u0019\"'~\u001a\u00102c8\u001e\u0007&\"*";
                    n3 = 6;
                    continue block32;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u001b\",\u0010\u0018.7;\u0003\u0006k-1\u0005U*c\r4$\u001e\u0006\u001020";
                    n3 = 7;
                    continue block32;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u000e1,\u001e\u0007k3?\u0003\u0006\"-9Q\u001e.:~\u001c\u0014?&,\u0018\u0014'";
                    n3 = 8;
                    continue block32;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u001b\",\u0010\u0018.7;\u0003\u0006k.7\u0002\u0006\"-9";
                    n3 = 9;
                    continue block32;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u000e;*\u0003\u0014k3?\u0003\u0014&&*\u0014\u0007k'?\u0005\u0014";
                    n3 = 10;
                    continue block32;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\u000e;=\u0014\u00068c5\u0014\fk'?\u0005\u0014";
                    n3 = 11;
                    continue block32;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\b\"0\u001f\u001a?c.\u0003\u001a/6=\u0014U\n\u0010\u0010_Dk&0\u0012\u001a/*0\u0016";
                    n3 = 12;
                    continue block32;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\b\"0\u001f\u001a?c7\u001f\u001c?*?\u001d\u001c1&~\u0001\u00149\"3\u0014\u0001.1-";
                    n3 = 13;
                    continue block32;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "A$d{";
                    n3 = 14;
                    continue block32;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "A/d{Ukc~";
                    n3 = 15;
                    continue block32;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "A3d{";
                    n3 = 16;
                    continue block32;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u0002\u0001\u0013;6\u000e\u00132\u0004\u0006k\u00077\u0017\u0013\"&s9\u0010'/3\u0010\u001bk\u0013+\u0013\u0019\" ~:\u00102yT\bOA";
                    n3 = 17;
                    continue block32;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u001f+7\u0002U &'Q\u001c8c0\u001eU',0\u0016\u00109c(\u0010\u0019\"'";
                    n3 = 18;
                    continue block32;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "\u000f\u000b";
                    n3 = 19;
                    continue block32;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "\r\"7\u001d\u00009&~\u0018\u001bk\u0007\u0016!\u0000)/7\u0012>.:";
                    n3 = 20;
                    continue block32;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "\u0002-(\u0010\u0019\"'~\u001a\u00102c8\u001e\u0007&\"*";
                    n3 = 21;
                    continue block32;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "\r\"7\u001d\u00009&~\u0018\u001bk\u0007\u0016!\u0000)/7\u0012>.:";
                    n3 = 22;
                    continue block32;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "\b\"0\u001f\u001a?c.\u0003\u001a/6=\u0014U\n\u0010\u0010_Dk&0\u0012\u001a/*0\u0016";
                    n3 = 23;
                    continue block32;
                }
                case 23: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

