/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.IBMJCEFIPS;
import com.ibm.crypto.fips.provider.RSACore;
import com.ibm.crypto.fips.provider.RSAPadding;
import com.ibm.crypto.fips.provider.SelfTest;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;

public abstract class RSASignature
extends SignatureSpi {
    private static final int a = 8;
    private final ObjectIdentifier b;
    private final int c;
    private final MessageDigest d;
    private boolean e;
    private RSAPrivateKey f;
    private RSAPublicKey g;
    private RSAPadding h;
    private static final String[] z;

    RSASignature(String string, ObjectIdentifier objectIdentifier, int n2) {
        this.b = objectIdentifier;
        try {
            this.d = MessageDigest.getInstance(string, IBMJCEFIPS.getInstance());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.e = true;
        this.c = 8 + n2 + this.d.getDigestLength();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(publicKey);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    protected void a(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException(z[9]);
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        this.f = null;
        this.g = rSAPublicKey;
        this.a(rSAPublicKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(privateKey, null);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    protected void a(PrivateKey privateKey) throws InvalidKeyException {
        this.a(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(privateKey, secureRandom);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    protected void a(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey;
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException(z[10]);
        }
        this.f = rSAPrivateKey = (RSAPrivateKey)privateKey;
        this.g = null;
        this.a(rSAPrivateKey, secureRandom);
    }

    private void a(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.a();
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            this.h = RSAPadding.getInstance(1, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        int n3 = this.h.getMaxDataSize();
        if (this.c > n3) {
            throw new InvalidKeyException(z[1]);
        }
    }

    private void a() {
        if (!this.e) {
            this.d.reset();
            this.e = true;
        }
    }

    private byte[] b() {
        this.e = true;
        return this.d.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(by);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    protected void a(byte by) throws SignatureException {
        this.d.update(by);
        this.e = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(byArray, n2, n3);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    protected void a(byte[] byArray, int n2, int n3) throws SignatureException {
        this.d.update(byArray, n2, n3);
        this.e = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(byteBuffer);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    protected void a(ByteBuffer byteBuffer) {
        this.d.update(byteBuffer);
        this.e = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (SelfTest.isFipsRunnable()) {
            return this.c();
        }
        throw new FIPSRuntimeException();
    }

    protected byte[] c() throws SignatureException {
        byte[] byArray = this.b();
        try {
            byte[] byArray2 = RSASignature.encodeSignature(this.b, byArray);
            byte[] byArray3 = this.h.pad(byArray2);
            byte[] byArray4 = RSACore.rsa(byArray3, this.f, true);
            return byArray4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException(z[11], generalSecurityException);
        }
        catch (IOException iOException) {
            throw new SignatureException(z[12], iOException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(byArray);
        }
        throw new FIPSRuntimeException();
    }

    protected boolean a(byte[] byArray) throws SignatureException {
        if (byArray.length != RSACore.getByteLength(this.g)) {
            throw new SignatureException(z[6] + byArray.length + z[7] + RSACore.getByteLength(this.g));
        }
        byte[] byArray2 = this.b();
        try {
            byte[] byArray3 = RSACore.rsa(byArray, this.g);
            byte[] byArray4 = this.h.unpad(byArray3);
            byte[] byArray5 = RSASignature.decodeSignature(this.b, byArray4);
            return MessageDigest.isEqual(byArray2, byArray5);
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (IOException iOException) {
            throw new SignatureException(z[8], iOException);
        }
    }

    public static byte[] encodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        new AlgorithmId(objectIdentifier).encode(derOutputStream);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) throw new IOException(z[4]);
        if (derInputStream.available() != 0) {
            throw new IOException(z[4]);
        }
        AlgorithmId algorithmId = AlgorithmId.parse((DerValue)derValueArray[0]);
        if (!algorithmId.getOID().equals((Object)objectIdentifier)) {
            throw new IOException(z[2] + algorithmId.getOID());
        }
        if (algorithmId.getEncodedParams() == null) return derValueArray[1].getOctetString();
        throw new IOException(z[3]);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        if (SelfTest.isFipsRunnable()) {
            throw new UnsupportedOperationException(z[0]);
        }
        throw new FIPSRuntimeException();
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        if (SelfTest.isFipsRunnable()) {
            throw new UnsupportedOperationException(z[5]);
        }
        throw new FIPSRuntimeException();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[13];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "vd\u0000i%w`\u0019\\0`s\\\u0010dkn\u0000\u00197pq\u0004V6qd\u0010";
        int n3 = -1;
        block20: while (true) {
            char[] cArray;
            block25: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block24: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block24;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block25;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 5;
                                break;
                            }
                            case 1: {
                                n9 = 1;
                                break;
                            }
                            case 2: {
                                n9 = 116;
                                break;
                            }
                            case 3: {
                                n9 = 57;
                                break;
                            }
                            default: {
                                n9 = 68;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "Nd\r\u0019-v!\u0000V+%r\u001cV6q!\u0012V6%u\u001cP7%r\u001d^*du\u0001K!%`\u0018^+wh\u0000Q)";
                    n3 = 0;
                    continue block20;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "Jc\u001e\\'qH\u0010\\*qh\u0012P!w!\u0019P7h`\u0000Z,?!";
                    n3 = 1;
                    continue block20;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "Po\u0011A4`b\u0000\\ %@\u0018^+wh\u0000Q)LeTI%w`\u0019\\0`s\u0007";
                    n3 = 2;
                    continue block20;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "VD%l\u0001KB1\u0019(`o\u0013M,%d\u0006K+w";
                    n3 = 3;
                    continue block20;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "bd\u0000i%w`\u0019\\0`s\\\u0010dkn\u0000\u00197pq\u0004V6qd\u0010";
                    n3 = 4;
                    continue block20;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "Vh\u0013W%qt\u0006\\did\u001a^0m!\u001aV0%b\u001bK6`b\u0000\u0003dbn\u0000\u0019";
                    n3 = 5;
                    continue block20;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "%c\u0001Mdr`\u0007\u0019!}q\u0011Z0lo\u0013\u0019";
                    n3 = 6;
                    continue block20;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "Vh\u0013W%qt\u0006\\d`o\u0017V lo\u0013\u0019!ws\u001bK";
                    n3 = 7;
                    continue block20;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "Nd\r\u0019-v!\u001aV0%`\u001a\u0019\u0016V@$L&ih\u0017r!|";
                    n3 = 8;
                    continue block20;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "Nd\r\u0019-v!\u001aV0%`\u001a\u0019\u0016V@$K-s`\u0000\\\u000f`x";
                    n3 = 9;
                    continue block20;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "Fn\u0001U %o\u001bMdvh\u0013Wda`\u0000X";
                    n3 = 10;
                    continue block20;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "Fn\u0001U %o\u001bMd`o\u0017V `!\u0010X0d";
                    n3 = 11;
                    continue block20;
                }
                case 11: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

