/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.ByteAdder;
import com.ibm.crypto.fips.provider.CPUJitter;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.IBMJCEFIPS;
import com.ibm.crypto.fips.provider.IHashDrbg;
import com.ibm.crypto.fips.provider.SelfTest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;
import java.util.Arrays;

public final class HASHDRBG
extends SecureRandomSpi
implements IHashDrbg {
    private static final long serialVersionUID = 2596920209735836086L;
    public static final int MIN_STRENGTH = 112;
    public static final int MAX_STRENGTH = 256;
    public static final int SHA1_MAX_STRENGTH = 128;
    public static final int SHA224_MAX_STRENGTH = 192;
    public static final int MIN_SEED_LENGTH = 440;
    public static final int MAX_SEED_LENGTH = 888;
    public static final String DEFAULT_DIGEST_ALG;
    public static final int DEFAULT_STRENGTH = 256;
    private static final int MIN_SEED_BYTES = 55;
    private static final int MAX_SEED_BYTES = 111;
    private static final long MAX_UNTIL_RESEED = 0x1000000000000L;
    protected String hashAlgName;
    protected int security_strength = 0;
    protected int ss_bytes = 0;
    protected int seed_byte_count;
    protected ByteBuffer entropy;
    protected MessageDigest hash;
    private int seedlen;
    private int outlenbits;
    protected byte[] V;
    protected byte[] C;
    protected long reseed_counter = 0L;
    protected CPUJitter sr = null;
    protected boolean resistant;
    protected boolean initDone;
    private byte[] rngTestBuf;
    private boolean firstGen = true;
    private static final long SDRM_DRBG_MAX_NUM_BITS_PER_REQUEST = 0x100000L;
    private static final long SDRM_DRBG_MAX_ADD_INPUT_LENGTH = 0x1000000000L;
    private static final String[] z;

    public HASHDRBG() {
    }

    public HASHDRBG(String string, int n2) {
        this.security_strength = n2;
        if (n2 < 112) {
            throw new IllegalArgumentException(z[2]);
        }
        if (n2 > 256) {
            throw new IllegalArgumentException(z[4]);
        }
        this.hashAlgName = string;
        try {
            this.hash = MessageDigest.getInstance(string, IBMJCEFIPS.getInstance());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException(z[3] + string + z[5]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    protected byte[] engineGenerateSeed(int n2) {
        if (SelfTest.isFipsRunnable()) {
            return this.a(n2);
        }
        throw new FIPSRuntimeException();
    }

    protected byte[] a(int n2) {
        byte[] byArray = new byte[n2];
        this.engineNextBytes(byArray);
        return byArray;
    }

    @Override
    protected void engineNextBytes(byte[] byArray) {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(byArray);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void a(byte[] byArray) {
        byte[] byArray2;
        if (!this.initDone) {
            if (this.hashAlgName == null) {
                this.hashAlgName = z[16];
            }
            if (this.security_strength >= 0) {
                this.security_strength = 256;
            }
            this.engineSetSeed(null);
        }
        if ((byArray2 = this.generate(byArray.length, false, null)).length != byArray.length) throw new IllegalStateException(z[17]);
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
    }

    @Override
    protected void engineSetSeed(byte[] byArray) {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.b(byArray);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void b(byte[] byArray) {
        if (byArray == null || !SelfTest.isSelfTestInProgress()) {
            byArray = this.c(this.ss_bytes);
        }
        if (!this.initDone) {
            if (this.hashAlgName == null) {
                this.a(z[8], 256, ByteBuffer.wrap(byArray), false);
            } else {
                this.a(this.hashAlgName, this.security_strength, ByteBuffer.wrap(byArray), false);
            }
            if (byArray.length < this.ss_bytes) {
                throw new IllegalArgumentException(z[9] + this.ss_bytes + z[7]);
            }
        } else {
            if (byArray.length < this.ss_bytes) {
                throw new IllegalArgumentException(z[10] + this.ss_bytes + z[6]);
            }
            this.entropy = ByteBuffer.wrap(byArray, 0, this.ss_bytes);
        }
        if (this.reseed_counter >= 1L) {
            this.reseed(null);
            return;
        }
        byte[] byArray2 = new byte[]{};
        if (byArray.length > this.ss_bytes) {
            byArray2 = new byte[byArray.length - this.ss_bytes];
            System.arraycopy(byArray, this.ss_bytes, byArray2, 0, byArray.length - this.ss_bytes);
        }
        this.instantiate(byArray2, null);
    }

    @Override
    public int init(String string, int n2, ByteBuffer byteBuffer, boolean bl) throws IllegalArgumentException {
        ByteBuffer byteBuffer2;
        block3: {
            block2: {
                byteBuffer2 = null;
                if (!SelfTest.isSelfTestInProgress() && byteBuffer != null) break block2;
                byteBuffer2 = byteBuffer;
                break block3;
            }
            byteBuffer2 = ByteBuffer.wrap(this.c(byteBuffer.capacity()));
        }
        return this.a(string, n2, byteBuffer2, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int a(String string, int n2, ByteBuffer byteBuffer, boolean bl) throws IllegalArgumentException {
        block43: {
            byte[] byArray;
            block45: {
                block44: {
                    block42: {
                        if (string == null || !string.startsWith(z[26])) {
                            throw new IllegalArgumentException(z[19]);
                        }
                        if (this.hashAlgName != null && !this.hashAlgName.equalsIgnoreCase(string)) {
                            throw new IllegalStateException(z[22]);
                        }
                        try {
                            this.hash = MessageDigest.getInstance(string, IBMJCEFIPS.getInstance());
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            throw new IllegalArgumentException(z[25] + string + z[21]);
                        }
                        catch (Exception exception) {
                            throw new IllegalArgumentException(exception);
                        }
                        byArray = this.hash.digest();
                        this.seed_byte_count = 55;
                        this.seedlen = 440;
                        if (byArray == null || byArray.length < 20) {
                            throw new IllegalArgumentException(z[23]);
                        }
                        this.outlenbits = byArray.length << 3;
                        this.ss_bytes = n2 >> 3;
                        if (this.ss_bytes << 3 != n2) {
                            throw new IllegalArgumentException(z[27]);
                        }
                        if (n2 > 112) break block42;
                        n2 = 112;
                        break block43;
                    }
                    if (byArray.length != 20) break block44;
                    if (n2 > 128) {
                        throw new IllegalArgumentException(z[24]);
                    }
                    this.security_strength = 128;
                    break block43;
                }
                if (byArray.length != 28) break block45;
                if (n2 > 192) {
                    throw new IllegalArgumentException(z[18]);
                }
                if (n2 > 112 && n2 <= 128) {
                    this.security_strength = 128;
                    break block43;
                } else if (n2 > 128 && n2 <= 192) {
                    this.security_strength = 192;
                }
                break block43;
            }
            if (byArray.length > 32) {
                this.seed_byte_count = 111;
                this.seedlen = 888;
            }
            if (n2 > 256) {
                throw new IllegalArgumentException(z[20]);
            }
            if (n2 > 112 && n2 <= 128) {
                this.security_strength = 128;
            } else if (n2 > 128 && n2 <= 192) {
                this.security_strength = 192;
            } else if (n2 > 192 && n2 <= 256) {
                this.security_strength = 256;
            }
        }
        this.entropy = byteBuffer;
        this.resistant = bl;
        this.initDone = true;
        return this.security_strength;
    }

    @Override
    public void instantiate(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        int n2;
        int n3;
        block13: {
            block12: {
                n3 = 0;
                n2 = 0;
                if (byArray2 != null) {
                    n3 = byArray2.length;
                }
                if (byArray != null) {
                    n2 = byArray.length;
                }
                byArray3 = null;
                if (this.entropy != null && this.entropy.remaining() != 0) break block12;
                byArray3 = this.c(0);
                break block13;
            }
            byArray3 = new byte[this.ss_bytes];
            try {
                this.entropy.get(byArray3);
                this.entropy.flip();
            }
            catch (Exception exception) {
                throw new IllegalStateException(z[11], exception);
            }
        }
        byte[] byArray4 = new byte[byArray3.length + n2 + n3];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        if (n2 > 0) {
            System.arraycopy(byArray, 0, byArray4, byArray3.length, byArray.length);
        }
        if (n3 != 0) {
            System.arraycopy(byArray2, 0, byArray4, byArray3.length + n2, n3);
        }
        this.V = this.a(this.hash, this.outlenbits, byArray4, this.seedlen);
        byte[] byArray5 = new byte[this.V.length + 1];
        byArray5[0] = 0;
        System.arraycopy(this.V, 0, byArray5, 1, this.V.length);
        this.C = this.a(this.hash, this.outlenbits, byArray5, this.seedlen);
        this.reseed_counter = 1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] generate(int n2, boolean bl, byte[] byArray) {
        if ((long)(n2 << 3) > 0x100000L) {
            throw new IllegalArgumentException(z[12]);
        }
        if (byArray != null && (long)(byArray.length << 3) > 0x1000000000L) {
            throw new IllegalArgumentException(z[14]);
        }
        byte[] byArray2 = null;
        int n3 = n2 << 3;
        if (bl && !this.resistant) {
            throw new IllegalArgumentException(z[13]);
        }
        if (this.reseed_counter >= 0x1000000000000L || bl) {
            this.reseed(byArray);
            byArray = null;
        }
        if (byArray != null) {
            byte[] byArray3 = null;
            this.hash.update((byte)2);
            this.hash.update(this.V);
            byArray3 = this.hash.digest(byArray);
            this.V = ByteAdder.add(this.seed_byte_count, this.V, byArray3);
        }
        int n4 = this.a(n3, this.outlenbits);
        byte[] byArray4 = (byte[])this.V.clone();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int n5 = 1; n5 <= n4; ++n5) {
            try {
                byteArrayOutputStream.write(this.hash.digest(byArray4));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            byArray4 = ByteAdder.add(this.seed_byte_count, byArray4, HASHDRBG.b(1));
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length > n2) {
            byte[] byArray5 = new byte[n2];
            System.arraycopy(byArray2, 0, byArray5, 0, n2);
            byArray2 = byArray5;
        }
        byte[] byArray6 = null;
        this.hash.update((byte)3);
        byArray6 = this.hash.digest(this.V);
        this.V = ByteAdder.add(this.seed_byte_count, this.V, byArray6, this.C, HASHDRBG.b((int)this.reseed_counter));
        ++this.reseed_counter;
        return byArray2;
    }

    @Override
    public void reseed(byte[] byArray) {
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        if ((long)(n2 << 3) > 0x1000000000L) {
            throw new IllegalArgumentException(z[1]);
        }
        byte[] byArray2 = new byte[this.ss_bytes];
        try {
            this.entropy.get(byArray2);
            this.entropy.flip();
        }
        catch (Exception exception) {
            throw new IllegalStateException(z[0], exception);
        }
        byte[] byArray3 = new byte[1 + this.V.length + byArray2.length + n2];
        byArray3[0] = 1;
        int n3 = 1;
        System.arraycopy(this.V, 0, byArray3, n3, this.V.length);
        System.arraycopy(byArray2, 0, byArray3, n3 += this.V.length, byArray2.length);
        n3 += byArray2.length;
        if (n2 != 0) {
            System.arraycopy(byArray, 0, byArray3, n3, n2);
        }
        this.V = this.a(this.hash, this.outlenbits, byArray3, this.seedlen);
        byte[] byArray4 = new byte[this.V.length + 1];
        byArray4[0] = 0;
        System.arraycopy(this.V, 0, byArray4, 1, this.V.length);
        this.C = this.a(this.hash, this.outlenbits, byArray4, this.seedlen);
        this.reseed_counter = 1L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(MessageDigest messageDigest, int n2, byte[] byArray, int n3) {
        byte[] byArray2 = null;
        int n4 = this.a(n3, n2);
        int n5 = n3 + 7 >> 3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5);
        for (int n6 = 1; n6 <= n4; ++n6) {
            messageDigest.update((byte)n6);
            messageDigest.update(HASHDRBG.b(n3));
            try {
                byteArrayOutputStream.write(messageDigest.digest(byArray));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        if (byArray2.length > n5) {
            byte[] byArray3 = byArray2;
            byArray2 = new byte[n5];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        }
        return byArray2;
    }

    private static final void a(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 24);
        byArray[n3 + 1] = (byte)(n2 >>> 16);
        byArray[n3 + 2] = (byte)(n2 >>> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    private static final byte[] b(int n2) {
        byte[] byArray = new byte[4];
        HASHDRBG.a(n2, byArray, 0);
        return byArray;
    }

    private int a(int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException(z[15]);
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        int n4 = n2 / n3;
        if (n4 * n3 != n2) {
            ++n4;
        }
        return n4;
    }

    private byte[] c(int n2) {
        if (n2 <= 0) {
            n2 = 32;
        }
        if (this.sr == null) {
            try {
                this.sr = new CPUJitter();
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.sr.a(n2);
    }

    public void zeroize() {
        if (this.C != null) {
            Arrays.fill(this.C, (byte)0);
            this.C = null;
        }
        this.entropy = null;
        this.hash = null;
        this.sr = null;
        if (this.V != null) {
            Arrays.fill(this.V, (byte)0);
            this.V = null;
        }
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[28];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "%.m[;CP";
        int n3 = 27;
        block36: while (true) {
            char[] cArray;
            block41: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block40: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block40;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block41;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 118;
                                break;
                            }
                            case 1: {
                                n9 = 102;
                                break;
                            }
                            case 2: {
                                n9 = 44;
                                break;
                            }
                            case 3: {
                                n9 = 118;
                                break;
                            }
                            default: {
                                n9 = 9;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 27: {
                    DEFAULT_DIGEST_ALG = string.intern();
                    string2 = "\u0018\tXVl\u0018\tY\u0011aV\u0003B\u0002{\u0019\u0016U";
                    n3 = -1;
                    continue block36;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\"\u000eIV`\u0018\u0016Y\u0002)\u0006\u0007^\u0017d\u0013\u0012I\u0004)\u0013\u001eO\u0013l\u0012\u0015\f\u001al\u0018\u0001X\u001e)\u0004\u0003]\u0003`\u0004\u0003A\u0013g\u0002FJ\u0019{V\u0007H\u0012`\u0002\u000fC\u0018h\u001aFE\u0018y\u0003\u0012\u0002";
                    n3 = 0;
                    continue block36;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0002\tCV~\u0013\u0007G";
                    n3 = 1;
                    continue block36;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ">\u0007_\u001e)\u0017\nK\u0019{\u001f\u0012D\u001b)T";
                    n3 = 2;
                    continue block36;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0002\tCVz\u0002\u0014C\u0018n";
                    n3 = 3;
                    continue block36;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "TFE\u0005)\u0018\tXVO?6\u007fVj\u0019\u000b\\\u001a`\u0017\bXVo\u0019\u0014\f>H%.h$K1F\u007f\u0013j\u0003\u0014I$h\u0018\u0002C\u001b)\u001f\u000b\\\u001al\u001b\u0003B\u0002h\u0002\u000fC\u0018";
                    n3 = 4;
                    continue block36;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "V\u0004U\u0002l\u0005FC\u0010)\u0013\bX\u0004f\u0006\u001f";
                    n3 = 5;
                    continue block36;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "V\u0004U\u0002l\u0005FC\u0010)\u0013\bX\u0004f\u0006\u001f";
                    n3 = 6;
                    continue block36;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "%.m[;CP";
                    n3 = 7;
                    continue block36;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u0018\u0003I\u0012)\u0017\u0012\f\u001al\u0017\u0015XV";
                    n3 = 8;
                    continue block36;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "\u0018\u0003I\u0012)\u0017\u0012\f\u001al\u0017\u0015XV";
                    n3 = 9;
                    continue block36;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "\u0018\tXVl\u0018\tY\u0011aV\u0003B\u0002{\u0019\u0016U";
                    n3 = 10;
                    continue block36;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "\"\u000eIV`\u0018\u0016Y\u0002)\u0006\u0007^\u0017d\u0013\u0012I\u0004)\u0013\u001eO\u0013l\u0012\u0015\f\u001al\u0018\u0001X\u001e)\u0004\u0003]\u0003`\u0004\u0003A\u0013g\u0002F\\\u0013{V\u0014I\u0007|\u0013\u0015X";
                    n3 = 11;
                    continue block36;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "\u0006\u0014I\u0012`\u0015\u0012E\u0019gV\u0014I\u0005`\u0005\u0012M\u0018j\u0013FO\u0017y\u0017\u0004E\u001a`\u0002\u001f\f\u0018f\u0002FE\u0018z\u0002\u0007B\u0002`\u0017\u0012I\u0012";
                    n3 = 12;
                    continue block36;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "\"\u000eIV`\u0018\u0016Y\u0002)\u0006\u0007^\u0017d\u0013\u0012I\u0004)\u0013\u001eO\u0013l\u0012\u0015\f\u001al\u0018\u0001X\u001e)\u0004\u0003]\u0003`\u0004\u0003A\u0013g\u0002FJ\u0019{V\u0007H\u0012`\u0002\u000fC\u0018h\u001aFE\u0018y\u0003\u0012";
                    n3 = 13;
                    continue block36;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "\u0005\u0012^\u001fm\u0013FE\u0005)J[\f\fl\u0004\t";
                    n3 = 14;
                    continue block36;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "%.m[;CP";
                    n3 = 15;
                    continue block36;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "?\bX\u0013{\u0018\u0007@Vl\u0004\u0014C\u0004%V\u0011^\u0019g\u0011F@\u0013g\u0011\u0012DVf\u0003\u0012\\\u0003}V\u0001I\u0018l\u0004\u0007X\u0013m";
                    n3 = 16;
                    continue block36;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "\u0017\nK\u0019{\u001f\u0012D\u001b)\u0018\tXVz\u0002\u0014C\u0018nV\u0003B\u0019|\u0011\u000e";
                    n3 = 17;
                    continue block36;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "\u0019\b@\u000f)\u0005\u0013\\\u0006f\u0004\u0012\f\u0002a\u0013F\u007f>HV\u0000M\u001b`\u001a\u001f";
                    n3 = 18;
                    continue block36;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "\u0017\nK\u0019{\u001f\u0012D\u001b)\u0018\tXVz\u0002\u0014C\u0018nV\u0003B\u0019|\u0011\u000e";
                    n3 = 19;
                    continue block36;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "TFE\u0005)\u0018\tXVO?6\u007fVj\u0019\u000b\\\u001a`\u0017\bXVo\u0019\u0014\f>H%.h$K1F\u007f\u0013j\u0003\u0014I$h\u0018\u0002C\u001b)\u001f\u000b\\\u001al\u001b\u0003B\u0002h\u0002\u000fC\u0018";
                    n3 = 20;
                    continue block36;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "\u0015\u0007B\u0018f\u0002FE\u0018`\u0002F[\u001f}\u001eFH\u001fo\u0010\u0003^\u0013g\u0002FD\u0017z\u001eFM\u001an\u0019\u0014E\u0002a\u001b";
                    n3 = 21;
                    continue block36;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "\u0017\nK\u0019{\u001f\u0012D\u001b)\u0018\tXVz\u0002\u0014C\u0018nV\u0003B\u0019|\u0011\u000e";
                    n3 = 22;
                    continue block36;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "\u0017\nK\u0019{\u001f\u0012D\u001b)\u0018\tXVz\u0002\u0014C\u0018nV\u0003B\u0019|\u0011\u000e";
                    n3 = 23;
                    continue block36;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = ">\u0007_\u001e)\u0017\nK\u0019{\u001f\u0012D\u001b)T";
                    n3 = 24;
                    continue block36;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "%.m";
                    n3 = 25;
                    continue block36;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "\u0018\u0003I\u0012)\u0014\u001fX\u0013)V\u000bY\u001a}\u001f\u0016@\u0013)\u0010\t^Vk\u001f\u0012\u007f\u0002{\u0013\bK\u0002a$\u0003]\u0003l\u0005\u0012I\u0012";
                    n3 = 26;
                    continue block36;
                }
                case 26: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

