/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.plugins.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassInfo {
    private final List<String> ifaces = new ArrayList<String>();
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final String classname;
    private final URL url;
    private String superclass = null;

    public ClassInfo(String classname, URL url) {
        this.classname = classname;
        this.url = url;
    }

    public List<String> getInterfaces() {
        return this.ifaces;
    }

    public void addInterface(String iface) {
        this.ifaces.add(iface);
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean hasInterface(Class<?> iface) {
        return this.ifaces.contains(iface.getName());
    }

    public boolean hasInterface(String iface) {
        return this.ifaces.contains(iface);
    }

    public boolean hasAnnotation(String classname) {
        Annotation annotation = new Annotation(classname);
        return this.annotations.contains(annotation);
    }

    public Annotation getAnnotation(String classname) {
        Annotation annotation = new Annotation(classname);
        int index = this.annotations.indexOf(annotation);
        if (index == -1) {
            return null;
        }
        return this.annotations.get(index);
    }

    public Annotation addAnnotation(String classname) {
        int index = this.annotations.indexOf(classname);
        if (index == -1) {
            Annotation a = new Annotation(classname);
            this.annotations.add(a);
            return a;
        }
        return this.annotations.get(index);
    }

    public String getClassname() {
        return this.classname;
    }

    public URL getURL() {
        return this.url;
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(String superclass) {
        this.superclass = superclass;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClassInfo)) {
            return false;
        }
        ClassInfo compareTo = (ClassInfo)o;
        return this.classname.equals(compareTo.classname);
    }

    public int hashCode() {
        return this.classname.hashCode();
    }
}

