/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.error.ExceptionInfo;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants$Actions;
import com.ibm.gsk.ikeyman.gui.MessageDialog$1;
import com.ibm.gsk.ikeyman.gui.MessageDialog$ButtonState;
import com.ibm.gsk.ikeyman.gui.controls.ButtonFactory;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class MessageDialog
extends CenteredDialog {
    private static final long serialVersionUID = 1L;
    private JButton moreLessBtn = null;
    private JLabel solutionLabel;
    private JTextArea solutionArea;
    private JLabel detailsLabel;
    private JTextArea detailsArea;
    private MessageDialog$ButtonState buttonState = MessageDialog$ButtonState.More;
    private JTextArea userMsgArea = null;
    private JPanel morePanel = null;
    private OKResetCancelButtonPanel buttonPanel = null;

    protected MessageDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    public MessageDialog(Frame frame, String string, ExceptionInfo exceptionInfo) {
        this(frame);
        this.populateFields(string, exceptionInfo);
    }

    private void initialize() {
        this.setSize(390, 188);
        this.setModal(true);
        this.setResizable(true);
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.getRootPane().setDefaultButton(this.getButtonPanel().getOkBtn());
        this.centerToParent();
        this.setName(ControlNames.MessageDialog.toString());
    }

    private JPanel getJContentPane() {
        this.userMsgArea = new JTextArea();
        this.userMsgArea.setLineWrap(true);
        this.userMsgArea.setEditable(false);
        this.userMsgArea.setWrapStyleWord(true);
        this.userMsgArea.setRows(4);
        this.userMsgArea.getAccessibleContext().setAccessibleDescription(ControlNames.MessageDialogUserMessageField.toString());
        this.userMsgArea.setName(ControlNames.MessageDialogUserMessageField.toString());
        this.solutionArea = new JTextArea();
        this.solutionArea.setEditable(false);
        this.solutionArea.setRows(4);
        this.solutionArea.setLineWrap(true);
        this.solutionArea.setWrapStyleWord(true);
        this.solutionArea.getAccessibleContext().setAccessibleDescription(ControlNames.MessageDialogSolutionField.toString());
        this.solutionArea.setName(ControlNames.MessageDialogSolutionField.toString());
        this.detailsArea = new JTextArea();
        this.detailsArea.setEditable(false);
        this.detailsArea.setRows(4);
        this.detailsArea.setLineWrap(true);
        this.detailsArea.setWrapStyleWord(true);
        this.detailsArea.getAccessibleContext().setAccessibleDescription(ControlNames.MessageDialogDetailsField.toString());
        this.detailsArea.setName(ControlNames.MessageDialogDetailsField.toString());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.moreLessBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.More"), ControlNames.MessageDialogMoreLessButton);
        this.moreLessBtn.addActionListener(new MessageDialog$1(this));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 50, 5, 5);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.moreLessBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.getMorePanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.getButtonPanel(), gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(new Dimension(372, 67));
        jScrollPane.setViewportView(this.userMsgArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
        return jPanel;
    }

    private JPanel getMorePanel() {
        if (this.morePanel == null) {
            this.morePanel = new JPanel();
            this.morePanel.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            jLabel.setText(Messages.getString("Label.Solution"));
            jLabel.setName(ControlNames.MessageDialogSolutionLabel.toString());
            jLabel.getAccessibleContext().setAccessibleName(jLabel.getText());
            this.solutionLabel = jLabel;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            this.morePanel.add((Component)jLabel, gridBagConstraints);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.solutionArea);
            jLabel.setLabelFor(this.solutionArea);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.gridy = 0;
            this.morePanel.add((Component)jScrollPane, gridBagConstraints);
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("Label.Details"));
            jLabel.setName(ControlNames.MessageDialogDetailsLabel.toString());
            jLabel.getAccessibleContext().setAccessibleName(jLabel.getText());
            this.detailsLabel = jLabel;
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            this.morePanel.add((Component)jLabel, gridBagConstraints);
            jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.detailsArea);
            jLabel.setLabelFor(this.detailsArea);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 5, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.gridy = 1;
            this.morePanel.add((Component)jScrollPane, gridBagConstraints);
            this.morePanel.setVisible(false);
        }
        return this.morePanel;
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(new GUIConstants$Actions[]{GUIConstants$Actions.OK});
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    private void populateFields(String string, ExceptionInfo exceptionInfo) {
        if (exceptionInfo != null) {
            this.userMsgArea.setText("");
            if (string != null && string.trim().length() > 0) {
                this.userMsgArea.append(string + "\n");
            }
            this.userMsgArea.append(exceptionInfo.getUserMessage());
            this.userMsgArea.setSelectionStart(0);
            this.userMsgArea.setSelectionEnd(0);
            this.userMsgArea.getAccessibleContext().setAccessibleName(this.userMsgArea.getText());
            this.solutionArea.setText(exceptionInfo.getSolutionMessage());
            this.solutionArea.setSelectionStart(0);
            this.solutionArea.setSelectionEnd(0);
            this.solutionArea.getAccessibleContext().setAccessibleName(this.solutionLabel.getText() + this.solutionArea.getText());
            this.detailsArea.setText(exceptionInfo.getDetails());
            this.detailsArea.setSelectionStart(0);
            this.detailsArea.setSelectionEnd(0);
            this.detailsArea.getAccessibleContext().setAccessibleName(this.detailsLabel.getText() + this.detailsArea.getText());
            this.moreLessBtn.setVisible(true);
        } else {
            this.userMsgArea.setText(string);
            this.userMsgArea.setSelectionStart(0);
            this.userMsgArea.setSelectionEnd(0);
            this.userMsgArea.getAccessibleContext().setAccessibleName(this.userMsgArea.getText());
            this.moreLessBtn.setVisible(false);
        }
        this.setTitle(Messages.getString("GUI.Title.Message"));
    }

    public void setExceptionInfo(ExceptionInfo exceptionInfo) {
        this.populateFields(null, exceptionInfo);
    }

    public void setMessage(String string) {
        this.populateFields(string, null);
    }

    private void moreLessHandler() {
        if (this.buttonState.equals((Object)MessageDialog$ButtonState.More)) {
            this.getMorePanel().setVisible(true);
            this.moreLessBtn.setText(Messages.getStringWithMnemonics("Label.Less"));
            this.buttonState = MessageDialog$ButtonState.Less;
        } else {
            this.getMorePanel().setVisible(false);
            this.moreLessBtn.setText(Messages.getStringWithMnemonics("Label.More"));
            this.buttonState = MessageDialog$ButtonState.More;
        }
        this.pack();
    }

    protected void okHandler() {
        this.setVisible(false);
    }

    protected void resetHandler() {
    }

    static void access$000(MessageDialog messageDialog) {
        messageDialog.moreLessHandler();
    }
}

