/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSACore;
import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.crypto.provider.RSAPadding;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;

public abstract class RSASignature
extends SignatureSpi {
    private static final int a = 8;
    private final ObjectIdentifier b;
    private final int c;
    private final MessageDigest d;
    private boolean e;
    private RSAPrivateKey f;
    private RSAPublicKey g;
    private RSAPadding h;
    private static final char[] i;
    private static final String[] z;

    RSASignature(String string, ObjectIdentifier objectIdentifier, int n2) {
        this.b = objectIdentifier;
        try {
            this.d = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.e = true;
        this.c = 8 + n2 + this.d.getDigestLength();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.f = null;
        this.g = rSAPublicKey;
        this.a(rSAPublicKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey;
        this.f = rSAPrivateKey = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.g = null;
        this.a(rSAPrivateKey, secureRandom);
    }

    private void a(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.a();
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            RSAUtil.checkParamsAgainstType((RSAUtil.KeyType)RSAUtil.KeyType.RSA, (AlgorithmParameterSpec)rSAKey.getParams());
        }
        catch (ProviderException providerException) {
            throw new InvalidKeyException(z[1], providerException);
        }
        try {
            this.h = RSAPadding.getInstance(1, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        int n3 = this.h.getMaxDataSize();
        if (this.c > n3) {
            throw new InvalidKeyException(z[0]);
        }
    }

    private void a() {
        if (!this.e) {
            this.d.reset();
            this.e = true;
        }
    }

    private byte[] b() {
        this.e = true;
        return this.d.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.d.update(by);
        this.e = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.d.update(byArray, n2, n3);
        this.e = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.d.update(byteBuffer);
        this.e = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.f == null) {
            throw new SignatureException(z[6]);
        }
        byte[] byArray = this.b();
        try {
            byte[] byArray2 = RSASignature.encodeSignature(this.b, byArray);
            byte[] byArray3 = this.h.pad(byArray2);
            if (byArray3 != null) {
                return RSACore.rsa(byArray3, this.f, true);
            }
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new SignatureException(z[7], exception);
        }
        throw new SignatureException(z[5]);
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.g == null) {
            throw new SignatureException(z[2]);
        }
        if (byArray.length != RSACore.getByteLength(this.g)) {
            throw new SignatureException(z[4] + byArray.length + z[3] + RSACore.getByteLength(this.g));
        }
        try {
            byte[] byArray2 = RSACore.rsa(byArray, this.g);
            byte[] byArray3 = this.b();
            byte[] byArray4 = RSASignature.encodeSignature(this.b, byArray3);
            byte[] byArray5 = this.h.pad(byArray4);
            if (MessageDigest.isEqual(byArray5, byArray2)) {
                return true;
            }
            byArray4 = RSASignature.a(this.b, byArray3);
            byArray5 = this.h.pad(byArray4);
            return MessageDigest.isEqual(byArray5, byArray2);
        }
        catch (IOException | BadPaddingException exception) {
            return false;
        }
    }

    public static String bytesToHex(byte[] byArray) {
        if (byArray == null) {
            return new String(z[9]);
        }
        char[] cArray = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[i2 * 2] = i[n2 >>> 4];
            cArray[i2 * 2 + 1] = i[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] encodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        new AlgorithmId(objectIdentifier).encode(derOutputStream);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    static byte[] a(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(objectIdentifier);
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray, 0, byArray.length, false);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) throw new IOException(z[13]);
        if (derInputStream.available() != 0) {
            throw new IOException(z[13]);
        }
        AlgorithmId algorithmId = AlgorithmId.parse((DerValue)derValueArray[0]);
        if (!algorithmId.getOID().equals((Object)objectIdentifier)) {
            throw new IOException(z[14] + algorithmId.getOID());
        }
        if (algorithmId.getEncodedParams() == null) return derValueArray[1].getOctetString();
        throw new IOException(z[12]);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[11]);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException(z[8]);
        }
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException(z[10]);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block36: {
            int n2;
            int n3;
            block35: {
                String string;
                String[] stringArray = new String[15];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n4 = 0;
                String string2 = "fn!_\\^+,\u0010Z\rx0\u0010GY+>\u0010G\r\u007f0\u0016F\rx1\u0018[L\u007f-\rP\rj4\u0018Z_b,\u0017X";
                int n5 = -1;
                block28: while (true) {
                    char[] cArray2;
                    block34: {
                        int n6;
                        block33: {
                            char[] cArray3 = string2.toCharArray();
                            cArray2 = cArray3;
                            n6 = cArray3.length;
                            n3 = 0;
                            if (!true) break block33;
                            n6 = n6;
                            if (n6 <= n3) break block34;
                        }
                        do {
                            int n7;
                            cArray2 = cArray2;
                            int n8 = n3;
                            char c2 = cArray2[n8];
                            switch (n3 % 5) {
                                case 0: {
                                    n7 = 45;
                                    break;
                                }
                                case 1: {
                                    n7 = 11;
                                    break;
                                }
                                case 2: {
                                    n7 = 88;
                                    break;
                                }
                                case 3: {
                                    n7 = 127;
                                    break;
                                }
                                default: {
                                    n7 = 53;
                                }
                            }
                            cArray2[n8] = (char)(c2 ^ n7);
                            ++n3;
                            n6 = n6;
                        } while (n6 > n3);
                    }
                    string = new String(cArray2);
                    switch (n5) {
                        default: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 1;
                            string2 = "de.\u001eYDox\u0014PT+>\u0010G\rY\u000b>\u0015^b?\u0011TY~*\u001aF";
                            n5 = 0;
                            continue block28;
                        }
                        case 0: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 2;
                            string2 = "`b+\f\\Clx\u000f@Og1\u001c\u0015Fn!";
                            n5 = 1;
                            continue block28;
                        }
                        case 1: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 3;
                            string2 = "\ri-\u000b\u0015Zj+_PU{=\u001cADe?_";
                            n5 = 2;
                            continue block28;
                        }
                        case 2: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 4;
                            string2 = "oj<_FDl6\u001eAXy=_YHe?\u000b]\u0017+?\u0010A\r";
                            n5 = 3;
                            continue block28;
                        }
                        case 3: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 5;
                            string2 = "nd-\u0013Q\re7\u000b\u0015^b?\u0011\u0015Ij,\u001e";
                            n5 = 4;
                            continue block28;
                        }
                        case 4: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 6;
                            string2 = "`b+\f\\Clx\u000fGD}9\u000bP\r`=\u0006";
                            n5 = 5;
                            continue block28;
                        }
                        case 5: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 7;
                            string2 = "nd-\u0013Q\re7\u000b\u0015^b?\u0011\u0015Ij,\u001e";
                            n5 = 6;
                            continue block28;
                        }
                        case 6: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 8;
                            string2 = "cdx\u000fT_j5\u001aAHy+_TNh=\u000fAHo";
                            n5 = 7;
                            continue block28;
                        }
                        case 7: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 9;
                            string2 = "\u0000e-\u0013Y\u0000";
                            n5 = 8;
                            continue block28;
                        }
                        case 8: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 10;
                            string2 = "Jn,/T_j5\u001aAHypV\u0015Cd,_FX{(\u0010GYn<";
                            n5 = 9;
                            continue block28;
                        }
                        case 9: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 11;
                            string2 = "^n,/T_j5\u001aAHypV\u0015Cd,_FX{(\u0010GYn<";
                            n5 = 10;
                            continue block28;
                        }
                        case 10: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 12;
                            string2 = "xe=\u0007EHh,\u001aQ\rJ4\u0018Z_b,\u0017Xdox\u000fT_j5\u001aAHy+";
                            n5 = 11;
                            continue block28;
                        }
                        case 11: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 13;
                            string2 = "~N\t*pcH\u001d_YHe?\u000b]\rn*\rZ_";
                            n5 = 12;
                            continue block28;
                        }
                        case 12: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 14;
                            string2 = "bi2\u001aVYB<\u001a[Yb>\u0016P_+5\u0016F@j,\u001c]\u0017+";
                            n5 = 13;
                            continue block28;
                        }
                        case 13: 
                    }
                    break;
                }
                stringArray2[n4] = string.intern();
                z = stringArray3;
                char[] cArray4 = "\u001d:jL\u0001\u0018=oG\flI\u001b;pk".toCharArray();
                cArray = cArray4;
                n2 = cArray4.length;
                n3 = 0;
                if (!true) break block35;
                n2 = n2;
                if (n2 <= n3) break block36;
            }
            do {
                int n9;
                cArray = cArray;
                int n10 = n3;
                char c3 = cArray[n10];
                switch (n3 % 5) {
                    case 0: {
                        n9 = 45;
                        break;
                    }
                    case 1: {
                        n9 = 11;
                        break;
                    }
                    case 2: {
                        n9 = 88;
                        break;
                    }
                    case 3: {
                        n9 = 127;
                        break;
                    }
                    default: {
                        n9 = 53;
                    }
                }
                cArray[n10] = (char)(c3 ^ n9);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        i = new String(cArray).intern().toCharArray();
    }
}

