/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.crypto.provider.IBMJCE;
import com.ibm.crypto.provider.PrimeCurve;
import com.ibm.crypto.provider.PrimeField;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import java.util.Set;

public class ECParameters
extends AlgorithmParametersSpi {
    protected int a;
    protected EllipticCurve b;
    protected ECPoint c;
    protected BigInteger d;
    private static final String[] z;

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        byte[] byArray = this.encodeECParameters();
        return byArray;
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        try {
            Class<T> clazz2 = Class.forName(z[26]);
            if (clazz2.isAssignableFrom(clazz)) {
                return (T)((AlgorithmParameterSpec)clazz.cast(new ECParameterSpec(this.b, this.c, this.d, this.a)));
            }
            throw new InvalidParameterSpecException(z[24]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(z[25] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        ECParameterSpec eCParameterSpec;
        block9: {
            if (algorithmParameterSpec == null) {
                throw new InvalidParameterSpecException(z[2]);
            }
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            } else {
                if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                    String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
                    eCParameterSpec = ECNamedCurve.getECParameterSpec(string);
                    if (eCParameterSpec == null) {
                        throw new InvalidParameterSpecException(z[0] + string);
                    }
                    break block9;
                }
                throw new InvalidParameterSpecException(z[1]);
            }
        }
        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        ECParameterSpec eCParameterSpec = ECParameters.decodeECParameters(byArray);
        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        return z[8] + this.b.getA() + z[3] + this.b.getB() + z[4] + this.b.getField().getFieldSize() + z[6] + ECUtils.a(this.c) + z[5] + this.d.toString() + z[7] + this.a + "\n";
    }

    protected static AlgorithmParameters a(ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(z[21], IBMJCE.getInstance());
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidParameterSpecException(z[20] + generalSecurityException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n3 = ellipticCurve.getField().getFieldSize();
        int n2 = n3 + 7 >> 3;
        byte[] byArray2 = ECParameters.a(eCPoint.getAffineX().toByteArray());
        byte[] byArray = ECParameters.a(eCPoint.getAffineY().toByteArray());
        if (byArray2.length <= n2 && byArray.length <= n2) {
            byte[] byArray3 = new byte[1 + (n2 << 1)];
            byArray3[0] = 4;
            System.arraycopy(byArray2, 0, byArray3, n2 - byArray2.length + 1, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
            return byArray3;
        }
        throw new RuntimeException(z[22]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException(z[17]);
        }
        int n2 = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        if (byArray.length != n2 * 2 + 1) {
            throw new IOException(z[16]);
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        System.arraycopy(byArray, n2 + 1, byArray3, 0, n2);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] a(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < byArray.length - 1 && byArray[n2] == 0; ++n2) {
        }
        if (n2 == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static DerValue encodeEllipticCurve(EllipticCurve ellipticCurve) throws IOException {
        try {
            byte[] byArray = ECParameters.a(ellipticCurve.getA().toByteArray());
            byte[] byArray2 = ECParameters.a(ellipticCurve.getB().toByteArray());
            byte[] byArray3 = ellipticCurve.getSeed();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(byArray);
            derOutputStream.putOctetString(byArray2);
            if (byArray3 != null) {
                derOutputStream.putBitString(byArray3);
            }
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[27] + iOException);
        }
    }

    public static EllipticCurve decodeEllipticCurve(DerValue derValue, ECField eCField) throws IOException {
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[18]);
            }
            DerInputStream derInputStream = derValue.getData();
            byte[] byArray = derInputStream.getOctetString();
            BigInteger bigInteger = new BigInteger(1, byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            byte[] byArray3 = null;
            if (derInputStream.available() != 0) {
                byArray3 = derInputStream.getBitString();
            }
            PrimeCurve primeCurve = null;
            int n2 = 0;
            if (ECUtils.isNistPrime(((ECFieldFp)eCField).getP())) {
                n2 = 1;
            }
            primeCurve = byArray3 == null ? ECUtils.getCurve((PrimeField)eCField, bigInteger, bigInteger2, n2) : ECUtils.getCurve((PrimeField)eCField, bigInteger, bigInteger2, byArray3, n2);
            return primeCurve;
        }
        catch (IOException iOException) {
            throw new IOException(z[19] + iOException);
        }
    }

    public static DerValue encodePrimeFieldType(ECFieldFp eCFieldFp) throws IOException {
        try {
            int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
            BigInteger bigInteger = eCFieldFp.getP();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            derOutputStream.putInteger(bigInteger);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[23] + iOException);
        }
    }

    public static ECFieldFp decodePrimeFieldType(DerValue derValue) throws IOException {
        int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[11]);
            }
            DerInputStream derInputStream = derValue.getData();
            ObjectIdentifier objectIdentifier2 = derInputStream.getOID();
            if (!objectIdentifier2.equals(objectIdentifier)) {
                throw new IOException(z[9]);
            }
            BigInteger bigInteger = derInputStream.getInteger();
            ECFieldFp eCFieldFp = (ECFieldFp)((Object)ECUtils.getField(bigInteger.bitLength(), bigInteger, ECUtils.isNistPrime(bigInteger)));
            return eCFieldFp;
        }
        catch (IOException iOException) {
            throw new IOException(z[10] + iOException);
        }
    }

    public byte[] encodeECParameters() throws IOException {
        try {
            EllipticCurve ellipticCurve = this.b;
            ECPoint eCPoint = this.c;
            BigInteger bigInteger = this.d;
            int n2 = this.a;
            ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
            ECNamedCurve eCNamedCurve = ECParameters.getNamedCurve(eCParameterSpec);
            if (eCNamedCurve != null) {
                return eCNamedCurve.a();
            }
            ECField eCField = ellipticCurve.getField();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                throw new IOException(z[15]);
            }
            DerValue derValue = ECParameters.encodePrimeFieldType((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = ECParameters.encodeEllipticCurve(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = ECParameters.encodePoint(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IOException(z[14] + iOException);
        }
    }

    public static ECParameterSpec decodeECParameters(byte[] byArray) throws IOException {
        boolean bl2 = false;
        try {
            DerValue derValue;
            block5: {
                block6: {
                    DerInputStream derInputStream = new DerInputStream(byArray);
                    derValue = derInputStream.getDerValue();
                    if (derValue.getTag() == 48) break block5;
                    if (derValue.getTag() != 6) break block6;
                    String string = derValue.getOID().toString();
                    return ECNamedCurve.getECParameterSpec(string);
                }
                throw new IOException(z[13]);
            }
            DerInputStream derInputStream = derValue.getData();
            int n2 = derInputStream.getInteger().intValue();
            DerValue derValue2 = derInputStream.getDerValue();
            ECFieldFp eCFieldFp = ECParameters.decodePrimeFieldType(derValue2);
            DerValue derValue3 = derInputStream.getDerValue();
            EllipticCurve ellipticCurve = ECParameters.decodeEllipticCurve(derValue3, eCFieldFp);
            byte[] byArray2 = derInputStream.getOctetString();
            ECPoint eCPoint = ECParameters.decodePoint(byArray2, ellipticCurve);
            BigInteger bigInteger = derInputStream.getBigInteger();
            int n3 = 0;
            if (derInputStream.available() != 0) {
                bl2 = true;
                n3 = derInputStream.getInteger().intValue();
            }
            ECParameterSpec eCParameterSpec = null;
            eCParameterSpec = bl2 ? new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n3) : new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, 0);
            return eCParameterSpec;
        }
        catch (IOException iOException) {
            throw new IOException(z[12] + iOException);
        }
    }

    public static ECNamedCurve getNamedCurve(ECParameterSpec eCParameterSpec) {
        try {
            Map<String, ECParameterSpec> map = ECNamedCurve.b();
            Set<Map.Entry<String, ECParameterSpec>> set = map.entrySet();
            for (Map.Entry<String, ECParameterSpec> entry : set) {
                ECParameterSpec eCParameterSpec2;
                String string;
                block43: {
                    byte[] byArray;
                    byte[] byArray2;
                    block42: {
                        string = entry.getKey();
                        eCParameterSpec2 = entry.getValue();
                        eCParameterSpec2 = ECUtils.getPrimeParameterSpec(eCParameterSpec2);
                        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
                        BigInteger bigInteger = eCParameterSpec2.getCurve().getA();
                        BigInteger bigInteger2 = eCParameterSpec.getCurve().getA();
                        BigInteger bigInteger3 = eCParameterSpec2.getCurve().getB();
                        BigInteger bigInteger4 = eCParameterSpec.getCurve().getB();
                        int n2 = eCParameterSpec2.getCurve().getField().getFieldSize();
                        int n3 = eCParameterSpec.getCurve().getField().getFieldSize();
                        byArray2 = eCParameterSpec2.getCurve().getSeed();
                        byArray = eCParameterSpec.getCurve().getSeed();
                        if (!bigInteger.equals(bigInteger2) || !bigInteger3.equals(bigInteger4)) continue;
                        if (n2 != n3) {
                            continue;
                        }
                        if (byArray2 != null || byArray != null) break block42;
                        break block43;
                    }
                    if (byArray2 == null && byArray != null) {
                        continue;
                    }
                    if (byArray2 != null && byArray == null) {
                        continue;
                    }
                    if (byArray2 == null || byArray == null) break block43;
                    if (byArray2.length != byArray.length) {
                        continue;
                    }
                    boolean bl2 = true;
                    int n4 = 0;
                    while (true) {
                        block47: {
                            if (n4 >= byArray2.length) break;
                            if (byArray2[n4] == byArray[n4]) break block47;
                            bl2 = false;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl2) {
                        continue;
                    }
                }
                if (!eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator())) {
                    continue;
                }
                if (!eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder())) {
                    continue;
                }
                if (eCParameterSpec2.getCofactor() != eCParameterSpec.getCofactor()) {
                    continue;
                }
                ECNamedCurve eCNamedCurve = new ECNamedCurve(string);
                return eCNamedCurve;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[28];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "D|(\u001d-f|c\u00107cd&Ib";
        int n3 = -1;
        block35: while (true) {
            char[] cArray;
            block39: {
                int n4;
                int n5;
                block38: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block38;
                    n5 = n5;
                    if (n5 <= n4) break block39;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 17;
                            break;
                        }
                        case 1: {
                            n6 = 18;
                            break;
                        }
                        case 2: {
                            n6 = 67;
                            break;
                        }
                        case 3: {
                            n6 = 115;
                            break;
                        }
                        default: {
                            n6 = 66;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "X|\"\u00032c}3\u0001+pf&S2p`\"\u001e'ew1S1aw \u001a$xq\"\u0007+~|";
                    n3 = 0;
                    continue block35;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "as1\u0012/Bb&\u0010b|g0\u0007b\u007f}7S t2-\u0006.}";
                    n3 = 1;
                    continue block35;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u001b\u001bJ\u0011x1";
                    n3 = 2;
                    continue block35;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u001b\u001bJ\u0000+kwyS";
                    n3 = 3;
                    continue block35;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u001b\u001b,\u0001&t`ySH\u0018\u001b";
                    n3 = 4;
                    continue block35;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001b\u001b$\u0016,t`\"\u0007-c(cyK\u0018";
                    n3 = 5;
                    continue block35;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "\u001b\u001b \u001c$pq7\u001c0+2";
                    n3 = 6;
                    continue block35;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "\u001b\u001b \u00060gwySH\u0018\u001b\"Ib";
                    n3 = 7;
                    continue block35;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "X| \u001c0cw \u0007b^[\u0007S'\u007fq,\u0006,ew1\u0016&1v6\u0001+\u007fuc\u0017'r}'\u0016\u0012c{.\u0016\u0004xw/\u0017\u0016hb&]";
                    n3 = 8;
                    continue block35;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "Tj \u00162e{,\u001dbx|c\u0017'r}'\u0016\u0012c{.\u0016\u0004xw/\u0017\u0016hb&[k+2";
                    n3 = 9;
                    continue block35;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "_}7S#1A\u0006\"\u0017T\\\u00006";
                    n3 = 10;
                    continue block35;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "Tj \u00162e{,\u001dbx|c\u0017'r}'\u0016\u0007RB\"\u0001#|w7\u00160b:jIb";
                    n3 = 11;
                    continue block35;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "_}7S#1A\u0006\"\u0017T\\\u00006b~`c\u0012,1]\n7";
                    n3 = 12;
                    continue block35;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "Tj \u00162e{,\u001dbx|c\u0016,r}'\u0016\u0007RB\"\u0001#|w7\u00160b:jIb";
                    n3 = 13;
                    continue block35;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "TQ\u0005\u001a'}v\u0005A/1w-\u0010-d|7\u00160tvc\u001a,1w-\u0010-uw\u00060\u0012p`\"\u001e'ew1\u0000j8<cS\u0007RT*\u0016.uTq\u001ebxac\u001d-e2 \u00060cw-\u0007.h20\u00062a}1\u0007'u<";
                    n3 = 14;
                    continue block35;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "A}*\u001d61v,\u001611|,\u0007b|s7\u0010*1t*\u0016.u20\u001a8t";
                    n3 = 15;
                    continue block35;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "^|/\nbd| \u001c/a`&\u00001tvc\u0003-x|7S$~`.\u001261a6\u00032~`7\u0016&";
                    n3 = 16;
                    continue block35;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "_}7S#1A\u0006\"\u0017T\\\u00006";
                    n3 = 17;
                    continue block35;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "Tj \u00162e{,\u001dbx|c\u0017'r}'\u0016\u0007}~*\u00036xq\u0000\u00060gwkZx1";
                    n3 = 18;
                    continue block35;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "D|0\u00062a}1\u0007'u23\u00120p\u007f&\u0007'c20\u0003'r{%\u001a!pf*\u001c,+2";
                    n3 = 19;
                    continue block35;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "TQ";
                    n3 = 20;
                    continue block35;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "A}*\u001d61q,\u001c0u{-\u00126tac\u0017-1|,\u0007b|s7\u0010*1t*\u0016.u20\u001a8t";
                    n3 = 21;
                    continue block35;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "Tj \u00162e{,\u001dbx|c\u0016,r}'\u0016\u0012c{.\u0016\u0004xw/\u0017\u0016hb&[k+2";
                    n3 = 22;
                    continue block35;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "X|\"\u00032c}3\u0001+pf&S2p`\"\u001e'ew1S\u0011aw \u001a$xq\"\u0007+~|";
                    n3 = 23;
                    continue block35;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "D|0\u00062a}1\u0007'u23\u00120p\u007f&\u0007'c20\u0003'r{%\u001a!pf*\u001c,+2";
                    n3 = 24;
                    continue block35;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "{s5\u0012lbw \u00060xf:]1aw ]\u0007RB\"\u0001#|w7\u00160Bb&\u0010";
                    n3 = 25;
                    continue block35;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "Tj \u00162e{,\u001dbx|c\u0016,r}'\u0016\u0007}~*\u00036xq\u0000\u00060gwkZx1";
                    n3 = 26;
                    continue block35;
                }
                case 26: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

