/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.GarbageCollectorMXBeanImpl;
import com.ibm.java.lang.management.internal.LazyDelegatingNotifier;
import com.ibm.java.lang.management.internal.ManagementPermissionHelper;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.MemoryManagerMXBeanImpl;
import com.ibm.java.lang.management.internal.MemoryPoolMXBeanImpl;
import com.ibm.oti.shared.SharedClassStatistics;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;

public class MemoryMXBeanImpl
extends LazyDelegatingNotifier
implements MemoryMXBean {
    private static final MemoryMXBeanImpl instance;
    private static final Constructor<MemoryUsage> memUsageConstructor;
    private final List<MemoryManagerMXBean> memoryManagerList;
    private final List<MemoryPoolMXBean> managedPoolList = new LinkedList<MemoryPoolMXBean>();
    private ObjectName objectName;

    protected MemoryMXBeanImpl() {
        this.memoryManagerList = new LinkedList<MemoryManagerMXBean>();
        this.createMemoryPools();
        this.createMemoryManagers();
        this.setManagedMemoryPoolsForManagers();
    }

    private void setManagedMemoryPoolsForManagers() {
        for (MemoryManagerMXBeanImpl memoryManagerMXBeanImpl : this.memoryManagerList) {
            for (MemoryPoolMXBeanImpl memoryPoolMXBeanImpl : this.managedPoolList) {
                if (memoryManagerMXBeanImpl instanceof GarbageCollectorMXBean) {
                    if (MemoryType.HEAP != memoryPoolMXBeanImpl.getType() || !memoryManagerMXBeanImpl.isManagedPoolImpl(memoryManagerMXBeanImpl.id, memoryPoolMXBeanImpl.getID())) continue;
                    memoryManagerMXBeanImpl.addMemoryPool(memoryPoolMXBeanImpl);
                    continue;
                }
                if (MemoryType.NON_HEAP != memoryPoolMXBeanImpl.getType()) continue;
                memoryManagerMXBeanImpl.addMemoryPool(memoryPoolMXBeanImpl);
            }
        }
    }

    public static MemoryMXBeanImpl getInstance() {
        return instance;
    }

    private native void createMemoryManagers();

    private void createMemoryManagerHelper(String name, int internalID, boolean isGC) {
        MemoryManagerMXBean manager;
        if (isGC) {
            String domainName = "java.lang:type=GarbageCollector";
            manager = this.makeGCBean(domainName, name, internalID);
        } else {
            String domainName = "java.lang:type=MemoryManager";
            manager = new MemoryManagerMXBeanImpl(domainName, name, internalID);
        }
        this.memoryManagerList.add(manager);
    }

    protected GarbageCollectorMXBean makeGCBean(String domainName, String name, int internalID) {
        return new GarbageCollectorMXBeanImpl(domainName, name, internalID, this);
    }

    public List<MemoryManagerMXBean> getMemoryManagerMXBeans(boolean copy) {
        ArrayList list = this.memoryManagerList;
        return copy ? new ArrayList(list) : list;
    }

    public List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        LinkedList<GarbageCollectorMXBean> result = new LinkedList<GarbageCollectorMXBean>();
        for (MemoryManagerMXBean bean : this.memoryManagerList) {
            if (!(bean instanceof GarbageCollectorMXBean)) continue;
            result.add((GarbageCollectorMXBean)bean);
        }
        return result;
    }

    private native void createMemoryPools();

    private void createMemoryPoolHelper(String name, int internalID, boolean isHeap) {
        this.managedPoolList.add(this.makeMemoryPoolBean(name, isHeap ? MemoryType.HEAP : MemoryType.NON_HEAP, internalID));
    }

    protected MemoryPoolMXBean makeMemoryPoolBean(String name, MemoryType type, int internalID) {
        return new MemoryPoolMXBeanImpl(name, type, internalID, this);
    }

    public List<MemoryPoolMXBean> getMemoryPoolMXBeans(boolean copy) {
        ArrayList list = this.managedPoolList;
        return copy ? new ArrayList(list) : list;
    }

    @Override
    public void gc() {
        System.gc();
    }

    private native MemoryUsage getHeapMemoryUsageImpl(Class<MemoryUsage> var1, Constructor<MemoryUsage> var2);

    @Override
    public MemoryUsage getHeapMemoryUsage() {
        if (null != memUsageConstructor) {
            return this.getHeapMemoryUsageImpl(MemoryUsage.class, memUsageConstructor);
        }
        return null;
    }

    private native MemoryUsage getNonHeapMemoryUsageImpl(Class<MemoryUsage> var1, Constructor<MemoryUsage> var2);

    @Override
    public MemoryUsage getNonHeapMemoryUsage() {
        if (null != memUsageConstructor) {
            return this.getNonHeapMemoryUsageImpl(MemoryUsage.class, memUsageConstructor);
        }
        return null;
    }

    private native int getObjectPendingFinalizationCountImpl();

    @Override
    public int getObjectPendingFinalizationCount() {
        return this.getObjectPendingFinalizationCountImpl();
    }

    private native boolean isVerboseImpl();

    @Override
    public boolean isVerbose() {
        return this.isVerboseImpl();
    }

    private native void setVerboseImpl(boolean var1);

    @Override
    public void setVerbose(boolean value) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.setVerboseImpl(value);
    }

    private native long getMaxHeapSizeLimitImpl();

    public long getMaxHeapSizeLimit() {
        return this.getMaxHeapSizeLimitImpl();
    }

    private native long getMaxHeapSizeImpl();

    public long getMaxHeapSize() {
        return this.getMaxHeapSizeImpl();
    }

    private native long getMinHeapSizeImpl();

    public long getMinHeapSize() {
        return this.getMinHeapSizeImpl();
    }

    private native void setMaxHeapSizeImpl(long var1);

    public void setMaxHeapSize(long size) {
        if (!this.isSetMaxHeapSizeSupported()) {
            throw new UnsupportedOperationException();
        }
        if (size < this.getMinHeapSize() || size > this.getMaxHeapSizeLimit()) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.setMaxHeapSizeImpl(size);
    }

    private native boolean isSetMaxHeapSizeSupportedImpl();

    public boolean isSetMaxHeapSizeSupported() {
        return this.isSetMaxHeapSizeSupportedImpl();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[1];
        String[] notifTypes = new String[]{"java.management.memory.threshold.exceeded", "java.management.memory.collection.threshold.exceeded"};
        notifications[0] = new MBeanNotificationInfo(notifTypes, Notification.class.getName(), "Memory Notification");
        return notifications;
    }

    public long getSharedClassCacheSize() {
        return SharedClassStatistics.maxSizeBytes();
    }

    public long getSharedClassCacheSoftmxBytes() {
        return SharedClassStatistics.softmxBytes();
    }

    public long getSharedClassCacheMinAotBytes() {
        return SharedClassStatistics.minAotBytes();
    }

    public long getSharedClassCacheMaxAotBytes() {
        return SharedClassStatistics.maxAotBytes();
    }

    public long getSharedClassCacheMinJitDataBytes() {
        return SharedClassStatistics.minJitDataBytes();
    }

    public long getSharedClassCacheMaxJitDataBytes() {
        return SharedClassStatistics.maxJitDataBytes();
    }

    private native boolean setSharedClassCacheSoftmxBytesImpl(long var1);

    private native boolean setSharedClassCacheMinAotBytesImpl(long var1);

    private native boolean setSharedClassCacheMaxAotBytesImpl(long var1);

    private native boolean setSharedClassCacheMinJitDataBytesImpl(long var1);

    private native boolean setSharedClassCacheMaxJitDataBytesImpl(long var1);

    public boolean setSharedClassCacheSoftmxBytes(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        return this.setSharedClassCacheSoftmxBytesImpl(value);
    }

    public boolean setSharedClassCacheMinAotBytes(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        return this.setSharedClassCacheMinAotBytesImpl(value);
    }

    public boolean setSharedClassCacheMaxAotBytes(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        return this.setSharedClassCacheMaxAotBytesImpl(value);
    }

    public boolean setSharedClassCacheMinJitDataBytes(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        return this.setSharedClassCacheMinJitDataBytesImpl(value);
    }

    public boolean setSharedClassCacheMaxJitDataBytes(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException();
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        return this.setSharedClassCacheMaxJitDataBytesImpl(value);
    }

    private native long getSharedClassCacheSoftmxUnstoredBytesImpl();

    private native long getSharedClassCacheMaxAotUnstoredBytesImpl();

    private native long getSharedClassCacheMaxJitDataUnstoredBytesImpl();

    public long getSharedClassCacheSoftmxUnstoredBytes() {
        return this.getSharedClassCacheSoftmxUnstoredBytesImpl();
    }

    public long getSharedClassCacheMaxAotUnstoredBytes() {
        return this.getSharedClassCacheMaxAotUnstoredBytesImpl();
    }

    public long getSharedClassCacheMaxJitDataUnstoredBytes() {
        return this.getSharedClassCacheMaxJitDataUnstoredBytesImpl();
    }

    public long getSharedClassCacheFreeSpace() {
        return SharedClassStatistics.freeSpaceBytes();
    }

    public String getGCMode() {
        return this.getGCModeImpl();
    }

    private native String getGCModeImpl();

    private native long getGCMainThreadCpuUsedImpl();

    @Deprecated
    public long getGCMasterThreadCpuUsed() {
        return this.getGCMainThreadCpuUsedImpl();
    }

    public long getGCMainThreadCpuUsed() {
        return this.getGCMainThreadCpuUsedImpl();
    }

    private native long getGCWorkerThreadsCpuUsedImpl();

    @Deprecated
    public long getGCSlaveThreadsCpuUsed() {
        return this.getGCWorkerThreadsCpuUsedImpl();
    }

    public long getGCWorkerThreadsCpuUsed() {
        return this.getGCWorkerThreadsCpuUsedImpl();
    }

    private native int getMaximumGCThreadsImpl();

    public int getMaximumGCThreads() {
        return this.getMaximumGCThreadsImpl();
    }

    private native int getCurrentGCThreadsImpl();

    public int getCurrentGCThreads() {
        return this.getCurrentGCThreadsImpl();
    }

    @Override
    public ObjectName getObjectName() {
        if (this.objectName == null) {
            this.objectName = ManagementUtils.createObjectName("java.lang:type=Memory");
        }
        return this.objectName;
    }

    protected void startNotificationThread() {
    }

    static {
        Constructor constructor;
        instance = new MemoryMXBeanImpl();
        try {
            constructor = MemoryUsage.class.getConstructor(Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            constructor = null;
        }
        memUsageConstructor = constructor;
    }
}

