/*
 * Decompiled with CFR 0.152.
 */
package javax.security.sasl;

import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class Sasl {
    public static final String QOP = "javax.security.sasl.qop";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String SERVER_AUTH = "javax.security.sasl.server.authentication";
    public static final String BOUND_SERVER_NAME = "javax.security.sasl.bound.server.name";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String RAW_SEND_SIZE = "javax.security.sasl.rawsendsize";
    public static final String REUSE = "javax.security.sasl.reuse";
    public static final String POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";
    public static final String CREDENTIALS = "javax.security.sasl.credentials";

    private Sasl() {
    }

    public static SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslClient mech = null;
        for (int i = 0; i < mechanisms.length; ++i) {
            String mechName = mechanisms[i];
            if (mechName == null) {
                throw new NullPointerException("Mechanism name cannot be null");
            }
            if (mechName.length() == 0) continue;
            String mechFilter = "SaslClientFactory." + mechName;
            Provider[] provs = Security.getProviders(mechFilter);
            for (int j = 0; provs != null && j < provs.length; ++j) {
                SaslClientFactory fac;
                String className = provs[j].getProperty(mechFilter);
                if (className == null || (fac = (SaslClientFactory)Sasl.loadFactory(provs[j], className)) == null || (mech = fac.createSaslClient(new String[]{mechanisms[i]}, authorizationId, protocol, serverName, props, cbh)) == null) continue;
                return mech;
            }
        }
        return null;
    }

    private static Object loadFactory(Provider p, String className) throws SaslException {
        try {
            ClassLoader cl = p.getClass().getClassLoader();
            Class<?> implClass = Class.forName(className, true, cl);
            return implClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SaslException("Cannot load class " + className, e);
        }
        catch (InstantiationException e) {
            throw new SaslException("Cannot instantiate class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new SaslException("Cannot access class " + className, e);
        }
        catch (SecurityException e) {
            throw new SaslException("Cannot access class " + className, e);
        }
    }

    public static SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslServer mech = null;
        if (mechanism == null) {
            throw new NullPointerException("Mechanism name cannot be null");
        }
        if (mechanism.length() == 0) {
            return null;
        }
        String mechFilter = "SaslServerFactory." + mechanism;
        Provider[] provs = Security.getProviders(mechFilter);
        for (int j = 0; provs != null && j < provs.length; ++j) {
            String className = provs[j].getProperty(mechFilter);
            if (className == null) {
                throw new SaslException("Provider does not support " + mechFilter);
            }
            SaslServerFactory fac = (SaslServerFactory)Sasl.loadFactory(provs[j], className);
            if (fac == null || (mech = fac.createSaslServer(mechanism, protocol, serverName, props, cbh)) == null) continue;
            return mech;
        }
        return null;
    }

    public static Enumeration<SaslClientFactory> getSaslClientFactories() {
        Set<Object> facs = Sasl.getFactories("SaslClientFactory");
        final Iterator<Object> iter = facs.iterator();
        return new Enumeration<SaslClientFactory>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public SaslClientFactory nextElement() {
                return (SaslClientFactory)iter.next();
            }
        };
    }

    public static Enumeration<SaslServerFactory> getSaslServerFactories() {
        Set<Object> facs = Sasl.getFactories("SaslServerFactory");
        final Iterator<Object> iter = facs.iterator();
        return new Enumeration<SaslServerFactory>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public SaslServerFactory nextElement() {
                return (SaslServerFactory)iter.next();
            }
        };
    }

    private static Set<Object> getFactories(String serviceName) {
        HashSet<Object> result = new HashSet<Object>();
        if (serviceName == null || serviceName.length() == 0 || serviceName.endsWith(".")) {
            return result;
        }
        Provider[] providers = Security.getProviders();
        HashSet<String> classes = new HashSet<String>();
        for (int i = 0; i < providers.length; ++i) {
            classes.clear();
            Enumeration<Object> e = providers[i].keys();
            while (e.hasMoreElements()) {
                String className;
                String currentKey = (String)e.nextElement();
                if (!currentKey.startsWith(serviceName) || currentKey.indexOf(" ") >= 0 || classes.contains(className = providers[i].getProperty(currentKey))) continue;
                classes.add(className);
                try {
                    Object fac = Sasl.loadFactory(providers[i], className);
                    if (fac == null) continue;
                    result.add(fac);
                }
                catch (Exception ignore) {}
            }
        }
        return Collections.unmodifiableSet(result);
    }
}

