/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.ProgramOption;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

class MessageFile
extends ProgramOption {
    List messageFiles = new LinkedList();

    MessageFile() {
    }

    String getDescription() {
        return "A comma separated list of files containing the trace format strings. By default the following files are used:" + System.getProperty("line.separator") + "\t\t$JAVA_HOME/lib/J9TraceFormat.dat" + System.getProperty("line.separator") + "\t\t$JAVA_HOME/lib/TraceFormat.dat";
    }

    String getName() {
        return "datfile";
    }

    String getUsage() {
        return "-datfile=file";
    }

    Object getValue() {
        return this.messageFiles;
    }

    void setValue(String value) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(value, ",");
        String token = "";
        try {
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                File datFile = new File(token);
                if (!datFile.exists()) {
                    throw new FileNotFoundException(token);
                }
                this.messageFiles.add(datFile);
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("dat file \"" + token + "\" not found");
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("The application does not have permission to access the specified dat file, \"" + token + "\"");
        }
    }

    void setDefault() {
        String dir = System.getProperty("java.home");
        dir = dir.concat(File.separator).concat("lib").concat(File.separator);
        this.setValue(dir + "J9TraceFormat.dat");
        try {
            this.setValue(dir + "TraceFormat.dat");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Warning: " + e.getMessage());
        }
    }
}

