/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.stacks;

import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.impl.data.EventDataPoint;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceAxisUtil;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TraceMetaData;
import com.ibm.java.diagnostics.healthcenter.jvmtrace.TracePoint;
import com.ibm.java.diagnostics.healthcenter.stacks.CallStack;
import com.ibm.java.diagnostics.healthcenter.stacks.StackEntry;

public class StackTraceDataPoint
extends EventDataPoint {
    private final CallStack stack = new CallStack();
    private String triggerID;
    private static final String EMPTY_STRING = "";

    public StackTraceDataPoint(AxisPair axisPair, TracePoint tracePoint, TraceMetaData traceMetaData) {
        super(0, TraceAxisUtil.getTimestampMS(tracePoint, traceMetaData), axisPair);
        this.triggerID = tracePoint.getComponent() + "." + tracePoint.getID();
    }

    public CallStack getStack() {
        return this.stack;
    }

    public String getTriggerID() {
        return this.triggerID;
    }

    public void addStackEntry(int n, StackEntry stackEntry) {
        this.stack.addStackEntry(n, stackEntry);
    }

    public String getStackTop() {
        StackEntry stackEntry = this.stack.getStackEntry(0);
        if (stackEntry == null) {
            return EMPTY_STRING;
        }
        return stackEntry.getEntry();
    }
}

