/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.methodtrace.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TableDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.common.datamodel.impl.converters.UnitLabels;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TableDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.methodtrace.Messages;
import com.ibm.java.diagnostics.healthcenter.methodtrace.MethodTraceLabels;
import com.ibm.java.diagnostics.healthcenter.methodtrace.data.MethodTraceExitDataPoint;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import java.text.MessageFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class MethodTracePostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(MethodTracePostProcessor.class);
    private static final String EMPTY_STRING = "";
    private final String className = this.getClass().getName();
    private StructuredStringDataBuilder recommendations;

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(this.className, "postprocess");
        this.recommendations = new StructuredStringDataImpl(MethodTraceLabels.RECOMMENDATION_LABEL);
        this.addSummaryData(dataBuilder);
        TRACE.exiting(this.className, "postprocess");
    }

    private void addSummaryData(DataBuilder dataBuilder) {
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.METHODTRACE);
        if (subsystemDataBuilder == null) {
            return;
        }
        TableDataImpl tableDataImpl = new TableDataImpl(MethodTraceLabels.METHOD_SUMMARY, new String[]{Messages.getString("MethodTrace.summary.table.column.name"), Messages.getString("MethodTrace.summary.table.column.count"), Messages.getString("MethodTrace.summary.table.column.max"), Messages.getString("MethodTrace.summary.table.column.mean"), Messages.getString("MethodTrace.summary.table.column.total")});
        this.calculateMethodStatistics(subsystemDataBuilder, tableDataImpl);
        subsystemDataBuilder.addData(tableDataImpl);
        DataBuilder[] dataBuilderArray = subsystemDataBuilder.getChildren();
        int n = 0;
        if (dataBuilderArray != null) {
            for (DataBuilder dataBuilder2 : dataBuilderArray) {
                if (!(dataBuilder2 instanceof StringDataBuilder) || dataBuilder2 instanceof StructuredStringDataImpl) continue;
                ++n;
            }
        }
        String string = MessageFormat.format(Messages.getString("MethodTrace.postprocessor.number.methods"), n);
        this.recommendations.addGoodThing(string);
        this.setHighLevelMessage(subsystemDataBuilder, this.recommendations);
    }

    private void calculateMethodStatistics(Data data, TableDataBuilder tableDataBuilder) {
        Data[] dataArray = data.getChildren();
        if (dataArray != null) {
            for (Data data2 : dataArray) {
                if (!(data2 instanceof StringDataBuilder)) continue;
                Data[] dataArray2 = data2.getChildren();
                double d = 0.0;
                double d2 = Double.MAX_VALUE;
                double d3 = 0.0;
                int n = 0;
                String string = null;
                if (dataArray2 == null) continue;
                for (Data data3 : dataArray2) {
                    if (!(data3 instanceof TwoDimensionalDataBuilder)) continue;
                    List<DataPointBuilder> list = ((TwoDimensionalDataBuilder)data3).getAllDataPoints();
                    ListIterator<DataPointBuilder> listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        DataPointBuilder dataPointBuilder = listIterator.next();
                        if (!(dataPointBuilder instanceof MethodTraceExitDataPoint)) continue;
                        MethodTraceExitDataPoint methodTraceExitDataPoint = (MethodTraceExitDataPoint)dataPointBuilder;
                        double d4 = methodTraceExitDataPoint.getDurationTime();
                        if (d4 > d) {
                            d = d4;
                            string = data3.getLabel();
                        } else if (d4 <= d2) {
                            d2 = d4;
                        }
                        d3 += d4;
                        ++n;
                    }
                }
                String string2 = ((TwoDimensionalDataBuilder)dataArray2[0]).getXAxis().getUnits();
                int n2 = 1;
                String object = UnitLabels.MILLISECONDS;
                tableDataBuilder.addRow(new Object[]{data2.getLabel(), n, NumberFormatter.prettyString(d / (double)n2) + " " + object, NumberFormatter.prettyString(d3 / (double)n / (double)n2) + " " + object, NumberFormatter.prettyString(d3 / (double)n2) + " " + object});
                String string3 = MessageFormat.format(Messages.getString("MethodTrace.postprocessor.longest.run"), data2.getLabel(), string);
                this.recommendations.addInformation(string3);
                ((SubsystemDataBuilder)data).addData(this.recommendations);
            }
        }
    }
}

